/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.util;

import com.google.common.io.CharStreams;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;
import io.digdag.spi.TaskRequest;
import io.digdag.spi.TemplateEngine;
import io.digdag.spi.TemplateException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class Workspace
implements Closeable {
    private final Path projectPath;
    private final List<Path> tempFilePaths = new ArrayList<Path>();
    private Path workspacePath;

    public static Workspace ofTaskRequest(Path projectPath, TaskRequest taskRequest) {
        return Workspace.of(projectPath, (String)taskRequest.getConfig().get("_workdir", String.class, (Object)""));
    }

    public static Workspace of(Path projectPath, String workdir) {
        return new Workspace(projectPath, workdir);
    }

    private Workspace(Path projectPath, String workdir) {
        this.projectPath = projectPath.normalize().toAbsolutePath();
        this.workspacePath = Workspace.resolveWorkspacePath(projectPath, workdir);
    }

    private static Path resolveWorkspacePath(Path projectPath, String workdir) {
        Path path = projectPath.resolve(workdir).normalize().toAbsolutePath();
        if (!path.toString().startsWith(projectPath.toString())) {
            throw new IllegalArgumentException("Working directory must not be outside of project path (" + projectPath + "): " + workdir);
        }
        return path;
    }

    public Path getProjectPath() {
        return this.projectPath;
    }

    public Path getPath() {
        return this.workspacePath;
    }

    public Path getPath(String fileName) {
        Path path = this.workspacePath.resolve(fileName);
        if (!path.normalize().toString().startsWith(this.projectPath.toString())) {
            throw new IllegalArgumentException("File name must not be outside of project path (" + this.projectPath + "): " + fileName);
        }
        return path;
    }

    public File getFile(String relative) {
        return this.getPath(relative).toFile();
    }

    public Path createTempDir(String prefix) throws IOException {
        return Files.createTempDirectory(this.getTempDir(), prefix, new FileAttribute[0]);
    }

    public Path createTempFile(String prefix, String suffix) throws IOException {
        Path path = Files.createTempFile(this.getTempDir(), prefix, suffix, new FileAttribute[0]);
        this.tempFilePaths.add(path);
        return path;
    }

    public InputStream newInputStream(String fileName) throws IOException {
        return Files.newInputStream(this.getPath(fileName), new OpenOption[0]);
    }

    public BufferedReader newBufferedReader(String fileName, Charset cs) throws IOException {
        return Files.newBufferedReader(this.getPath(fileName), cs);
    }

    public OutputStream newOutputStream(String fileName) throws IOException {
        return Files.newOutputStream(this.getPath(fileName), new OpenOption[0]);
    }

    public BufferedWriter newBufferedWriter(String fileName, Charset cs) throws IOException {
        return Files.newBufferedWriter(this.getPath(fileName), cs, new OpenOption[0]);
    }

    private synchronized Path getTempDir() throws IOException {
        Path dir = this.projectPath.resolve(".digdag/tmp");
        Files.createDirectories(dir, new FileAttribute[0]);
        return dir;
    }

    public String templateFile(TemplateEngine templateEngine, String fileName, Charset fileCharset, Config params) throws IOException, TemplateException {
        try (BufferedReader reader = this.newBufferedReader(fileName, fileCharset);){
            String content = CharStreams.toString((Readable)reader);
            String string = templateEngine.template(content, params);
            return string;
        }
    }

    public String templateCommand(TemplateEngine templateEngine, Config params, String aliasKey, Charset fileCharset) {
        if (params.has("_command")) {
            Config nested;
            try {
                nested = params.getNested("_command");
            }
            catch (ConfigException notNested) {
                String fileName = (String)params.get("_command", String.class);
                try {
                    return this.templateFile(templateEngine, fileName, fileCharset, params);
                }
                catch (ConfigException ex) {
                    throw ex;
                }
                catch (TemplateException ex) {
                    throw new ConfigException(String.format(Locale.ENGLISH, "%s in %s", ex.getMessage(), fileName), (Throwable)ex);
                }
                catch (IOException ex) {
                    throw Workspace.propagateIoException(ex, fileName, ConfigException::new);
                }
                catch (RuntimeException ex) {
                    throw new ConfigException(String.format(Locale.ENGLISH, "%s: %s", ex.getMessage(), fileName), (Throwable)ex);
                }
            }
            return (String)nested.get("data", String.class);
        }
        if (aliasKey != null) {
            return (String)params.get(aliasKey, String.class);
        }
        return (String)params.get("_command", String.class);
    }

    @Override
    public void close() {
        for (Path path : this.tempFilePaths) {
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException iOException) {}
        }
    }

    public static <E extends RuntimeException> E propagateIoException(IOException ex, String fileName, ExceptionFactory<E> factory) {
        if (ex instanceof FileNotFoundException || ex instanceof NoSuchFileException) {
            return (E)((RuntimeException)factory.newInstance(String.format(Locale.ENGLISH, "File not found: %s", ex.getMessage()), ex));
        }
        return (E)((RuntimeException)factory.newInstance(String.format(Locale.ENGLISH, "Failed to read file: %s: %s", fileName, ex.getClass()), ex));
    }

    public static interface ExceptionFactory<E> {
        public E newInstance(String var1, Throwable var2);
    }
}

