/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;

public class RetryExecutor {
    private final int retryLimit;
    private final int initialRetryWait;
    private final int maxRetryWait;
    private final double waitGrowRate;
    private final RetryPredicate retryPredicate;
    private final RetryAction retryAction;
    private final GiveupAction giveupAction;

    public static RetryExecutor retryExecutor() {
        return new RetryExecutor();
    }

    private RetryExecutor() {
        this(5, 1000, 1800000, 3.0, null, null, null);
    }

    private RetryExecutor(int retryLimit, int initialRetryWait, int maxRetryWait, double waitGrowRate, RetryPredicate retryPredicate, RetryAction retryAction, GiveupAction giveupAction) {
        this.retryLimit = retryLimit;
        this.initialRetryWait = initialRetryWait;
        this.maxRetryWait = maxRetryWait;
        this.waitGrowRate = waitGrowRate;
        this.retryPredicate = retryPredicate;
        this.retryAction = retryAction;
        this.giveupAction = giveupAction;
    }

    public RetryExecutor withRetryLimit(int count) {
        return new RetryExecutor(count, this.initialRetryWait, this.maxRetryWait, this.waitGrowRate, this.retryPredicate, this.retryAction, this.giveupAction);
    }

    public RetryExecutor withInitialRetryWait(int msec) {
        return new RetryExecutor(this.retryLimit, msec, this.maxRetryWait, this.waitGrowRate, this.retryPredicate, this.retryAction, this.giveupAction);
    }

    public RetryExecutor withMaxRetryWait(int msec) {
        return new RetryExecutor(this.retryLimit, this.initialRetryWait, msec, this.waitGrowRate, this.retryPredicate, this.retryAction, this.giveupAction);
    }

    public RetryExecutor withWaitGrowRate(double rate) {
        return new RetryExecutor(this.retryLimit, this.initialRetryWait, this.maxRetryWait, rate, this.retryPredicate, this.retryAction, this.giveupAction);
    }

    public RetryExecutor retryIf(RetryPredicate function) {
        return new RetryExecutor(this.retryLimit, this.initialRetryWait, this.maxRetryWait, this.waitGrowRate, function, this.retryAction, this.giveupAction);
    }

    public RetryExecutor onRetry(RetryAction function) {
        return new RetryExecutor(this.retryLimit, this.initialRetryWait, this.maxRetryWait, this.waitGrowRate, this.retryPredicate, function, this.giveupAction);
    }

    public RetryExecutor onGiveup(GiveupAction function) {
        return new RetryExecutor(this.retryLimit, this.initialRetryWait, this.maxRetryWait, this.waitGrowRate, this.retryPredicate, this.retryAction, function);
    }

    public <T> T runInterruptible(Callable<T> op) throws InterruptedException, RetryGiveupException {
        return this.run(op, true);
    }

    public void runInterruptible(Runnable op) throws InterruptedException, RetryGiveupException {
        this.runInterruptible(() -> {
            op.run();
            return null;
        });
    }

    public <T> T run(Callable<T> op) throws RetryGiveupException {
        try {
            return this.run(op, false);
        }
        catch (InterruptedException ex) {
            throw new RetryGiveupException("Unexpected interruption", ex);
        }
    }

    public void run(Runnable op) throws RetryGiveupException {
        this.run(() -> {
            op.run();
            return null;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T run(Callable<T> op, boolean interruptible) throws InterruptedException, RetryGiveupException {
        int retryCount = 0;
        Exception firstException = null;
        while (true) {
            try {
                return op.call();
            }
            catch (Exception exception) {
                if (firstException == null) {
                    firstException = exception;
                }
                if (retryCount >= this.retryLimit || this.retryPredicate == null || !this.retryPredicate.test(exception)) {
                    if (this.giveupAction == null) throw new RetryGiveupException(firstException);
                    this.giveupAction.onGiveup(firstException, exception);
                    throw new RetryGiveupException(firstException);
                }
                int retryWait = (int)Math.min((double)this.maxRetryWait, (double)this.initialRetryWait * Math.pow(this.waitGrowRate, retryCount));
                ++retryCount;
                if (this.retryAction != null) {
                    this.retryAction.onRetry(exception, retryCount, this.retryLimit, retryWait);
                }
                try {
                    Thread.sleep(retryWait);
                    continue;
                }
                catch (InterruptedException ex) {
                    if (interruptible) throw ex;
                    continue;
                }
            }
            break;
        }
    }

    public static interface GiveupAction {
        public void onGiveup(Exception var1, Exception var2) throws RetryGiveupException;
    }

    public static interface RetryAction {
        public void onRetry(Exception var1, int var2, int var3, int var4) throws RetryGiveupException;
    }

    public static interface RetryPredicate
    extends Predicate<Exception> {
    }

    public static class RetryGiveupException
    extends ExecutionException {
        public RetryGiveupException(String message, Exception cause) {
            super(cause);
        }

        public RetryGiveupException(Exception cause) {
            super(cause);
        }

        @Override
        public Exception getCause() {
            return (Exception)super.getCause();
        }
    }
}

