/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Optional;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;

public class RetryControl {
    private final Config stateParams;
    private final int retryLimit;
    private final int retryCount;
    private final int retryInterval;
    private final Optional<Integer> maxRetryInterval;
    private final RetryIntervalType retryIntervalType;

    public static RetryControl prepare(Config config, Config stateParams, boolean enableByDefault) {
        return new RetryControl(config, stateParams, enableByDefault);
    }

    private RetryControl(Config config, Config stateParams, boolean enableByDefault) {
        block6: {
            this.stateParams = stateParams;
            this.retryCount = (Integer)stateParams.get("retry_count", Integer.TYPE, (Object)0);
            JsonNode retryNode = config.getInternalObjectNode().get("_retry");
            try {
                if (retryNode == null) {
                    this.retryLimit = enableByDefault ? 3 : 0;
                    this.retryInterval = 0;
                    this.maxRetryInterval = Optional.absent();
                    this.retryIntervalType = RetryIntervalType.CONSTATNT;
                    break block6;
                }
                if (retryNode.isNumber() || retryNode.isTextual()) {
                    this.retryLimit = (Integer)config.get("_retry", Integer.TYPE);
                    this.retryInterval = 0;
                    this.maxRetryInterval = Optional.absent();
                    this.retryIntervalType = RetryIntervalType.CONSTATNT;
                    break block6;
                }
                if (retryNode.isObject()) {
                    Config retry = config.getNested("_retry");
                    this.retryLimit = (Integer)retry.get("limit", Integer.TYPE);
                    this.retryInterval = (Integer)retry.getOptional("interval", Integer.TYPE).or((Object)0);
                    this.maxRetryInterval = retry.getOptional("max_interval", Integer.TYPE);
                    this.retryIntervalType = (RetryIntervalType)((Object)retry.getOptional("interval_type", String.class).transform(RetryIntervalType::find).or((Object)RetryIntervalType.CONSTATNT));
                    break block6;
                }
                throw new ConfigException(String.format("Invalid _retry format:%s", retryNode.toString()));
            }
            catch (NumberFormatException nfe) {
                throw new ConfigException((Throwable)nfe);
            }
            catch (ConfigException ce) {
                throw ce;
            }
        }
    }

    public int getNextRetryInterval() {
        int retryCount = (Integer)this.stateParams.get("retry_count", Integer.TYPE, (Object)0);
        int interval = 0;
        switch (this.retryIntervalType) {
            case CONSTATNT: {
                interval = this.retryInterval;
                break;
            }
            case EXPONENTIAL: {
                interval = this.retryInterval * (int)Math.pow(2.0, retryCount);
                if (!this.maxRetryInterval.isPresent()) break;
                interval = Math.min(interval, (Integer)this.maxRetryInterval.get());
            }
        }
        return interval;
    }

    public Config getNextRetryStateParams() {
        return this.stateParams.deepCopy().set("retry_count", (Object)(this.retryCount + 1));
    }

    public boolean evaluate() {
        return this.retryLimit > this.retryCount;
    }

    private static enum RetryIntervalType {
        CONSTATNT("constant"),
        EXPONENTIAL("exponential");

        String type;

        private RetryIntervalType(String type) {
            this.type = type;
        }

        public static RetryIntervalType find(String value) {
            for (RetryIntervalType r : RetryIntervalType.values()) {
                if (!r.type.equalsIgnoreCase(value)) continue;
                return r;
            }
            throw new ConfigException("Invalid retry_interval_type: " + value);
        }
    }
}

