/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.util;

import java.io.IOException;
import java.io.InputStream;

public class ResumableInputStream
extends InputStream {
    private final Reopener reopener;
    protected InputStream in;
    private long offset;

    public ResumableInputStream(InputStream initialInputStream, Reopener reopener) {
        this.reopener = reopener;
        this.in = initialInputStream;
        this.offset = 0L;
    }

    public ResumableInputStream(Reopener reopener) throws IOException {
        this(reopener.reopen(0L, null), reopener);
    }

    private synchronized void reopen(Exception closedCause) throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
        this.in = this.reopener.reopen(this.offset, closedCause);
    }

    @Override
    public int read() throws IOException {
        while (true) {
            try {
                int v = this.in.read();
                if (v >= 0) {
                    ++this.offset;
                }
                return v;
            }
            catch (IOException | RuntimeException ex) {
                this.reopen(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        while (true) {
            try {
                int r = this.in.read(b);
                if (r > 0) {
                    this.offset += (long)r;
                }
                return r;
            }
            catch (IOException | RuntimeException ex) {
                this.reopen(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        while (true) {
            try {
                int r = this.in.read(b, off, len);
                if (r > 0) {
                    this.offset += (long)r;
                }
                return r;
            }
            catch (IOException | RuntimeException ex) {
                this.reopen(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        while (true) {
            try {
                long r = this.in.skip(n);
                if (r > 0L) {
                    this.offset += r;
                }
                return r;
            }
            catch (IOException | RuntimeException ex) {
                this.reopen(ex);
                continue;
            }
            break;
        }
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public static interface Reopener {
        public InputStream reopen(long var1, Exception var3) throws IOException;
    }
}

