/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.util;

import com.fasterxml.jackson.databind.JsonNode;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;

public class ParallelControl {
    private static final String PARALLEL_KEY = "_parallel";
    private final Config config;
    private final boolean isParallel;
    private final int parallelLimit;

    public static ParallelControl of(Config config) {
        return new ParallelControl(config);
    }

    private ParallelControl(Config config) {
        this.config = config;
        JsonNode parallelNode = config.getInternalObjectNode().get(PARALLEL_KEY);
        if (parallelNode == null) {
            this.isParallel = false;
            this.parallelLimit = 0;
        } else if (parallelNode.isBoolean() || parallelNode.isTextual()) {
            this.isParallel = (Boolean)config.get(PARALLEL_KEY, Boolean.TYPE, (Object)false);
            this.parallelLimit = 0;
        } else if (parallelNode.isObject()) {
            Config parallel = config.getNested(PARALLEL_KEY);
            this.isParallel = true;
            this.parallelLimit = (Integer)parallel.get("limit", Integer.TYPE);
        } else {
            throw new ConfigException(String.format("Invalid _parallel format: %s", parallelNode.toString()));
        }
    }

    public void copyIfNeeded(Config dst) {
        if (this.isParallel()) {
            dst.set(PARALLEL_KEY, this.config.get(PARALLEL_KEY, JsonNode.class));
        }
    }

    public boolean isParallel() {
        return this.isParallel;
    }

    public int getParallelLimit() {
        return this.parallelLimit;
    }
}

