/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Md5CountInputStream
extends FilterInputStream {
    private static final MessageDigest MD5;
    private byte[] tempBuffer;
    private final MessageDigest md5;
    private long count;

    public static byte[] digestMd5(byte[] data) {
        try {
            MessageDigest md5 = (MessageDigest)MD5.clone();
            return md5.digest(data);
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to initialize MD5 digest", ex);
        }
    }

    public Md5CountInputStream(InputStream in) {
        super(in);
        try {
            this.md5 = (MessageDigest)MD5.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to initialize MD5 digest", ex);
        }
        this.count = 0L;
    }

    public long getCount() {
        return this.count;
    }

    public byte[] getDigest() {
        return this.md5.digest();
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            ++this.count;
            this.md5.update((byte)c);
        }
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.in.read(b, off, len);
        if (n > 0) {
            this.count += (long)n;
            this.md5.update(b, off, n);
        }
        return n;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.tempBuffer == null) {
            this.tempBuffer = new byte[32768];
        }
        return this.read(this.tempBuffer, 0, (int)Math.min(n, (long)this.tempBuffer.length));
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    static {
        try {
            MD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }
}

