/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.digdag.util.Durations;
import java.time.Duration;

public class DurationParam {
    private final Duration duration;

    private DurationParam(Duration duration) {
        this.duration = duration;
    }

    public Duration getDuration() {
        return this.duration;
    }

    @JsonCreator
    public static DurationParam parse(String expr) {
        return new DurationParam(Durations.parseDuration(expr));
    }

    public static DurationParam of(Duration duration) {
        return new DurationParam(duration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DurationParam that = (DurationParam)o;
        return this.duration != null ? this.duration.equals(that.duration) : that.duration == null;
    }

    public int hashCode() {
        return this.duration != null ? this.duration.hashCode() : 0;
    }

    @JsonValue
    public String toString() {
        return Durations.formatDuration(this.duration);
    }
}

