/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.util;

import io.digdag.client.config.ConfigException;
import io.digdag.spi.PrivilegedVariables;
import java.util.Map;
import java.util.regex.Pattern;

public class CommandOperators {
    private static final Pattern VALID_ENV_KEY = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9]*");

    public static void collectEnvironmentVariables(Map<String, String> env, PrivilegedVariables variables) {
        for (String name : variables.getKeys()) {
            if (!VALID_ENV_KEY.matcher(name).matches()) {
                throw new ConfigException("Invalid _env key name: " + name);
            }
            env.put(name, variables.get(name));
        }
    }

    public static boolean isValidEnvKey(String key) {
        return VALID_ENV_KEY.matcher(key).matches();
    }
}

