/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.util;

import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigElement;
import io.digdag.spi.Operator;
import io.digdag.spi.OperatorContext;
import io.digdag.spi.TaskExecutionException;
import io.digdag.spi.TaskRequest;
import io.digdag.spi.TaskResult;
import io.digdag.util.RetryControl;
import io.digdag.util.Workspace;

public abstract class BaseOperator
implements Operator {
    protected final OperatorContext context;
    protected final TaskRequest request;
    protected final Workspace workspace;

    public BaseOperator(OperatorContext context) {
        this.context = context;
        this.request = context.getTaskRequest();
        this.workspace = Workspace.ofTaskRequest(context.getProjectPath(), this.request);
    }

    public TaskResult run() {
        RetryControl retry = RetryControl.prepare(this.request.getConfig(), this.request.getLastStateParams(), false);
        try {
            TaskResult taskResult = this.runTask();
            this.workspace.close();
            return taskResult;
        }
        catch (Throwable throwable) {
            try {
                this.workspace.close();
                throw throwable;
            }
            catch (RuntimeException ex) {
                boolean doRetry;
                if (ex instanceof TaskExecutionException) {
                    boolean isPolling;
                    TaskExecutionException tex = (TaskExecutionException)ex;
                    boolean bl = isPolling = !tex.isError();
                    if (isPolling) {
                        throw tex;
                    }
                }
                if (doRetry = retry.evaluate()) {
                    Config nextStateParams = retry.getNextRetryStateParams().remove("commandStatus");
                    throw TaskExecutionException.ofNextPollingWithCause((Throwable)ex, (int)retry.getNextRetryInterval(), (ConfigElement)ConfigElement.copyOf((Config)nextStateParams));
                }
                throw ex;
            }
        }
    }

    public abstract TaskResult runTask();
}

