/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.util;

import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;
import io.digdag.util.DurationParam;
import io.digdag.util.Durations;
import java.time.Duration;
import java.util.Locale;

public abstract class AbstractWaitOperatorFactory {
    static final int JOB_STATUS_API_POLL_INTERVAL = 5;
    private static final Duration DEFAULT_MIN_POLL_INTERVAL = Duration.ofSeconds(30L);
    private static final Duration DEFAULT_MAX_POLL_INTERVAL = Duration.ofDays(2L);
    private static final Duration DEFAULT_POLL_INTERVAL = Duration.ofMinutes(10L);
    private static final String POLL_INTERVAL_FORMAT = "config.%s.poll_interval";
    private static final String MIN_POLL_INTERVAL_FORMAT = "config.%s.min_poll_interval";
    private static final String MAX_POLL_INTERVAL_FORMAT = "config.%s.max_poll_interval";
    private final Duration minPollInterval;
    private final Duration maxPollInterval;
    private final Duration pollInterval;

    protected AbstractWaitOperatorFactory(String operatorType, Config systemConfig) {
        String pollIntervalKey = String.format(Locale.ENGLISH, POLL_INTERVAL_FORMAT, operatorType);
        String minPollIntervalKey = String.format(Locale.ENGLISH, MIN_POLL_INTERVAL_FORMAT, operatorType);
        String maxPollIntervalKey = String.format(Locale.ENGLISH, MAX_POLL_INTERVAL_FORMAT, operatorType);
        this.minPollInterval = (Duration)systemConfig.getOptional(minPollIntervalKey, DurationParam.class).transform(DurationParam::getDuration).or((Object)DEFAULT_MIN_POLL_INTERVAL);
        if (this.minPollInterval.getSeconds() < 0L || this.minPollInterval.getSeconds() > Integer.MAX_VALUE) {
            throw new ConfigException("invalid configuration value: " + minPollIntervalKey);
        }
        this.maxPollInterval = (Duration)systemConfig.getOptional(maxPollIntervalKey, DurationParam.class).transform(DurationParam::getDuration).or((Object)DEFAULT_MAX_POLL_INTERVAL);
        if (this.maxPollInterval.getSeconds() < this.minPollInterval.getSeconds() || this.maxPollInterval.getSeconds() > Integer.MAX_VALUE) {
            throw new ConfigException("invalid configuration value: " + maxPollIntervalKey);
        }
        this.pollInterval = (Duration)systemConfig.getOptional(pollIntervalKey, DurationParam.class).transform(DurationParam::getDuration).or((Object)this.max(this.minPollInterval, DEFAULT_POLL_INTERVAL));
        if (this.pollInterval.getSeconds() < this.minPollInterval.getSeconds() || this.pollInterval.getSeconds() > this.maxPollInterval.getSeconds()) {
            throw new ConfigException("invalid configuration value: " + pollIntervalKey);
        }
    }

    private Duration max(Duration a, Duration b) {
        return a.compareTo(b) < 0 ? a : b;
    }

    public int getPollInterval(Config params) {
        long interval = this.validatePollInterval(((DurationParam)params.get("interval", DurationParam.class, (Object)DurationParam.of(this.pollInterval))).getDuration().getSeconds());
        assert (interval >= 0L && interval <= Integer.MAX_VALUE);
        return (int)interval;
    }

    private long validatePollInterval(long interval) {
        if (interval < this.minPollInterval.getSeconds() || interval > this.maxPollInterval.getSeconds()) {
            throw new ConfigException("poll interval must be at least " + Durations.formatDuration(this.minPollInterval) + " and no greater than " + Durations.formatDuration(this.maxPollInterval));
        }
        return interval;
    }
}

