/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.util;

import io.digdag.util.ResumableInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class ResumableInputStreamTest {
    static final int IO_EXCEPTION = -2;
    static final int RUNTIME_EXCEPTION = -3;

    @Test
    public void readReadsFromNext() throws Exception {
        ResumableInputStream in = new ResumableInputStream((InputStream)new TestingInputStream(1, 2, -1, -1), (ResumableInputStream.Reopener)new SimpleReopener(null));
        MatcherAssert.assertThat((Object)in.read(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)in.read(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)in.read(), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)in.read(), (Matcher)Matchers.is((Object)-1));
    }

    @Test
    public void readReadsFromNextWithBytes() throws Exception {
        ResumableInputStream in = new ResumableInputStream((InputStream)new TestingInputStream(1, 2, -1, -1), (ResumableInputStream.Reopener)new SimpleReopener(null));
        MatcherAssert.assertThat((Object)in.read(new byte[1]), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)in.read(new byte[1]), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)in.read(new byte[1]), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)in.read(new byte[1]), (Matcher)Matchers.is((Object)-1));
    }

    @Test
    public void readReadsFromNextWithBytesAndOffset() throws Exception {
        ResumableInputStream in = new ResumableInputStream((InputStream)new TestingInputStream(1, 2, -1, -1), (ResumableInputStream.Reopener)new SimpleReopener(null));
        MatcherAssert.assertThat((Object)in.read(new byte[1], 0, 1), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)in.read(new byte[1], 0, 1), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)in.read(new byte[1], 0, 1), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)in.read(new byte[1], 0, 1), (Matcher)Matchers.is((Object)-1));
    }

    @Test
    public void skipSkipsFromNext() throws Exception {
        ResumableInputStream in = new ResumableInputStream((InputStream)new TestingInputStream(1, 2, -1, -1), (ResumableInputStream.Reopener)new SimpleReopener(null));
        MatcherAssert.assertThat((Object)in.skip(1L), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)in.skip(1L), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((Object)in.skip(1L), (Matcher)Matchers.is((Object)-1L));
        MatcherAssert.assertThat((Object)in.skip(1L), (Matcher)Matchers.is((Object)-1L));
    }

    @Test
    public void closeClosesNext() throws Exception {
        TestingInputStream next = new TestingInputStream(-1);
        ResumableInputStream in = new ResumableInputStream((InputStream)next, (ResumableInputStream.Reopener)new SimpleReopener(null));
        in.close();
        MatcherAssert.assertThat((Object)next.isClosed(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void markIsNotSupported() throws Exception {
        TestingInputStream next = new TestingInputStream(-1);
        ResumableInputStream in = new ResumableInputStream((InputStream)next, (ResumableInputStream.Reopener)new SimpleReopener(null));
        MatcherAssert.assertThat((Object)in.markSupported(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void readResumesWithRuntimeException() throws Exception {
        TestingInputStream next = new TestingInputStream(-3, -3, -3, -3, -3, 1, -2, 2, -1);
        SimpleReopener reopener = new SimpleReopener(next);
        ResumableInputStream in = new ResumableInputStream((InputStream)next, (ResumableInputStream.Reopener)reopener);
        MatcherAssert.assertThat((Object)in.read(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)reopener.getLastOffset(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)reopener.getReopenCount(), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat((Object)in.read(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)reopener.getLastOffset(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)reopener.getReopenCount(), (Matcher)Matchers.is((Object)6));
        MatcherAssert.assertThat((Object)in.read(), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)reopener.getLastOffset(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)reopener.getReopenCount(), (Matcher)Matchers.is((Object)6));
    }

    @Test
    public void readWithBytesResumesWithRuntimeException() throws Exception {
        TestingInputStream next = new TestingInputStream(-3, -3, -3, -3, -3, 1, -2, 2, -1);
        SimpleReopener reopener = new SimpleReopener(next);
        ResumableInputStream in = new ResumableInputStream((InputStream)next, (ResumableInputStream.Reopener)reopener);
        MatcherAssert.assertThat((Object)in.read(new byte[1]), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)reopener.getLastOffset(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)reopener.getLastClosedCause(), (Matcher)Matchers.instanceOf(RuntimeException.class));
        MatcherAssert.assertThat((Object)reopener.getReopenCount(), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat((Object)in.read(new byte[1]), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)reopener.getLastOffset(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)reopener.getReopenCount(), (Matcher)Matchers.is((Object)6));
        MatcherAssert.assertThat((Object)reopener.getLastClosedCause(), (Matcher)Matchers.instanceOf(IOException.class));
        MatcherAssert.assertThat((Object)in.read(new byte[1]), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)reopener.getLastOffset(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)reopener.getReopenCount(), (Matcher)Matchers.is((Object)6));
    }

    @Test
    public void readWithBytesAndOffsetResumesWithRuntimeException() throws Exception {
        TestingInputStream next = new TestingInputStream(-3, -3, -3, -3, -3, 1, -2, 2, -1);
        SimpleReopener reopener = new SimpleReopener(next);
        ResumableInputStream in = new ResumableInputStream((InputStream)next, (ResumableInputStream.Reopener)reopener);
        MatcherAssert.assertThat((Object)in.read(new byte[1], 0, 1), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)reopener.getLastOffset(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)reopener.getLastClosedCause(), (Matcher)Matchers.instanceOf(RuntimeException.class));
        MatcherAssert.assertThat((Object)reopener.getReopenCount(), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat((Object)in.read(new byte[1], 0, 1), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)reopener.getLastOffset(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)reopener.getReopenCount(), (Matcher)Matchers.is((Object)6));
        MatcherAssert.assertThat((Object)reopener.getLastClosedCause(), (Matcher)Matchers.instanceOf(IOException.class));
        MatcherAssert.assertThat((Object)in.read(new byte[1], 0, 1), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)reopener.getLastOffset(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)reopener.getReopenCount(), (Matcher)Matchers.is((Object)6));
    }

    @Test
    public void skipResumesWithRuntimeException() throws Exception {
        TestingInputStream next = new TestingInputStream(-3, -3, -3, -3, -3, 1, -2, 2, -1);
        SimpleReopener reopener = new SimpleReopener(next);
        ResumableInputStream in = new ResumableInputStream((InputStream)next, (ResumableInputStream.Reopener)reopener);
        MatcherAssert.assertThat((Object)in.skip(1L), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)reopener.getLastOffset(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)reopener.getLastClosedCause(), (Matcher)Matchers.instanceOf(RuntimeException.class));
        MatcherAssert.assertThat((Object)reopener.getReopenCount(), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat((Object)in.skip(1L), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((Object)reopener.getLastOffset(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)reopener.getReopenCount(), (Matcher)Matchers.is((Object)6));
        MatcherAssert.assertThat((Object)reopener.getLastClosedCause(), (Matcher)Matchers.instanceOf(IOException.class));
        MatcherAssert.assertThat((Object)in.skip(1L), (Matcher)Matchers.is((Object)-1L));
        MatcherAssert.assertThat((Object)reopener.getLastOffset(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)reopener.getReopenCount(), (Matcher)Matchers.is((Object)6));
    }

    static class SimpleReopener
    implements ResumableInputStream.Reopener {
        private final InputStream next;
        private long lastOffset;
        private Exception lastClosedCause;
        private int reopenCount = 0;

        public SimpleReopener(InputStream next) {
            this.next = next;
        }

        public InputStream reopen(long offset, Exception closedCause) throws IOException {
            if (this.next == null) {
                throw new RuntimeException("reopen");
            }
            this.lastOffset = offset;
            this.lastClosedCause = closedCause;
            ++this.reopenCount;
            return this.next;
        }

        public long getLastOffset() {
            return this.lastOffset;
        }

        public Exception getLastClosedCause() {
            return this.lastClosedCause;
        }

        public int getReopenCount() {
            return this.reopenCount;
        }
    }

    static class TestingInputStream
    extends InputStream {
        private final Deque<Integer> returnValues;
        private boolean closed;

        public TestingInputStream(int ... returnValues) {
            this.returnValues = new ArrayDeque<Integer>(returnValues.length);
            for (int c : returnValues) {
                this.returnValues.addLast(c);
            }
        }

        @Override
        public int read() throws IOException {
            return this.throwIfErrorCommand(this.returnValues.removeFirst());
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.throwIfErrorCommand(this.returnValues.removeFirst());
        }

        @Override
        public long skip(long n) throws IOException {
            return this.throwIfErrorCommand(this.returnValues.removeFirst());
        }

        @Override
        public int available() throws IOException {
            int sum = 0;
            for (int c : this.returnValues) {
                if (c <= 0) continue;
                sum += c;
            }
            return sum;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }

        private int throwIfErrorCommand(int c) throws IOException {
            switch (c) {
                case -3: {
                    throw new RuntimeException("runtime");
                }
                case -2: {
                    throw new IOException("io");
                }
            }
            return c;
        }

        @Override
        public boolean markSupported() {
            return true;
        }
    }
}

