/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;
import io.digdag.client.config.ConfigFactory;
import io.digdag.util.ParallelControl;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ParallelControlTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private final ConfigFactory configFactory = new ConfigFactory(new ObjectMapper());

    private Config newConfig() {
        return this.configFactory.create();
    }

    @Test
    public void testParallelControl() {
        ParallelControl pc = ParallelControl.of((Config)this.newConfig());
        MatcherAssert.assertThat((Object)pc.isParallel(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)pc.getParallelLimit(), (Matcher)Matchers.is((Object)0));
        pc = ParallelControl.of((Config)this.newConfig().set("_parallel", (Object)true));
        MatcherAssert.assertThat((Object)pc.isParallel(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)pc.getParallelLimit(), (Matcher)Matchers.is((Object)0));
        pc = ParallelControl.of((Config)this.newConfig().set("_parallel", (Object)"false"));
        MatcherAssert.assertThat((Object)pc.isParallel(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)pc.getParallelLimit(), (Matcher)Matchers.is((Object)0));
        pc = ParallelControl.of((Config)this.newConfig().set("_parallel", (Object)"true"));
        MatcherAssert.assertThat((Object)pc.isParallel(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)pc.getParallelLimit(), (Matcher)Matchers.is((Object)0));
        Config config = this.newConfig().setNested("_parallel", this.newConfig().set("limit", (Object)3));
        ParallelControl pc2 = ParallelControl.of((Config)config);
        MatcherAssert.assertThat((Object)pc2.isParallel(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)pc2.getParallelLimit(), (Matcher)Matchers.is((Object)3));
        Config src = this.newConfig().set("_parallel", (Object)false);
        Config dst = this.newConfig();
        ParallelControl.of((Config)src).copyIfNeeded(dst);
        MatcherAssert.assertThat((Object)dst.has("_parallel"), (Matcher)Matchers.is((Object)false));
        src = this.newConfig().set("_parallel", (Object)true);
        dst = this.newConfig();
        ParallelControl.of((Config)src).copyIfNeeded(dst);
        MatcherAssert.assertThat((Object)((Boolean)dst.get("_parallel", Boolean.TYPE)), (Matcher)Matchers.is((Object)true));
        src = this.newConfig().set("_parallel", (Object)this.newConfig().set("limit", (Object)3));
        dst = this.newConfig();
        ParallelControl.of((Config)src).copyIfNeeded(dst);
        MatcherAssert.assertThat((Object)((Integer)dst.getNested("_parallel").get("limit", Integer.TYPE)), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void testParallelInvalidFormat() {
        Config test1 = this.configFactory.create().set("_parallel", (Object)"tru");
        this.assertException(() -> ParallelControl.of((Config)test1), ConfigException.class, "Expected 'true' or 'false' for key '_parallel' but got");
        Config test2 = this.configFactory.create().setNested("_parallel", this.newConfig().set("limit", (Object)"test"));
        this.assertException(() -> ParallelControl.of((Config)test2), ConfigException.class, "Expected integer (int) type for key 'limit' but got");
    }

    private void assertException(Runnable func, Class<? extends Exception> expected, String message) {
        try {
            func.run();
            Assert.fail();
        }
        catch (Exception ex) {
            MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.instanceOf(expected));
            MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)message));
        }
    }
}

