/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.util;

import io.digdag.util.Durations;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.concurrent.Callable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DurationsTest {
    @Test
    public void testFormatDuration() throws Exception {
        MatcherAssert.assertThat((Object)Durations.formatDuration((Duration)Durations.parseDuration((CharSequence)"17s")), (Matcher)Matchers.is((Object)"17s"));
        MatcherAssert.assertThat((Object)Durations.formatDuration((Duration)Durations.parseDuration((CharSequence)"17S")), (Matcher)Matchers.is((Object)"17s"));
        MatcherAssert.assertThat((Object)Durations.formatDuration((Duration)Durations.parseDuration((CharSequence)" 17 s ")), (Matcher)Matchers.is((Object)"17s"));
        MatcherAssert.assertThat((Object)Durations.formatDuration((Duration)Durations.parseDuration((CharSequence)"13m17s")), (Matcher)Matchers.is((Object)"13m 17s"));
        MatcherAssert.assertThat((Object)Durations.formatDuration((Duration)Durations.parseDuration((CharSequence)" 13 m 17 s ")), (Matcher)Matchers.is((Object)"13m 17s"));
        MatcherAssert.assertThat((Object)Durations.formatDuration((Duration)Durations.parseDuration((CharSequence)" 13 m 17 s ")), (Matcher)Matchers.is((Object)"13m 17s"));
        MatcherAssert.assertThat((Object)Durations.formatDuration((Duration)Durations.parseDuration((CharSequence)"13M17S")), (Matcher)Matchers.is((Object)"13m 17s"));
        MatcherAssert.assertThat((Object)Durations.formatDuration((Duration)Durations.parseDuration((CharSequence)" 13 M 17 S ")), (Matcher)Matchers.is((Object)"13m 17s"));
        MatcherAssert.assertThat((Object)Durations.formatDuration((Duration)Durations.parseDuration((CharSequence)" 13 m 17 s ")), (Matcher)Matchers.is((Object)"13m 17s"));
        MatcherAssert.assertThat((Object)Durations.formatDuration((Duration)Durations.parseDuration((CharSequence)"21h13m17s")), (Matcher)Matchers.is((Object)"21h 13m 17s"));
        MatcherAssert.assertThat((Object)Durations.formatDuration((Duration)Durations.parseDuration((CharSequence)" 21h 13m 17s ")), (Matcher)Matchers.is((Object)"21h 13m 17s"));
        MatcherAssert.assertThat((Object)Durations.formatDuration((Duration)Durations.parseDuration((CharSequence)"21H13M17S")), (Matcher)Matchers.is((Object)"21h 13m 17s"));
        MatcherAssert.assertThat((Object)Durations.formatDuration((Duration)Durations.parseDuration((CharSequence)" 21 H 13 M 17 S ")), (Matcher)Matchers.is((Object)"21h 13m 17s"));
        MatcherAssert.assertThat((Object)Durations.formatDuration((Duration)Durations.parseDuration((CharSequence)"3d21h13m17s")), (Matcher)Matchers.is((Object)"3d 21h 13m 17s"));
        MatcherAssert.assertThat((Object)Durations.formatDuration((Duration)Durations.parseDuration((CharSequence)"3d 21h 13m 17s ")), (Matcher)Matchers.is((Object)"3d 21h 13m 17s"));
        MatcherAssert.assertThat((Object)Durations.formatDuration((Duration)Durations.parseDuration((CharSequence)"3D21H13M17S")), (Matcher)Matchers.is((Object)"3d 21h 13m 17s"));
        MatcherAssert.assertThat((Object)Durations.formatDuration((Duration)Durations.parseDuration((CharSequence)"3 D 21 H 13 M 17 S ")), (Matcher)Matchers.is((Object)"3d 21h 13m 17s"));
    }

    @Test
    public void testValidDurations() throws Exception {
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)"17d"), (Matcher)Matchers.is((Object)Duration.ZERO.plusDays(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)"17D"), (Matcher)Matchers.is((Object)Duration.ZERO.plusDays(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)" 17 d "), (Matcher)Matchers.is((Object)Duration.ZERO.plusDays(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)"17h"), (Matcher)Matchers.is((Object)Duration.ZERO.plusHours(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)"17H"), (Matcher)Matchers.is((Object)Duration.ZERO.plusHours(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)" 17 h "), (Matcher)Matchers.is((Object)Duration.ZERO.plusHours(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)"17m"), (Matcher)Matchers.is((Object)Duration.ZERO.plusMinutes(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)"17M"), (Matcher)Matchers.is((Object)Duration.ZERO.plusMinutes(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)" 17 m "), (Matcher)Matchers.is((Object)Duration.ZERO.plusMinutes(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)"17s"), (Matcher)Matchers.is((Object)Duration.ZERO.plusSeconds(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)"17S"), (Matcher)Matchers.is((Object)Duration.ZERO.plusSeconds(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)" 17 s "), (Matcher)Matchers.is((Object)Duration.ZERO.plusSeconds(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)"17s"), (Matcher)Matchers.is((Object)Duration.ZERO.plusSeconds(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)"17S"), (Matcher)Matchers.is((Object)Duration.ZERO.plusSeconds(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)" 17 s "), (Matcher)Matchers.is((Object)Duration.ZERO.plusSeconds(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)"13m17s"), (Matcher)Matchers.is((Object)Duration.ZERO.plusMinutes(13L).plusSeconds(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)" 13 m 17 s "), (Matcher)Matchers.is((Object)Duration.ZERO.plusMinutes(13L).plusSeconds(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)" 13 m 17 s "), (Matcher)Matchers.is((Object)Duration.ZERO.plusMinutes(13L).plusSeconds(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)"13M17S"), (Matcher)Matchers.is((Object)Duration.ZERO.plusMinutes(13L).plusSeconds(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)" 13 M 17 S "), (Matcher)Matchers.is((Object)Duration.ZERO.plusMinutes(13L).plusSeconds(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)" 13 m 17 s "), (Matcher)Matchers.is((Object)Duration.ZERO.plusMinutes(13L).plusSeconds(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)"21h13m17s"), (Matcher)Matchers.is((Object)Duration.ZERO.plusHours(21L).plusMinutes(13L).plusSeconds(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)" 21h 13m 17s "), (Matcher)Matchers.is((Object)Duration.ZERO.plusHours(21L).plusMinutes(13L).plusSeconds(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)"21H13M17S"), (Matcher)Matchers.is((Object)Duration.ZERO.plusHours(21L).plusMinutes(13L).plusSeconds(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)" 21 H 13 M 17 S "), (Matcher)Matchers.is((Object)Duration.ZERO.plusHours(21L).plusMinutes(13L).plusSeconds(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)"3d21h13m17s"), (Matcher)Matchers.is((Object)Duration.ZERO.plusDays(3L).plusHours(21L).plusMinutes(13L).plusSeconds(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)"3d 21h 13m 17s "), (Matcher)Matchers.is((Object)Duration.ZERO.plusDays(3L).plusHours(21L).plusMinutes(13L).plusSeconds(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)"3D21H13M17S"), (Matcher)Matchers.is((Object)Duration.ZERO.plusDays(3L).plusHours(21L).plusMinutes(13L).plusSeconds(17L)));
        MatcherAssert.assertThat((Object)Durations.parseDuration((CharSequence)"3 D 21 H 13 M 17 S "), (Matcher)Matchers.is((Object)Duration.ZERO.plusDays(3L).plusHours(21L).plusMinutes(13L).plusSeconds(17L)));
    }

    @Test
    public void testInvalidValidDurations() throws Exception {
        DurationsTest.assertThrows(() -> Durations.parseDuration((CharSequence)""), DateTimeParseException.class);
        DurationsTest.assertThrows(() -> Durations.parseDuration((CharSequence)"17"), DateTimeParseException.class);
        DurationsTest.assertThrows(() -> Durations.parseDuration((CharSequence)"1 7s"), DateTimeParseException.class);
        DurationsTest.assertThrows(() -> Durations.parseDuration((CharSequence)"-4s"), DateTimeParseException.class);
        DurationsTest.assertThrows(() -> Durations.parseDuration((CharSequence)"foobar"), DateTimeParseException.class);
    }

    private static <T, E extends Throwable> void assertThrows(Callable<T> callable, Class<E> exceptionClass) {
        try {
            callable.call();
        }
        catch (Throwable e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.instanceOf(exceptionClass));
            return;
        }
        Assert.fail((String)("Expected an exception of type: " + exceptionClass));
    }
}

