/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigElement;
import io.digdag.client.config.ConfigFactory;
import io.digdag.spi.OperatorContext;
import io.digdag.spi.PrivilegedVariables;
import io.digdag.spi.SecretProvider;
import io.digdag.spi.TaskExecutionException;
import io.digdag.spi.TaskRequest;
import io.digdag.spi.TaskResult;
import io.digdag.util.BaseOperator;
import java.nio.file.Path;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class BaseOperatorTest {
    private static final int INTERVAL = 4711;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Mock
    TaskRequest request;
    private final ConfigFactory configFactory = new ConfigFactory(new ObjectMapper());
    private Config config;
    private Config state;

    @Before
    public void setUp() throws Exception {
        this.config = this.configFactory.create();
        this.state = this.configFactory.create();
        Mockito.when((Object)this.request.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.request.getLastStateParams()).thenReturn((Object)this.state);
    }

    @Test
    public void verifyPollingTaskExecutionExceptionIsNotSwallowed() throws Exception {
        final TaskExecutionException ex = TaskExecutionException.ofNextPolling((int)4711, (ConfigElement)ConfigElement.empty());
        BaseOperator op = new BaseOperator(this.newContext(this.temporaryFolder.getRoot().toPath(), this.request)){

            public TaskResult runTask() {
                throw ex;
            }
        };
        try {
            op.run();
            Assert.fail();
        }
        catch (TaskExecutionException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)Matchers.is((Object)((Object)ex)));
            MatcherAssert.assertThat((Object)e.isError(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)((Integer)e.getRetryInterval().get()), (Matcher)Matchers.is((Object)4711));
        }
    }

    @Test
    public void verifyPollingTaskExecutionExceptionIsNotSwallowedWhenRetriesAreEnabled() throws Exception {
        this.config.set("_retry", (Object)10);
        final TaskExecutionException ex = TaskExecutionException.ofNextPolling((int)4711, (ConfigElement)ConfigElement.empty());
        BaseOperator op = new BaseOperator(this.newContext(this.temporaryFolder.getRoot().toPath(), this.request)){

            public TaskResult runTask() {
                throw ex;
            }
        };
        try {
            op.run();
            Assert.fail();
        }
        catch (TaskExecutionException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)Matchers.is((Object)((Object)ex)));
            MatcherAssert.assertThat((Object)e.isError(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)((Integer)e.getRetryInterval().get()), (Matcher)Matchers.is((Object)4711));
        }
    }

    @Test
    public void verifyNonPollingRuntimeExceptionRemovesCommandStatusOnRetry() throws Exception {
        this.config.set("_retry", (Object)10);
        ObjectNode commandStatus = new ObjectMapper().createObjectNode().put("foo", "bar");
        this.state.set("commandStatus", (Object)commandStatus);
        final RuntimeException ex = new RuntimeException("Command failed");
        BaseOperator op = new BaseOperator(this.newContext(this.temporaryFolder.getRoot().toPath(), this.request)){

            public TaskResult runTask() {
                throw ex;
            }
        };
        try {
            op.run();
            Assert.fail();
        }
        catch (TaskExecutionException e) {
            MatcherAssert.assertThat((Object)e.isError(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.is((Object)ex));
            MatcherAssert.assertThat((Object)((Config)e.getStateParams(this.configFactory).get()).has("commandStatus"), (Matcher)Matchers.is((Object)false));
        }
    }

    private OperatorContext newContext(final Path projectPath, final TaskRequest taskRequest) {
        return new OperatorContext(){

            public Path getProjectPath() {
                return projectPath;
            }

            public TaskRequest getTaskRequest() {
                return taskRequest;
            }

            public SecretProvider getSecrets() {
                return null;
            }

            public PrivilegedVariables getPrivilegedVariables() {
                return null;
            }
        };
    }
}

