/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.collect.ImmutableMap;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;
import io.digdag.client.config.ConfigFactory;
import io.digdag.util.AbstractWaitOperatorFactory;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class AbstractWaitOperatorFactoryTest {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new GuavaModule());
    private static final ConfigFactory CONFIG_FACTORY = new ConfigFactory(MAPPER);

    @Test
    public void testConfigurationsValidation() throws Exception {
        String[] keys = new String[]{"config.test.wait.poll_interval", "config.test.wait.min_poll_interval", "config.test.wait.max_poll_interval"};
        String[] illegalValues = new String[]{"", "foobar", "-1s", "99999999999999999s", TimeUnit.SECONDS.toHours(Integer.MAX_VALUE) * 2L + "h"};
        for (String key : keys) {
            for (String value : illegalValues) {
                this.assertConfigurationFailsValidation((Map<String, Object>)ImmutableMap.of((Object)key, (Object)value));
            }
        }
        this.assertConfigurationFailsValidation((Map<String, Object>)ImmutableMap.of((Object)"config.test.wait.poll_interval", (Object)"5s"));
        this.assertConfigurationFailsValidation((Map<String, Object>)ImmutableMap.of((Object)"config.test.wait.poll_interval", (Object)"29s"));
        this.assertConfigurationPassesValidation((Map<String, Object>)ImmutableMap.of((Object)"config.test.wait.poll_interval", (Object)"30s"));
        this.assertConfigurationPassesValidation((Map<String, Object>)ImmutableMap.of((Object)"config.test.wait.poll_interval", (Object)"31s"));
        AbstractWaitOperatorFactory f = this.assertConfigurationPassesValidation((Map<String, Object>)ImmutableMap.of((Object)"config.test.wait.min_poll_interval", (Object)"45s", (Object)"config.test.wait.max_poll_interval", (Object)"60s"));
        MatcherAssert.assertThat((Object)f.getPollInterval(CONFIG_FACTORY.create()), (Matcher)Matchers.is((Object)45));
        this.assertConfigurationFailsValidation((Map<String, Object>)ImmutableMap.of((Object)"config.test.wait.min_poll_interval", (Object)"10s", (Object)"config.test.wait.poll_interval", (Object)"5s"));
        this.assertConfigurationFailsValidation((Map<String, Object>)ImmutableMap.of((Object)"config.test.wait.min_poll_interval", (Object)"30s", (Object)"config.test.wait.max_poll_interval", (Object)"40s", (Object)"config.test.wait.poll_interval", (Object)"50s"));
        this.assertConfigurationFailsValidation((Map<String, Object>)ImmutableMap.of((Object)"config.test.wait.min_poll_interval", (Object)"10s", (Object)"config.test.wait.max_poll_interval", (Object)"5s"));
        f = this.assertConfigurationPassesValidation((Map<String, Object>)ImmutableMap.of((Object)"config.test.wait.min_poll_interval", (Object)"5s", (Object)"config.test.wait.poll_interval", (Object)"5s", (Object)"config.test.wait.max_poll_interval", (Object)"5s"));
        MatcherAssert.assertThat((Object)f.getPollInterval(CONFIG_FACTORY.create()), (Matcher)Matchers.is((Object)5));
        AbstractWaitOperatorFactoryTest.assertThrows(() -> f.getPollInterval(CONFIG_FACTORY.create((Object)this.cfg((Map<String, Object>)ImmutableMap.of((Object)"interval", (Object)"3s")))), ConfigException.class);
        AbstractWaitOperatorFactoryTest.assertThrows(() -> f.getPollInterval(CONFIG_FACTORY.create((Object)this.cfg((Map<String, Object>)ImmutableMap.of((Object)"interval", (Object)"7s")))), ConfigException.class);
        f = this.assertConfigurationPassesValidation((Map<String, Object>)ImmutableMap.of((Object)"config.test.wait.min_poll_interval", (Object)"5s", (Object)"config.test.wait.poll_interval", (Object)"10s", (Object)"config.test.wait.max_poll_interval", (Object)"15s"));
        MatcherAssert.assertThat((Object)f.getPollInterval(CONFIG_FACTORY.create()), (Matcher)Matchers.is((Object)10));
        AbstractWaitOperatorFactoryTest.assertThrows(() -> f.getPollInterval(CONFIG_FACTORY.create((Object)this.cfg((Map<String, Object>)ImmutableMap.of((Object)"interval", (Object)"3s")))), ConfigException.class);
        AbstractWaitOperatorFactoryTest.assertThrows(() -> f.getPollInterval(CONFIG_FACTORY.create((Object)this.cfg((Map<String, Object>)ImmutableMap.of((Object)"interval", (Object)"30s")))), ConfigException.class);
        f = this.assertConfigurationPassesValidation((Map<String, Object>)ImmutableMap.of((Object)"config.test.wait.min_poll_interval", (Object)"10s", (Object)"config.test.wait.poll_interval", (Object)"5m", (Object)"config.test.wait.max_poll_interval", (Object)"2h"));
        MatcherAssert.assertThat((Object)f.getPollInterval(CONFIG_FACTORY.create()), (Matcher)Matchers.is((Object)300));
        AbstractWaitOperatorFactoryTest.assertThrows(() -> f.getPollInterval(CONFIG_FACTORY.create((Object)this.cfg((Map<String, Object>)ImmutableMap.of((Object)"interval", (Object)"5s")))), ConfigException.class);
        AbstractWaitOperatorFactoryTest.assertThrows(() -> f.getPollInterval(CONFIG_FACTORY.create((Object)this.cfg((Map<String, Object>)ImmutableMap.of((Object)"interval", (Object)"3h")))), ConfigException.class);
    }

    private void assertConfigurationFailsValidation(Map<String, Object> config) throws JsonProcessingException {
        AbstractWaitOperatorFactoryTest.assertThrows(() -> new AbstractWaitOperatorFactory("test.wait", this.cfg(config)){}, ConfigException.class);
    }

    private Config cfg(Map<String, Object> config) throws JsonProcessingException {
        String json = MAPPER.writeValueAsString(config);
        return CONFIG_FACTORY.fromJsonString(json);
    }

    private AbstractWaitOperatorFactory assertConfigurationPassesValidation(Map<String, Object> config) throws JsonProcessingException {
        Config c = this.cfg(config);
        return new AbstractWaitOperatorFactory("test.wait", c){};
    }

    static <T, E extends Throwable> void assertThrows(Callable<T> callable, Class<E> exceptionClass) {
        try {
            callable.call();
        }
        catch (Throwable e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.instanceOf(exceptionClass));
            return;
        }
        Assert.fail((String)("Expected an exception of type: " + exceptionClass));
    }
}

