/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.sp;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.api.form.Form;
import io.dialob.api.questionnaire.Answer;
import io.dialob.api.questionnaire.ContextValue;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.api.questionnaire.VariableValue;
import io.dialob.questionnaire.service.api.event.QuestionnaireEventPublisher;
import io.dialob.questionnaire.service.api.session.BaseQuestionnaireSessionBuilder;
import io.dialob.questionnaire.service.api.session.FormFinder;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionSaveService;
import io.dialob.session.engine.DialobProgramService;
import io.dialob.session.engine.Utils;
import io.dialob.session.engine.program.DialobProgram;
import io.dialob.session.engine.program.DialobSessionEvalContextFactory;
import io.dialob.session.engine.program.model.VariableItem;
import io.dialob.session.engine.session.model.DialobSession;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ValueSetState;
import io.dialob.session.engine.sp.AsyncFunctionInvoker;
import io.dialob.session.engine.sp.DialobQuestionnaireSession;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialobQuestionnaireSessionBuilder
extends BaseQuestionnaireSessionBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobQuestionnaireSessionBuilder.class);
    private final QuestionnaireEventPublisher eventPublisher;
    private final DialobProgramService dialobProgramService;
    private final QuestionnaireSessionSaveService questionnaireSessionSaveService;
    private final DialobSessionEvalContextFactory sessionContextFactory;
    private final AsyncFunctionInvoker asyncFunctionInvoker;

    public DialobQuestionnaireSessionBuilder(@NonNull QuestionnaireEventPublisher eventPublisher, @NonNull DialobProgramService dialobProgramService, @NonNull FormFinder formFinder, @NonNull QuestionnaireSessionSaveService questionnaireSessionSaveService, @NonNull DialobSessionEvalContextFactory sessionContextFactory, @NonNull AsyncFunctionInvoker asyncFunctionInvoker) {
        super(formFinder);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.dialobProgramService = Objects.requireNonNull(dialobProgramService);
        this.questionnaireSessionSaveService = Objects.requireNonNull(questionnaireSessionSaveService);
        this.sessionContextFactory = Objects.requireNonNull(sessionContextFactory);
        this.asyncFunctionInvoker = Objects.requireNonNull(asyncFunctionInvoker);
    }

    @NonNull
    protected QuestionnaireSession createQuestionnaireSession(boolean newSession, @NonNull Form formDocument) {
        Questionnaire questionnaire = this.getQuestionnaire();
        DialobProgram dialobProgram = this.dialobProgramService.findByFormIdAndRev(formDocument.getId(), formDocument.getRev());
        DialobSession dialobSession = dialobProgram.createSession(this.sessionContextFactory, formDocument.getMetadata().getTenantId(), questionnaire.getId(), this.getLanguage(), questionnaire.getActiveItem(), (itemId, item) -> {
            String id = IdUtils.toString(itemId);
            if (item instanceof VariableItem) {
                for (ContextValue contextValue : questionnaire.getContext()) {
                    if (!id.equals(contextValue.getId())) continue;
                    return Optional.ofNullable(Utils.parse(item.getValueType(), contextValue.getValue()));
                }
                for (VariableValue variableValue : questionnaire.getVariableValues()) {
                    if (!id.equals(variableValue.getId())) continue;
                    return Optional.ofNullable(Utils.parse(item.getValueType(), variableValue.getValue()));
                }
            } else {
                for (Answer answer : questionnaire.getAnswers()) {
                    if (!id.equals(answer.getId())) continue;
                    return Optional.ofNullable(answer.getValue());
                }
            }
            return Optional.empty();
        }, valueSetId -> questionnaire.getValueSets().stream().filter(valueSet -> valueSet.getId().equals(valueSetId.getValueSetId())).findFirst().map(valueSet -> valueSet.getEntries().stream().map(entry -> ValueSetState.Entry.of(entry.getKey(), entry.getValue(), true)).toList()).orElse(Collections.emptyList()), questionnaire.getMetadata().getCompleted(), questionnaire.getMetadata().getOpened(), questionnaire.getMetadata().getLastAnswer());
        if (questionnaire.getMetadata().getStatus() == Questionnaire.Metadata.Status.COMPLETED) {
            dialobSession.complete();
        }
        DialobQuestionnaireSession dialobQuestionnaireSession = null;
        try {
            dialobQuestionnaireSession = this.applyFormSettings(DialobQuestionnaireSession.builder().eventPublisher(this.eventPublisher).sessionContextFactory(this.sessionContextFactory).asyncFunctionInvoker(this.asyncFunctionInvoker).dialobSession(dialobSession).dialobProgram(dialobProgram).rev(questionnaire.getRev()).metadata(questionnaire.getMetadata()), formDocument.getMetadata().getAdditionalProperties()).build();
            if (newSession) {
                dialobQuestionnaireSession = this.save(dialobQuestionnaireSession);
                if (!this.isCreateOnly()) {
                    dialobQuestionnaireSession.initialize();
                }
            }
            dialobQuestionnaireSession.activate();
            return dialobQuestionnaireSession;
        }
        catch (Exception e) {
            if (dialobQuestionnaireSession != null) {
                dialobQuestionnaireSession.close();
            }
            throw e;
        }
    }

    @NonNull
    protected DialobQuestionnaireSession save(DialobQuestionnaireSession dialobQuestionnaireSession) {
        return (DialobQuestionnaireSession)this.questionnaireSessionSaveService.save((QuestionnaireSession)dialobQuestionnaireSession);
    }

    private DialobQuestionnaireSession.Builder applyFormSettings(DialobQuestionnaireSession.Builder builder, Map<String, Object> additionalProperties) {
        builder.questionClientVisibility(this.getQuestionClientVisibility(additionalProperties));
        return builder;
    }

    private QuestionnaireSession.QuestionClientVisibility getQuestionClientVisibility(Map<String, Object> additionalProperties) {
        return DialobQuestionnaireSessionBuilder.parseEnum(QuestionnaireSession.QuestionClientVisibility.class, additionalProperties.get("questionClientVisibility")).or(() -> {
            if (DialobQuestionnaireSessionBuilder.parseBoolean(additionalProperties.get("showDisabled"))) {
                return Optional.of(QuestionnaireSession.QuestionClientVisibility.SHOW_DISABLED);
            }
            return Optional.empty();
        }).orElse(QuestionnaireSession.QuestionClientVisibility.ONLY_ENABLED);
    }

    private static <T extends Enum<T>> Optional<T> parseEnum(Class<T> enumClass, Object o) {
        if (o instanceof String) {
            String string = (String)o;
            try {
                return Optional.of(Enum.valueOf(enumClass, string));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Unknown question client visibility {}", o);
            }
        }
        return Optional.empty();
    }

    private static boolean parseBoolean(Object o) {
        boolean showDisabled = false;
        if (o instanceof String) {
            String string = (String)o;
            showDisabled = Boolean.parseBoolean(string);
        } else if (o instanceof Boolean) {
            Boolean boolean1 = (Boolean)o;
            showDisabled = boolean1;
        }
        return showDisabled;
    }
}

