/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.model;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.session.engine.session.model.ImmutableValueSetId;
import io.dialob.session.engine.session.model.SessionObject;
import io.dialob.session.engine.session.model.ValueSetId;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class ValueSetState
implements SessionObject {
    private static final long serialVersionUID = 6040009682715910439L;
    private final ValueSetId id;
    private List<Entry> entries;

    public UpdateBuilder update() {
        return new UpdateBuilder();
    }

    public ValueSetState(@NonNull ValueSetId id) {
        this.id = id;
    }

    public ValueSetState(@NonNull String id) {
        this.id = ImmutableValueSetId.of(id);
    }

    public ValueSetState(@NonNull ValueSetState valueSetState) {
        this.id = valueSetState.id;
        if (valueSetState.entries != null) {
            this.entries = new ArrayList<Entry>(valueSetState.entries);
        }
    }

    @NonNull
    public ValueSetId getId() {
        return this.id;
    }

    @NonNull
    public List<Entry> getEntries() {
        if (this.entries == null) {
            return Collections.emptyList();
        }
        return this.entries;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        output.writeStringNoTag(this.getId().getValueSetId());
        output.writeInt32NoTag(this.entries.size());
        for (Entry entry : this.entries) {
            output.writeStringNoTag(entry.getId());
            output.writeStringNoTag(entry.getLabel());
            output.writeBoolNoTag(entry.isProvided());
        }
    }

    public static ValueSetState readFrom(CodedInputStream input) throws IOException {
        String id = input.readString();
        ValueSetState state = new ValueSetState(id);
        int count = input.readInt32();
        Entry[] entries = new Entry[count];
        for (int i = 0; i < count; ++i) {
            String key = input.readString();
            String label = input.readString();
            boolean provided = input.readBool();
            entries[i] = new Entry(key, label, provided);
        }
        state.entries = List.of(entries);
        return state;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueSetState)) {
            return false;
        }
        ValueSetState other = (ValueSetState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ValueSetId this$id = this.getId();
        ValueSetId other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<Entry> this$entries = this.getEntries();
        List<Entry> other$entries = other.getEntries();
        return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ValueSetState;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ValueSetId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<Entry> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ValueSetState(id=" + String.valueOf(this.getId()) + ", entries=" + String.valueOf(this.getEntries()) + ")";
    }

    public class UpdateBuilder {
        private ValueSetState itemState;

        private ValueSetState state() {
            if (this.itemState == null) {
                this.itemState = new ValueSetState(ValueSetState.this);
            }
            return this.itemState;
        }

        public UpdateBuilder setEntries(List<Entry> newEntries) {
            if (!Objects.equals(ValueSetState.this.entries, newEntries)) {
                this.state().entries = newEntries != null ? List.copyOf(newEntries) : null;
            }
            return this;
        }

        public ValueSetState get() {
            if (this.itemState == null) {
                return ValueSetState.this;
            }
            return this.itemState;
        }
    }

    public static class Entry
    implements Serializable {
        private static final long serialVersionUID = -4632044242844529912L;
        private final String id;
        private final String label;
        private final boolean provided;

        public static Entry of(String id, String label) {
            return Entry.of(id, label, false);
        }

        public static Entry of(String id, String label, boolean provided) {
            return new Entry(id, label, provided);
        }

        public Entry(String id, String label, boolean provided) {
            this.id = id;
            this.label = label;
            this.provided = provided;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getLabel() {
            return this.label;
        }

        @Generated
        public boolean isProvided() {
            return this.provided;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isProvided() != other.isProvided()) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            return !(this$label == null ? other$label != null : !this$label.equals(other$label));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Entry;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isProvided() ? 79 : 97);
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ValueSetState.Entry(id=" + this.getId() + ", label=" + this.getLabel() + ", provided=" + this.isProvided() + ")";
        }
    }
}

