/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.model;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.dialob.api.proto.Action;
import io.dialob.rule.parser.api.PrimitiveValueType;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.Utils;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.SessionObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ItemState
implements SessionObject {
    private static final long serialVersionUID = -3974128908954128671L;
    private static final int DISPLAY_ITEM_BIT = 1;
    private static final int ACTIVE_BIT = 2;
    private static final int DISABLED_BIT = 4;
    private static final int REQUIRED_BIT = 8;
    private static final int ROWS_CAN_BE_ADDED_BIT = 16;
    private static final int ROW_CAN_BE_REMOVED_BIT = 32;
    private static final int INVALID_ANSWERS_BIT = 64;
    private static final int HAS_CUSTOM_PROPS_BIT = 128;
    private final ItemId id;
    private final ItemId prototypeId;
    private final String type;
    private final String view;
    private final String valueSetId;
    private Status status = Status.NEW;
    private Object answer;
    private Object value;
    private Object defaultValue;
    private int bits = 18;
    private String label;
    private String description;
    private List<String> classNames = List.of();
    private List<ItemId> items = List.of();
    private List<ItemId> availableItems = List.of();
    private Map<String, Object> props = new HashMap<String, Object>();
    private Set<Action.Type> allowedActions = Set.of();
    private ItemId activePage;

    protected void setBits(boolean toValue, int bit) {
        if (toValue) {
            this.setBits(bit);
        } else {
            this.resetBits(bit);
        }
    }

    protected void setBits(int bit) {
        this.bits |= bit;
    }

    protected void resetBits(int bit) {
        this.bits &= ~bit;
    }

    protected boolean isBit(int bit) {
        return (this.bits & bit) != 0;
    }

    public static ItemState readFrom(CodedInputStream input) throws IOException {
        ItemId id = IdUtils.readIdFrom(input);
        ItemId prototypeId = IdUtils.readIdFrom(input);
        String type = input.readString();
        String view = Utils.readNullableString(input);
        String valueSetId = Utils.readNullableString(input);
        ItemState state = new ItemState(id, prototypeId, type, view, valueSetId);
        state.activePage = IdUtils.readIdFrom(input);
        state.status = Status.values()[input.readRawByte()];
        state.bits = input.readInt32();
        state.label = Utils.readNullableString(input);
        state.description = Utils.readNullableString(input);
        state.answer = Utils.readObjectValue(input);
        state.value = ItemState.readValue(input);
        state.defaultValue = ItemState.readValue(input);
        state.classNames = ItemState.readStringList(input);
        state.items = ItemState.readIdList(input);
        state.availableItems = ItemState.readIdList(input);
        int count = input.readInt32();
        if (count > 0) {
            Action.Type[] types = new Action.Type[count];
            for (int i = 0; i < count; ++i) {
                types[i] = Action.Type.values()[input.readInt32()];
            }
            state.allowedActions = Set.of(types);
        } else {
            state.allowedActions = Set.of();
        }
        return state;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        IdUtils.writeIdTo(this.id, output);
        IdUtils.writeIdTo(this.prototypeId, output);
        output.writeStringNoTag(this.type);
        Utils.writeNullableString(output, this.view);
        Utils.writeNullableString(output, this.valueSetId);
        IdUtils.writeIdTo(this.activePage, output);
        output.writeRawByte(this.status.ordinal());
        output.writeInt32NoTag(this.bits);
        Utils.writeNullableString(output, this.label);
        Utils.writeNullableString(output, this.description);
        Utils.writeObjectValue(output, this.answer);
        this.writeValue(output, Utils.mapQuestionTypeToValueType(this.type).orElse(null), this.value);
        this.writeValue(output, Utils.mapQuestionTypeToValueType(this.type).orElse(null), this.defaultValue);
        this.writeStringList(output, this.classNames);
        this.writeIdList(output, this.items);
        this.writeIdList(output, this.availableItems);
        output.writeInt32NoTag(this.allowedActions.size());
        for (Action.Type actionType : this.allowedActions) {
            output.writeInt32NoTag(actionType.ordinal());
        }
    }

    private void writeValue(CodedOutputStream output, ValueType type, Object value) throws IOException {
        boolean present = value != null && type != null;
        output.writeBoolNoTag(present);
        if (present) {
            output.writeRawByte(type.getTypeCode());
            type.writeTo(output, value);
        }
    }

    private static Object readValue(CodedInputStream input) throws IOException {
        if (input.readBool()) {
            PrimitiveValueType valueType;
            byte typeCode = input.readRawByte();
            if ((0x80 & typeCode) != 0) {
                typeCode = (byte)(typeCode & 0x7F);
                valueType = ValueType.arrayOf((ValueType)PrimitiveValueType.values()[typeCode]);
            } else {
                valueType = PrimitiveValueType.values()[typeCode];
            }
            return valueType.readFrom(input);
        }
        return null;
    }

    private void writeIdList(CodedOutputStream output, List<ItemId> itemIds) throws IOException {
        output.writeInt32NoTag(itemIds.size());
        for (ItemId s : itemIds) {
            IdUtils.writeIdTo(s, output);
        }
    }

    private void writeStringList(CodedOutputStream output, List<String> stringList) throws IOException {
        output.writeInt32NoTag(stringList.size());
        for (String s : stringList) {
            output.writeStringNoTag(s);
        }
    }

    private static List<ItemId> readIdList(CodedInputStream input) throws IOException {
        int count = input.readInt32();
        if (count > 0) {
            ItemId[] ids = new ItemId[count];
            for (int i = 0; i < count; ++i) {
                ids[i] = IdUtils.readIdFrom(input);
            }
            return List.of(ids);
        }
        return List.of();
    }

    private static List<String> readStringList(CodedInputStream input) throws IOException {
        int count = input.readInt32();
        if (count > 0) {
            String[] ids = new String[count];
            for (int i = 0; i < count; ++i) {
                ids[i] = input.readString();
            }
            return List.of(ids);
        }
        return List.of();
    }

    public ItemState(@NonNull ItemId id, ItemId prototypeId, @NonNull String type, String view, String valueSetId) {
        this.id = id;
        this.prototypeId = prototypeId;
        this.type = type;
        this.view = view;
        this.valueSetId = valueSetId;
        this.resetBits(1);
    }

    public ItemState(@NonNull ItemId id, ItemId prototypeId, @NonNull String type, String view, boolean displayItem, String valueSetId, Object answer, Object value, Object defaultValue, ItemId activePage) {
        this.valueSetId = valueSetId;
        this.id = id;
        this.prototypeId = prototypeId;
        this.type = type;
        this.view = view;
        this.setBits(displayItem, 1);
        this.answer = answer;
        this.value = value;
        this.defaultValue = defaultValue;
        this.activePage = activePage;
    }

    ItemState(@NonNull ItemState itemState) {
        this(itemState.getId(), itemState);
    }

    ItemState(@NonNull ItemId id, @NonNull ItemState itemState) {
        this.id = id;
        this.prototypeId = itemState.prototypeId;
        this.type = itemState.type;
        this.view = itemState.view;
        this.valueSetId = itemState.valueSetId;
        this.status = itemState.status;
        this.answer = itemState.answer;
        this.value = itemState.value;
        this.defaultValue = itemState.defaultValue;
        this.bits = itemState.bits;
        this.label = itemState.label;
        this.description = itemState.description;
        this.classNames = itemState.classNames;
        this.items = itemState.items;
        this.availableItems = itemState.availableItems;
        this.props = itemState.props;
        this.allowedActions = itemState.allowedActions;
        this.activePage = itemState.activePage;
    }

    @NonNull
    public ItemId getId() {
        return this.id;
    }

    @Nullable
    public ItemId getPrototypeId() {
        return this.prototypeId;
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @Nullable
    public String getView() {
        return this.view;
    }

    @Override
    public boolean isDisplayItem() {
        return (this.bits & 1) != 0;
    }

    public Optional<String> getValueSetId() {
        return Optional.ofNullable(this.valueSetId);
    }

    public Object getValue() {
        return this.isActive() && this.value != null ? this.value : this.defaultValue;
    }

    @Override
    public boolean isActive() {
        return this.isBit(2);
    }

    public boolean isAnswered() {
        return !this.isNull() && !this.isBlank();
    }

    public boolean isBlank() {
        CharSequence cs;
        Object object;
        return this.isNull() || (object = this.value) instanceof CharSequence && StringUtils.isBlank((CharSequence)(cs = (CharSequence)object));
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isInvalidAnswers() {
        return this.isBit(64);
    }

    public boolean isInvalid() {
        if (this.answer instanceof String) {
            return this.value == null && StringUtils.isNotEmpty((CharSequence)((CharSequence)this.answer));
        }
        return this.value == null && this.answer != null;
    }

    @Override
    public boolean isDisabled() {
        return (this.bits & 4) != 0;
    }

    public boolean isRequired() {
        return (this.bits & 8) != 0;
    }

    public boolean isRowsCanBeAdded() {
        return (this.bits & 0x10) != 0;
    }

    public boolean isRowCanBeRemoved() {
        return (this.bits & 0x20) != 0;
    }

    public boolean hasCustomProps() {
        return (this.bits & 0x80) != 0;
    }

    @NonNull
    public List<ItemId> getItems() {
        return this.items;
    }

    public Optional<ItemId> getActivePage() {
        return Optional.ofNullable(this.activePage);
    }

    @NonNull
    public ItemState withId(@NonNull ItemId newId) {
        return new ItemState(newId, this);
    }

    public UpdateBuilder update() {
        return new UpdateBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemState)) {
            return false;
        }
        ItemState other = (ItemState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.bits != other.bits) {
            return false;
        }
        ItemId this$id = this.getId();
        ItemId other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        ItemId this$prototypeId = this.getPrototypeId();
        ItemId other$prototypeId = other.getPrototypeId();
        if (this$prototypeId == null ? other$prototypeId != null : !this$prototypeId.equals(other$prototypeId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$view = this.getView();
        String other$view = other.getView();
        if (this$view == null ? other$view != null : !this$view.equals(other$view)) {
            return false;
        }
        Optional<String> this$valueSetId = this.getValueSetId();
        Optional<String> other$valueSetId = other.getValueSetId();
        if (this$valueSetId == null ? other$valueSetId != null : !((Object)this$valueSetId).equals(other$valueSetId)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        Object this$answer = this.getAnswer();
        Object other$answer = other.getAnswer();
        if (this$answer == null ? other$answer != null : !this$answer.equals(other$answer)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Object this$defaultValue = this.defaultValue;
        Object other$defaultValue = other.defaultValue;
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<String> this$classNames = this.getClassNames();
        List<String> other$classNames = other.getClassNames();
        if (this$classNames == null ? other$classNames != null : !((Object)this$classNames).equals(other$classNames)) {
            return false;
        }
        List<ItemId> this$items = this.getItems();
        List<ItemId> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        List<ItemId> this$availableItems = this.getAvailableItems();
        List<ItemId> other$availableItems = other.getAvailableItems();
        if (this$availableItems == null ? other$availableItems != null : !((Object)this$availableItems).equals(other$availableItems)) {
            return false;
        }
        Map<String, Object> this$props = this.props;
        Map<String, Object> other$props = other.props;
        if (this$props == null ? other$props != null : !((Object)this$props).equals(other$props)) {
            return false;
        }
        Set<Action.Type> this$allowedActions = this.getAllowedActions();
        Set<Action.Type> other$allowedActions = other.getAllowedActions();
        if (this$allowedActions == null ? other$allowedActions != null : !((Object)this$allowedActions).equals(other$allowedActions)) {
            return false;
        }
        Optional<ItemId> this$activePage = this.getActivePage();
        Optional<ItemId> other$activePage = other.getActivePage();
        return !(this$activePage == null ? other$activePage != null : !((Object)this$activePage).equals(other$activePage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ItemState;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.bits;
        ItemId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        ItemId $prototypeId = this.getPrototypeId();
        result = result * 59 + ($prototypeId == null ? 43 : $prototypeId.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $view = this.getView();
        result = result * 59 + ($view == null ? 43 : $view.hashCode());
        Optional<String> $valueSetId = this.getValueSetId();
        result = result * 59 + ($valueSetId == null ? 43 : ((Object)$valueSetId).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        Object $answer = this.getAnswer();
        result = result * 59 + ($answer == null ? 43 : $answer.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Object $defaultValue = this.defaultValue;
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<String> $classNames = this.getClassNames();
        result = result * 59 + ($classNames == null ? 43 : ((Object)$classNames).hashCode());
        List<ItemId> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        List<ItemId> $availableItems = this.getAvailableItems();
        result = result * 59 + ($availableItems == null ? 43 : ((Object)$availableItems).hashCode());
        Map<String, Object> $props = this.props;
        result = result * 59 + ($props == null ? 43 : ((Object)$props).hashCode());
        Set<Action.Type> $allowedActions = this.getAllowedActions();
        result = result * 59 + ($allowedActions == null ? 43 : ((Object)$allowedActions).hashCode());
        Optional<ItemId> $activePage = this.getActivePage();
        result = result * 59 + ($activePage == null ? 43 : ((Object)$activePage).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ItemState(id=" + String.valueOf(this.getId()) + ", prototypeId=" + String.valueOf(this.getPrototypeId()) + ", type=" + this.getType() + ", view=" + this.getView() + ", valueSetId=" + String.valueOf(this.getValueSetId()) + ", status=" + String.valueOf((Object)this.getStatus()) + ", answer=" + String.valueOf(this.getAnswer()) + ", value=" + String.valueOf(this.getValue()) + ", defaultValue=" + String.valueOf(this.defaultValue) + ", bits=" + this.bits + ", label=" + this.getLabel() + ", description=" + this.getDescription() + ", classNames=" + String.valueOf(this.getClassNames()) + ", items=" + String.valueOf(this.getItems()) + ", availableItems=" + String.valueOf(this.getAvailableItems()) + ", props=" + String.valueOf(this.props) + ", allowedActions=" + String.valueOf(this.getAllowedActions()) + ", activePage=" + String.valueOf(this.getActivePage()) + ")";
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Generated
    public Object getAnswer() {
        return this.answer;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<String> getClassNames() {
        return this.classNames;
    }

    @Generated
    public List<ItemId> getAvailableItems() {
        return this.availableItems;
    }

    @Generated
    public Set<Action.Type> getAllowedActions() {
        return this.allowedActions;
    }

    public static enum Status {
        NEW,
        OK,
        ERROR,
        PENDING;

    }

    public class UpdateBuilder {
        private ItemState itemState;

        UpdateBuilder() {
        }

        private ItemState state() {
            if (this.itemState == null) {
                this.itemState = new ItemState(ItemState.this);
            }
            return this.itemState;
        }

        private boolean hasNewState() {
            return this.itemState != null;
        }

        public UpdateBuilder setStatus(Status newStatus) {
            if (ItemState.this.status != newStatus) {
                this.state().status = newStatus;
            }
            return this;
        }

        public UpdateBuilder setAnswer(Object newAnswer) {
            if (!Objects.equals(ItemState.this.answer, newAnswer)) {
                this.state().answer = newAnswer;
            }
            return this;
        }

        public UpdateBuilder setValue(Object newValue) {
            if (!Objects.equals(ItemState.this.value, newValue)) {
                this.state().value = newValue;
            }
            return this;
        }

        public UpdateBuilder setActive(boolean newActive) {
            if (ItemState.this.isBit(2) != newActive) {
                this.state().setBits(newActive, 2);
            }
            return this;
        }

        public UpdateBuilder setDisabled(Boolean newDisabled) {
            if (newDisabled == null) {
                return this;
            }
            if (ItemState.this.isBit(4) != newDisabled.booleanValue()) {
                this.state().setBits(newDisabled, 4);
            }
            return this;
        }

        public UpdateBuilder setRequired(boolean newRequired) {
            if (ItemState.this.isBit(8) != newRequired) {
                this.state().setBits(newRequired, 8);
            }
            return this;
        }

        public UpdateBuilder setRowsCanBeAdded(boolean newRowsCanBeAdded) {
            if (ItemState.this.isBit(16) != newRowsCanBeAdded) {
                this.state().setBits(newRowsCanBeAdded, 16);
            }
            return this;
        }

        public UpdateBuilder setRowCanBeRemoved(boolean newRowsCanBeRemoved) {
            if (ItemState.this.isBit(32) != newRowsCanBeRemoved) {
                this.state().setBits(newRowsCanBeRemoved, 32);
            }
            return this;
        }

        public UpdateBuilder setHasCustomProps(boolean newHasCustomProps) {
            if (ItemState.this.isBit(128) != newHasCustomProps) {
                this.state().setBits(newHasCustomProps, 128);
            }
            return this;
        }

        public UpdateBuilder setLabel(String newLabel) {
            if (!Objects.equals(ItemState.this.label, newLabel)) {
                this.state().label = newLabel;
            }
            return this;
        }

        public UpdateBuilder setDescription(String newDescription) {
            if (!Objects.equals(ItemState.this.description, newDescription)) {
                this.state().description = newDescription;
            }
            return this;
        }

        public UpdateBuilder setProp(String propName, Object newValue) {
            Object previous = ItemState.this.props.get(propName);
            if (!Objects.equals(previous, newValue)) {
                this.state().props.put(propName, newValue);
            }
            return this;
        }

        public UpdateBuilder setClassNames(List<String> newClassNames) {
            if (!Objects.equals(ItemState.this.classNames, newClassNames)) {
                this.state().classNames = List.copyOf(newClassNames);
            }
            return this;
        }

        public UpdateBuilder setItems(List<ItemId> newItems) {
            if (!Objects.equals(ItemState.this.items, newItems)) {
                this.state().items = List.copyOf(newItems);
            }
            return this;
        }

        public UpdateBuilder setAvailableItems(List<ItemId> newAvailableItems) {
            if (!Objects.equals(ItemState.this.availableItems, newAvailableItems)) {
                this.state().availableItems = List.copyOf(newAvailableItems);
            }
            return this;
        }

        public UpdateBuilder setAllowedActions(Set<Action.Type> newAllowedActions) {
            if (!Objects.equals(ItemState.this.allowedActions, newAllowedActions)) {
                this.state().allowedActions = Set.copyOf(newAllowedActions);
            }
            return this;
        }

        public UpdateBuilder setActivePage(ItemId newActivePage) {
            if ((this.hasNewState() && this.state().items.contains(newActivePage) || ItemState.this.items.contains(newActivePage)) && !Objects.equals(ItemState.this.activePage, newActivePage)) {
                this.state().activePage = newActivePage;
            }
            return this;
        }

        public UpdateBuilder setInvalidAnswers(boolean newIsInvalidAnswers) {
            if (ItemState.this.isBit(64) != newIsInvalidAnswers) {
                this.state().setBits(newIsInvalidAnswers, 64);
            }
            return this;
        }

        public ItemState get() {
            if (this.itemState == null) {
                return ItemState.this;
            }
            return this.itemState;
        }
    }
}

