/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.model.ErrorId;
import io.dialob.session.engine.session.model.ErrorState;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import io.dialob.session.engine.session.model.ItemStates;
import io.dialob.session.engine.session.model.ValueSetId;
import io.dialob.session.engine.session.model.ValueSetState;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ItemStates", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableItemStates
implements ItemStates {
    private final ImmutableMap<ItemId, ItemState> itemStates;
    private final ImmutableMap<ValueSetId, ValueSetState> valueSetStates;
    private final ImmutableMap<ErrorId, ErrorState> errorStates;

    private ImmutableItemStates(ImmutableMap<ItemId, ItemState> itemStates, ImmutableMap<ValueSetId, ValueSetState> valueSetStates, ImmutableMap<ErrorId, ErrorState> errorStates) {
        this.itemStates = itemStates;
        this.valueSetStates = valueSetStates;
        this.errorStates = errorStates;
    }

    public ImmutableMap<ItemId, ItemState> getItemStates() {
        return this.itemStates;
    }

    public ImmutableMap<ValueSetId, ValueSetState> getValueSetStates() {
        return this.valueSetStates;
    }

    public ImmutableMap<ErrorId, ErrorState> getErrorStates() {
        return this.errorStates;
    }

    public final ImmutableItemStates withItemStates(Map<? extends ItemId, ? extends ItemState> entries) {
        if (this.itemStates == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableItemStates((ImmutableMap<ItemId, ItemState>)newValue, this.valueSetStates, this.errorStates);
    }

    public final ImmutableItemStates withValueSetStates(Map<? extends ValueSetId, ? extends ValueSetState> entries) {
        if (this.valueSetStates == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableItemStates(this.itemStates, (ImmutableMap<ValueSetId, ValueSetState>)newValue, this.errorStates);
    }

    public final ImmutableItemStates withErrorStates(Map<? extends ErrorId, ? extends ErrorState> entries) {
        if (this.errorStates == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableItemStates(this.itemStates, this.valueSetStates, (ImmutableMap<ErrorId, ErrorState>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableItemStates && this.equalsByValue((ImmutableItemStates)another);
    }

    private boolean equalsByValue(ImmutableItemStates another) {
        return this.itemStates.equals(another.itemStates) && this.valueSetStates.equals(another.valueSetStates) && this.errorStates.equals(another.errorStates);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.itemStates.hashCode();
        h += (h << 5) + this.valueSetStates.hashCode();
        h += (h << 5) + this.errorStates.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ItemStates").omitNullValues().add("itemStates", this.itemStates).add("valueSetStates", this.valueSetStates).add("errorStates", this.errorStates).toString();
    }

    public static ImmutableItemStates copyOf(ItemStates instance) {
        if (instance instanceof ImmutableItemStates) {
            return (ImmutableItemStates)instance;
        }
        return ImmutableItemStates.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ItemStates", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableMap.Builder<ItemId, ItemState> itemStates = ImmutableMap.builder();
        private ImmutableMap.Builder<ValueSetId, ValueSetState> valueSetStates = ImmutableMap.builder();
        private ImmutableMap.Builder<ErrorId, ErrorState> errorStates = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ItemStates instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllItemStates(instance.getItemStates());
            this.putAllValueSetStates(instance.getValueSetStates());
            this.putAllErrorStates(instance.getErrorStates());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putItemStates(ItemId key, ItemState value) {
            this.itemStates.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putItemStates(Map.Entry<? extends ItemId, ? extends ItemState> entry) {
            this.itemStates.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder itemStates(Map<? extends ItemId, ? extends ItemState> entries) {
            this.itemStates = ImmutableMap.builder();
            return this.putAllItemStates(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllItemStates(Map<? extends ItemId, ? extends ItemState> entries) {
            this.itemStates.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putValueSetStates(ValueSetId key, ValueSetState value) {
            this.valueSetStates.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putValueSetStates(Map.Entry<? extends ValueSetId, ? extends ValueSetState> entry) {
            this.valueSetStates.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder valueSetStates(Map<? extends ValueSetId, ? extends ValueSetState> entries) {
            this.valueSetStates = ImmutableMap.builder();
            return this.putAllValueSetStates(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllValueSetStates(Map<? extends ValueSetId, ? extends ValueSetState> entries) {
            this.valueSetStates.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putErrorStates(ErrorId key, ErrorState value) {
            this.errorStates.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putErrorStates(Map.Entry<? extends ErrorId, ? extends ErrorState> entry) {
            this.errorStates.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder errorStates(Map<? extends ErrorId, ? extends ErrorState> entries) {
            this.errorStates = ImmutableMap.builder();
            return this.putAllErrorStates(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllErrorStates(Map<? extends ErrorId, ? extends ErrorState> entries) {
            this.errorStates.putAll(entries);
            return this;
        }

        public ImmutableItemStates build() {
            return new ImmutableItemStates((ImmutableMap<ItemId, ItemState>)this.itemStates.build(), (ImmutableMap<ValueSetId, ValueSetState>)this.valueSetStates.build(), (ImmutableMap<ErrorId, ErrorState>)this.errorStates.build());
        }
    }
}

