/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.model;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemIndex;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ItemIndex", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableItemIndex
implements ItemIndex {
    @Nullable
    private final ItemId parent;
    private final Integer index;

    private ImmutableItemIndex(Integer index, Optional<? extends ItemId> parent) {
        this.index = Objects.requireNonNull(index, "index");
        this.parent = parent.orElse(null);
    }

    private ImmutableItemIndex(ImmutableItemIndex original, @Nullable ItemId parent, Integer index) {
        this.parent = parent;
        this.index = index;
    }

    @Override
    public Optional<ItemId> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public Integer getIndex() {
        return this.index;
    }

    public final ImmutableItemIndex withParent(ItemId value) {
        ItemId newValue = Objects.requireNonNull(value, "parent");
        if (this.parent == newValue) {
            return this;
        }
        return new ImmutableItemIndex(this, newValue, this.index);
    }

    @Override
    public final ImmutableItemIndex withParent(Optional<? extends ItemId> optional) {
        ItemId value = optional.orElse(null);
        if (this.parent == value) {
            return this;
        }
        return new ImmutableItemIndex(this, value, this.index);
    }

    public final ImmutableItemIndex withIndex(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "index");
        if (this.index.equals(newValue)) {
            return this;
        }
        return new ImmutableItemIndex(this, this.parent, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableItemIndex && this.equalsByValue((ImmutableItemIndex)another);
    }

    private boolean equalsByValue(ImmutableItemIndex another) {
        return Objects.equals(this.parent, another.parent) && this.index.equals(another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.parent);
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ItemIndex").omitNullValues().add("parent", (Object)this.parent).add("index", (Object)this.index).toString();
    }

    public static ImmutableItemIndex of(Integer index, Optional<? extends ItemId> parent) {
        return new ImmutableItemIndex(index, parent);
    }

    public static ImmutableItemIndex copyOf(ItemIndex instance) {
        if (instance instanceof ImmutableItemIndex) {
            return (ImmutableItemIndex)instance;
        }
        return ImmutableItemIndex.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ItemIndex", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INDEX = 1L;
        private long initBits = 1L;
        @Nullable
        private ItemId parent;
        @Nullable
        private Integer index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ItemIndex instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ItemId instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            Optional<ItemId> parentOptional;
            ItemId instance;
            long bits = 0L;
            if (object instanceof ItemIndex) {
                instance = (ItemIndex)object;
                if ((bits & 1L) == 0L) {
                    parentOptional = instance.getParent();
                    if (parentOptional.isPresent()) {
                        this.parent(parentOptional);
                    }
                    bits |= 1L;
                }
                this.index(instance.getIndex());
            }
            if (object instanceof ItemId) {
                instance = (ItemId)object;
                if ((bits & 1L) == 0L) {
                    parentOptional = instance.getParent();
                    if (parentOptional.isPresent()) {
                        this.parent(parentOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder parent(ItemId parent) {
            this.parent = Objects.requireNonNull(parent, "parent");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parent(Optional<? extends ItemId> parent) {
            this.parent = parent.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder index(Integer index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableItemIndex build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableItemIndex(null, this.parent, this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build ItemIndex, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

