/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.command.event.ValueSetEvent;
import io.dialob.session.engine.session.command.event.ValueSetUpdatedEvent;
import io.dialob.session.engine.session.model.ValueSetId;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ValueSetUpdatedEvent", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableValueSetUpdatedEvent
implements ValueSetUpdatedEvent {
    private final ValueSetId valueSetId;

    private ImmutableValueSetUpdatedEvent(ValueSetId valueSetId) {
        this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
    }

    private ImmutableValueSetUpdatedEvent(ImmutableValueSetUpdatedEvent original, ValueSetId valueSetId) {
        this.valueSetId = valueSetId;
    }

    @Override
    public ValueSetId getValueSetId() {
        return this.valueSetId;
    }

    public final ImmutableValueSetUpdatedEvent withValueSetId(ValueSetId value) {
        if (this.valueSetId == value) {
            return this;
        }
        ValueSetId newValue = Objects.requireNonNull(value, "valueSetId");
        return new ImmutableValueSetUpdatedEvent(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValueSetUpdatedEvent && this.equalsByValue((ImmutableValueSetUpdatedEvent)another);
    }

    private boolean equalsByValue(ImmutableValueSetUpdatedEvent another) {
        return this.valueSetId.equals(another.valueSetId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.valueSetId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ValueSetUpdatedEvent").omitNullValues().add("valueSetId", (Object)this.valueSetId).toString();
    }

    public static ImmutableValueSetUpdatedEvent of(ValueSetId valueSetId) {
        return new ImmutableValueSetUpdatedEvent(valueSetId);
    }

    public static ImmutableValueSetUpdatedEvent copyOf(ValueSetUpdatedEvent instance) {
        if (instance instanceof ImmutableValueSetUpdatedEvent) {
            return (ImmutableValueSetUpdatedEvent)instance;
        }
        return ImmutableValueSetUpdatedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ValueSetUpdatedEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE_SET_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private ValueSetId valueSetId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ValueSetUpdatedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ValueSetEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            ValueSetEvent instance;
            long bits = 0L;
            if (object instanceof ValueSetUpdatedEvent) {
                instance = (ValueSetUpdatedEvent)object;
                if ((bits & 1L) == 0L) {
                    this.valueSetId(instance.getValueSetId());
                    bits |= 1L;
                }
            }
            if (object instanceof ValueSetEvent) {
                instance = (ValueSetEvent)object;
                if ((bits & 1L) == 0L) {
                    this.valueSetId(instance.getValueSetId());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder valueSetId(ValueSetId valueSetId) {
            this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableValueSetUpdatedEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableValueSetUpdatedEvent(null, this.valueSetId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("valueSetId");
            }
            return "Cannot build ValueSetUpdatedEvent, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

