/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.dialob.session.engine.Utils;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.session.command.AbstractUpdateCommand;
import io.dialob.session.engine.session.command.ItemUpdateCommand;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import org.immutables.value.Value;

@Value.Immutable
public interface SetAnswer
extends AbstractUpdateCommand<ItemId, ItemState>,
ItemUpdateCommand {
    @Value.Parameter(order=1)
    @Nullable
    public Object getAnswer();

    @Override
    @NonNull
    default public ItemState update(@NonNull EvalContext context, @NonNull ItemState itemState) {
        if (this.canUpdate(context, itemState)) {
            Object answer = this.getAnswer();
            return itemState.update().setAnswer(answer).setValue(Utils.parse(itemState.getType(), answer)).get();
        }
        return itemState;
    }

    default public boolean canUpdate(@NonNull EvalContext context, @NonNull ItemState itemState) {
        return (context.isActivating() || !itemState.isDisabled() && itemState.isActive()) && Utils.isQuestionType(itemState);
    }
}

