/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.session.command.AbstractUpdateCommand;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.EventMatchers;
import io.dialob.session.engine.session.command.ItemUpdateCommand;
import io.dialob.session.engine.session.model.ImmutableItemIndex;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.immutables.value.Value;

@Value.Immutable
public interface InitRowGroupItemsCommand
extends AbstractUpdateCommand<ItemId, ItemState>,
ItemUpdateCommand {
    @Override
    @NonNull
    default public ItemState update(@NonNull EvalContext context, @NonNull ItemState itemState) {
        List rowNumbers = (List)itemState.getValue();
        if (rowNumbers == null) {
            rowNumbers = Collections.emptyList();
        }
        List<ItemId> newItems = rowNumbers.stream().map(row -> ImmutableItemIndex.of(row.intValue(), Optional.of(this.getTargetId()))).toList();
        return itemState.update().setItems(newItems).get();
    }

    @Override
    @NonNull
    default public Set<EventMatcher> getEventMatchers() {
        return Set.of(EventMatchers.whenValueUpdated(this.getTargetId()));
    }
}

