/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.command.SetVariableValue;
import io.dialob.session.engine.session.command.Trigger;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SetVariableValue", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableSetVariableValue
implements SetVariableValue {
    private final ImmutableList<Trigger<ItemState>> triggers;
    private final ItemId targetId;
    @Nullable
    private final Object value;

    private ImmutableSetVariableValue(ItemId targetId, @Nullable Object value, Iterable<? extends Trigger<ItemState>> triggers) {
        this.targetId = Objects.requireNonNull(targetId, "targetId");
        this.value = value;
        this.triggers = ImmutableList.copyOf(triggers);
    }

    private ImmutableSetVariableValue(ImmutableSetVariableValue original, ImmutableList<Trigger<ItemState>> triggers, ItemId targetId, @Nullable Object value) {
        this.triggers = triggers;
        this.targetId = targetId;
        this.value = value;
    }

    @Override
    public ImmutableList<Trigger<ItemState>> getTriggers() {
        return this.triggers;
    }

    @Override
    public ItemId getTargetId() {
        return this.targetId;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.value;
    }

    @SafeVarargs
    public final ImmutableSetVariableValue withTriggers(Trigger<ItemState> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSetVariableValue(this, (ImmutableList<Trigger<ItemState>>)newValue, this.targetId, this.value);
    }

    public final ImmutableSetVariableValue withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
        if (this.triggers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSetVariableValue(this, (ImmutableList<Trigger<ItemState>>)newValue, this.targetId, this.value);
    }

    public final ImmutableSetVariableValue withTargetId(ItemId value) {
        if (this.targetId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "targetId");
        return new ImmutableSetVariableValue(this, this.triggers, newValue, this.value);
    }

    public final ImmutableSetVariableValue withValue(@Nullable Object value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableSetVariableValue(this, this.triggers, this.targetId, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetVariableValue && this.equalsByValue((ImmutableSetVariableValue)another);
    }

    private boolean equalsByValue(ImmutableSetVariableValue another) {
        return this.triggers.equals(another.triggers) && this.targetId.equals(another.targetId) && Objects.equals(this.value, another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.triggers.hashCode();
        h += (h << 5) + this.targetId.hashCode();
        h += (h << 5) + Objects.hashCode(this.value);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SetVariableValue").omitNullValues().add("triggers", this.triggers).add("targetId", (Object)this.targetId).add("value", this.value).toString();
    }

    public static ImmutableSetVariableValue of(ItemId targetId, @Nullable Object value, List<Trigger<ItemState>> triggers) {
        return ImmutableSetVariableValue.of(targetId, value, triggers);
    }

    public static ImmutableSetVariableValue of(ItemId targetId, @Nullable Object value, Iterable<? extends Trigger<ItemState>> triggers) {
        return new ImmutableSetVariableValue(targetId, value, triggers);
    }

    public static ImmutableSetVariableValue copyOf(SetVariableValue instance) {
        if (instance instanceof ImmutableSetVariableValue) {
            return (ImmutableSetVariableValue)instance;
        }
        return ImmutableSetVariableValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SetVariableValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TARGET_ID = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
        @javax.annotation.Nullable
        private ItemId targetId;
        @javax.annotation.Nullable
        private Object value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SetVariableValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllTriggers(instance.getTriggers());
            this.targetId((ItemId)instance.getTargetId());
            Object valueValue = instance.getValue();
            if (valueValue != null) {
                this.value(valueValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> element) {
            this.triggers.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addTriggers(Trigger<ItemState> ... elements) {
            this.triggers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers = ImmutableList.builder();
            return this.addAllTriggers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
            this.triggers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetId(ItemId targetId) {
            this.targetId = Objects.requireNonNull(targetId, "targetId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(@Nullable Object value) {
            this.value = value;
            return this;
        }

        public ImmutableSetVariableValue build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetVariableValue(null, (ImmutableList<Trigger<ItemState>>)this.triggers.build(), this.targetId, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("targetId");
            }
            return "Cannot build SetVariableValue, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

