/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.session.engine.session.command.EventMatchers;
import io.dialob.session.engine.session.model.ErrorId;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ValueSetId;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="EventMatchers", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableEventMatchers {
    private ImmutableEventMatchers() {
    }

    @CheckReturnValue
    @Generated(from="EventMatchers.ValueSetUpdatedEventMatcher", generator="Immutables")
    @Immutable
    static final class ValueSetUpdatedEventMatcher
    implements EventMatchers.ValueSetUpdatedEventMatcher {
        private final ValueSetId valueSetId;

        private ValueSetUpdatedEventMatcher(ValueSetId valueSetId) {
            this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
        }

        private ValueSetUpdatedEventMatcher(ValueSetUpdatedEventMatcher original, ValueSetId valueSetId) {
            this.valueSetId = valueSetId;
        }

        @Override
        public ValueSetId getValueSetId() {
            return this.valueSetId;
        }

        public final ValueSetUpdatedEventMatcher withValueSetId(ValueSetId value) {
            if (this.valueSetId == value) {
                return this;
            }
            ValueSetId newValue = Objects.requireNonNull(value, "valueSetId");
            return new ValueSetUpdatedEventMatcher(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ValueSetUpdatedEventMatcher && this.equalsByValue((ValueSetUpdatedEventMatcher)another);
        }

        private boolean equalsByValue(ValueSetUpdatedEventMatcher another) {
            return this.valueSetId.equals(another.valueSetId);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.valueSetId.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ValueSetUpdatedEventMatcher").omitNullValues().add("valueSetId", (Object)this.valueSetId).toString();
        }

        public static ValueSetUpdatedEventMatcher of(ValueSetId valueSetId) {
            return new ValueSetUpdatedEventMatcher(valueSetId);
        }

        public static ValueSetUpdatedEventMatcher copyOf(EventMatchers.ValueSetUpdatedEventMatcher instance) {
            if (instance instanceof ValueSetUpdatedEventMatcher) {
                return (ValueSetUpdatedEventMatcher)instance;
            }
            return ValueSetUpdatedEventMatcher.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EventMatchers.ValueSetUpdatedEventMatcher", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_VALUE_SET_ID = 1L;
            private long initBits = 1L;
            @Nullable
            private ValueSetId valueSetId;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EventMatchers.ValueSetEventMatcher instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(EventMatchers.ValueSetUpdatedEventMatcher instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                EventMatchers.ValueSetEventMatcher instance;
                long bits = 0L;
                if (object instanceof EventMatchers.ValueSetEventMatcher) {
                    instance = (EventMatchers.ValueSetEventMatcher)object;
                    if ((bits & 1L) == 0L) {
                        this.valueSetId(instance.getValueSetId());
                        bits |= 1L;
                    }
                }
                if (object instanceof EventMatchers.ValueSetUpdatedEventMatcher) {
                    instance = (EventMatchers.ValueSetUpdatedEventMatcher)object;
                    if ((bits & 1L) == 0L) {
                        this.valueSetId(instance.getValueSetId());
                        bits |= 1L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder valueSetId(ValueSetId valueSetId) {
                this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public ValueSetUpdatedEventMatcher build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ValueSetUpdatedEventMatcher(null, this.valueSetId);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("valueSetId");
                }
                return "Cannot build ValueSetUpdatedEventMatcher, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EventMatchers.ErrorActivityEventMatcher", generator="Immutables")
    @Immutable
    static final class ErrorActivityEventMatcher
    implements EventMatchers.ErrorActivityEventMatcher {
        private final EventMatchers.ErrorEventMatcher errorEventMatcher;

        private ErrorActivityEventMatcher(EventMatchers.ErrorEventMatcher errorEventMatcher) {
            this.errorEventMatcher = Objects.requireNonNull(errorEventMatcher, "errorEventMatcher");
        }

        private ErrorActivityEventMatcher(ErrorActivityEventMatcher original, EventMatchers.ErrorEventMatcher errorEventMatcher) {
            this.errorEventMatcher = errorEventMatcher;
        }

        @Override
        public EventMatchers.ErrorEventMatcher getErrorEventMatcher() {
            return this.errorEventMatcher;
        }

        public final ErrorActivityEventMatcher withErrorEventMatcher(EventMatchers.ErrorEventMatcher value) {
            if (this.errorEventMatcher == value) {
                return this;
            }
            EventMatchers.ErrorEventMatcher newValue = Objects.requireNonNull(value, "errorEventMatcher");
            return new ErrorActivityEventMatcher(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ErrorActivityEventMatcher && this.equalsByValue((ErrorActivityEventMatcher)another);
        }

        private boolean equalsByValue(ErrorActivityEventMatcher another) {
            return this.errorEventMatcher.equals(another.errorEventMatcher);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.errorEventMatcher.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ErrorActivityEventMatcher").omitNullValues().add("errorEventMatcher", (Object)this.errorEventMatcher).toString();
        }

        public static ErrorActivityEventMatcher of(EventMatchers.ErrorEventMatcher errorEventMatcher) {
            return new ErrorActivityEventMatcher(errorEventMatcher);
        }

        public static ErrorActivityEventMatcher copyOf(EventMatchers.ErrorActivityEventMatcher instance) {
            if (instance instanceof ErrorActivityEventMatcher) {
                return (ErrorActivityEventMatcher)instance;
            }
            return ErrorActivityEventMatcher.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EventMatchers.ErrorActivityEventMatcher", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_ERROR_EVENT_MATCHER = 1L;
            private long initBits = 1L;
            @Nullable
            private EventMatchers.ErrorEventMatcher errorEventMatcher;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EventMatchers.ErrorActivityEventMatcher instance) {
                Objects.requireNonNull(instance, "instance");
                this.errorEventMatcher(instance.getErrorEventMatcher());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder errorEventMatcher(EventMatchers.ErrorEventMatcher errorEventMatcher) {
                this.errorEventMatcher = Objects.requireNonNull(errorEventMatcher, "errorEventMatcher");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public ErrorActivityEventMatcher build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ErrorActivityEventMatcher(null, this.errorEventMatcher);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("errorEventMatcher");
                }
                return "Cannot build ErrorActivityEventMatcher, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EventMatchers.ErrorIdEventMatcher", generator="Immutables")
    @Immutable
    static final class ErrorIdEventMatcher
    implements EventMatchers.ErrorIdEventMatcher {
        private final ErrorId errorId;

        private ErrorIdEventMatcher(ErrorId errorId) {
            this.errorId = Objects.requireNonNull(errorId, "errorId");
        }

        private ErrorIdEventMatcher(ErrorIdEventMatcher original, ErrorId errorId) {
            this.errorId = errorId;
        }

        @Override
        public ErrorId getErrorId() {
            return this.errorId;
        }

        public final ErrorIdEventMatcher withErrorId(ErrorId value) {
            if (this.errorId == value) {
                return this;
            }
            ErrorId newValue = Objects.requireNonNull(value, "errorId");
            return new ErrorIdEventMatcher(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ErrorIdEventMatcher && this.equalsByValue((ErrorIdEventMatcher)another);
        }

        private boolean equalsByValue(ErrorIdEventMatcher another) {
            return this.errorId.equals(another.errorId);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.errorId.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ErrorIdEventMatcher").omitNullValues().add("errorId", (Object)this.errorId).toString();
        }

        public static ErrorIdEventMatcher of(ErrorId errorId) {
            return new ErrorIdEventMatcher(errorId);
        }

        public static ErrorIdEventMatcher copyOf(EventMatchers.ErrorIdEventMatcher instance) {
            if (instance instanceof ErrorIdEventMatcher) {
                return (ErrorIdEventMatcher)instance;
            }
            return ErrorIdEventMatcher.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EventMatchers.ErrorIdEventMatcher", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_ERROR_ID = 1L;
            private long initBits = 1L;
            @Nullable
            private ErrorId errorId;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EventMatchers.ErrorIdEventMatcher instance) {
                Objects.requireNonNull(instance, "instance");
                this.errorId(instance.getErrorId());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder errorId(ErrorId errorId) {
                this.errorId = Objects.requireNonNull(errorId, "errorId");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public ErrorIdEventMatcher build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ErrorIdEventMatcher(null, this.errorId);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("errorId");
                }
                return "Cannot build ErrorIdEventMatcher, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EventMatchers.TargetErrorEventMatcher", generator="Immutables")
    @Immutable
    static final class TargetErrorEventMatcher
    implements EventMatchers.TargetErrorEventMatcher {
        private final ItemId targetId;

        private TargetErrorEventMatcher(ItemId targetId) {
            this.targetId = Objects.requireNonNull(targetId, "targetId");
        }

        private TargetErrorEventMatcher(TargetErrorEventMatcher original, ItemId targetId) {
            this.targetId = targetId;
        }

        @Override
        public ItemId getTargetId() {
            return this.targetId;
        }

        public final TargetErrorEventMatcher withTargetId(ItemId value) {
            if (this.targetId == value) {
                return this;
            }
            ItemId newValue = Objects.requireNonNull(value, "targetId");
            return new TargetErrorEventMatcher(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof TargetErrorEventMatcher && this.equalsByValue((TargetErrorEventMatcher)another);
        }

        private boolean equalsByValue(TargetErrorEventMatcher another) {
            return this.targetId.equals(another.targetId);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.targetId.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"TargetErrorEventMatcher").omitNullValues().add("targetId", (Object)this.targetId).toString();
        }

        public static TargetErrorEventMatcher of(ItemId targetId) {
            return new TargetErrorEventMatcher(targetId);
        }

        public static TargetErrorEventMatcher copyOf(EventMatchers.TargetErrorEventMatcher instance) {
            if (instance instanceof TargetErrorEventMatcher) {
                return (TargetErrorEventMatcher)instance;
            }
            return TargetErrorEventMatcher.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EventMatchers.TargetErrorEventMatcher", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_TARGET_ID = 1L;
            private long initBits = 1L;
            @Nullable
            private ItemId targetId;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EventMatchers.TargetErrorEventMatcher instance) {
                Objects.requireNonNull(instance, "instance");
                this.targetId(instance.getTargetId());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder targetId(ItemId targetId) {
                this.targetId = Objects.requireNonNull(targetId, "targetId");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public TargetErrorEventMatcher build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new TargetErrorEventMatcher(null, this.targetId);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("targetId");
                }
                return "Cannot build TargetErrorEventMatcher, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EventMatchers.AnyErrorEventMatcher", generator="Immutables")
    @Immutable
    static final class AnyErrorEventMatcher
    implements EventMatchers.AnyErrorEventMatcher {
        private AnyErrorEventMatcher(Builder builder) {
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof AnyErrorEventMatcher && this.equalsByValue((AnyErrorEventMatcher)another);
        }

        private boolean equalsByValue(AnyErrorEventMatcher another) {
            return true;
        }

        public int hashCode() {
            return 1596737682;
        }

        public String toString() {
            return "AnyErrorEventMatcher{}";
        }

        public static AnyErrorEventMatcher copyOf(EventMatchers.AnyErrorEventMatcher instance) {
            if (instance instanceof AnyErrorEventMatcher) {
                return (AnyErrorEventMatcher)instance;
            }
            return AnyErrorEventMatcher.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EventMatchers.AnyErrorEventMatcher", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EventMatchers.AnyErrorEventMatcher instance) {
                Objects.requireNonNull(instance, "instance");
                return this;
            }

            public AnyErrorEventMatcher build() {
                return new AnyErrorEventMatcher(this);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EventMatchers.AvailableItemsEventMatcher", generator="Immutables")
    @Immutable
    static final class AvailableItemsEventMatcher
    implements EventMatchers.AvailableItemsEventMatcher {
        private AvailableItemsEventMatcher(Builder builder) {
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof AvailableItemsEventMatcher && this.equalsByValue((AvailableItemsEventMatcher)another);
        }

        private boolean equalsByValue(AvailableItemsEventMatcher another) {
            return true;
        }

        public int hashCode() {
            return -1355039795;
        }

        public String toString() {
            return "AvailableItemsEventMatcher{}";
        }

        public static AvailableItemsEventMatcher copyOf(EventMatchers.AvailableItemsEventMatcher instance) {
            if (instance instanceof AvailableItemsEventMatcher) {
                return (AvailableItemsEventMatcher)instance;
            }
            return AvailableItemsEventMatcher.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EventMatchers.AvailableItemsEventMatcher", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EventMatchers.AvailableItemsEventMatcher instance) {
                Objects.requireNonNull(instance, "instance");
                return this;
            }

            public AvailableItemsEventMatcher build() {
                return new AvailableItemsEventMatcher(this);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EventMatchers.ActivePageEventMatcher", generator="Immutables")
    @Immutable
    static final class ActivePageEventMatcher
    implements EventMatchers.ActivePageEventMatcher {
        private ActivePageEventMatcher(Builder builder) {
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ActivePageEventMatcher && this.equalsByValue((ActivePageEventMatcher)another);
        }

        private boolean equalsByValue(ActivePageEventMatcher another) {
            return true;
        }

        public int hashCode() {
            return 469366411;
        }

        public String toString() {
            return "ActivePageEventMatcher{}";
        }

        public static ActivePageEventMatcher copyOf(EventMatchers.ActivePageEventMatcher instance) {
            if (instance instanceof ActivePageEventMatcher) {
                return (ActivePageEventMatcher)instance;
            }
            return ActivePageEventMatcher.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EventMatchers.ActivePageEventMatcher", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EventMatchers.ActivePageEventMatcher instance) {
                Objects.requireNonNull(instance, "instance");
                return this;
            }

            public ActivePageEventMatcher build() {
                return new ActivePageEventMatcher(this);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EventMatchers.AnsweredTargetEventMatcher", generator="Immutables")
    @Immutable
    static final class AnsweredTargetEventMatcher
    implements EventMatchers.AnsweredTargetEventMatcher {
        private final ItemId targetMatcher;

        private AnsweredTargetEventMatcher(ItemId targetMatcher) {
            this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
        }

        private AnsweredTargetEventMatcher(AnsweredTargetEventMatcher original, ItemId targetMatcher) {
            this.targetMatcher = targetMatcher;
        }

        @Override
        public ItemId getTargetMatcher() {
            return this.targetMatcher;
        }

        public final AnsweredTargetEventMatcher withTargetMatcher(ItemId value) {
            if (this.targetMatcher == value) {
                return this;
            }
            ItemId newValue = Objects.requireNonNull(value, "targetMatcher");
            return new AnsweredTargetEventMatcher(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof AnsweredTargetEventMatcher && this.equalsByValue((AnsweredTargetEventMatcher)another);
        }

        private boolean equalsByValue(AnsweredTargetEventMatcher another) {
            return this.targetMatcher.equals(another.targetMatcher);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.targetMatcher.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"AnsweredTargetEventMatcher").omitNullValues().add("targetMatcher", (Object)this.targetMatcher).toString();
        }

        public static AnsweredTargetEventMatcher of(ItemId targetMatcher) {
            return new AnsweredTargetEventMatcher(targetMatcher);
        }

        public static AnsweredTargetEventMatcher copyOf(EventMatchers.AnsweredTargetEventMatcher instance) {
            if (instance instanceof AnsweredTargetEventMatcher) {
                return (AnsweredTargetEventMatcher)instance;
            }
            return AnsweredTargetEventMatcher.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EventMatchers.AnsweredTargetEventMatcher", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_TARGET_MATCHER = 1L;
            private long initBits = 1L;
            @Nullable
            private ItemId targetMatcher;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EventMatchers.AnsweredTargetEventMatcher instance) {
                Objects.requireNonNull(instance, "instance");
                this.targetMatcher(instance.getTargetMatcher());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder targetMatcher(ItemId targetMatcher) {
                this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public AnsweredTargetEventMatcher build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new AnsweredTargetEventMatcher(null, this.targetMatcher);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("targetMatcher");
                }
                return "Cannot build AnsweredTargetEventMatcher, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EventMatchers.ItemsChangedEventMatcher", generator="Immutables")
    @Immutable
    static final class ItemsChangedEventMatcher
    implements EventMatchers.ItemsChangedEventMatcher {
        private final ItemId targetMatcher;

        private ItemsChangedEventMatcher(ItemId targetMatcher) {
            this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
        }

        private ItemsChangedEventMatcher(ItemsChangedEventMatcher original, ItemId targetMatcher) {
            this.targetMatcher = targetMatcher;
        }

        @Override
        public ItemId getTargetMatcher() {
            return this.targetMatcher;
        }

        public final ItemsChangedEventMatcher withTargetMatcher(ItemId value) {
            if (this.targetMatcher == value) {
                return this;
            }
            ItemId newValue = Objects.requireNonNull(value, "targetMatcher");
            return new ItemsChangedEventMatcher(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ItemsChangedEventMatcher && this.equalsByValue((ItemsChangedEventMatcher)another);
        }

        private boolean equalsByValue(ItemsChangedEventMatcher another) {
            return this.targetMatcher.equals(another.targetMatcher);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.targetMatcher.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ItemsChangedEventMatcher").omitNullValues().add("targetMatcher", (Object)this.targetMatcher).toString();
        }

        public static ItemsChangedEventMatcher of(ItemId targetMatcher) {
            return new ItemsChangedEventMatcher(targetMatcher);
        }

        public static ItemsChangedEventMatcher copyOf(EventMatchers.ItemsChangedEventMatcher instance) {
            if (instance instanceof ItemsChangedEventMatcher) {
                return (ItemsChangedEventMatcher)instance;
            }
            return ItemsChangedEventMatcher.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EventMatchers.ItemsChangedEventMatcher", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_TARGET_MATCHER = 1L;
            private long initBits = 1L;
            @Nullable
            private ItemId targetMatcher;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EventMatchers.ItemsChangedEventMatcher instance) {
                Objects.requireNonNull(instance, "instance");
                this.targetMatcher(instance.getTargetMatcher());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder targetMatcher(ItemId targetMatcher) {
                this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public ItemsChangedEventMatcher build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ItemsChangedEventMatcher(null, this.targetMatcher);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("targetMatcher");
                }
                return "Cannot build ItemsChangedEventMatcher, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EventMatchers.RowCanBeRemovedUpdatedEventMatcher", generator="Immutables")
    @Immutable
    static final class RowCanBeRemovedUpdatedEventMatcher
    implements EventMatchers.RowCanBeRemovedUpdatedEventMatcher {
        private RowCanBeRemovedUpdatedEventMatcher(Builder builder) {
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof RowCanBeRemovedUpdatedEventMatcher && this.equalsByValue((RowCanBeRemovedUpdatedEventMatcher)another);
        }

        private boolean equalsByValue(RowCanBeRemovedUpdatedEventMatcher another) {
            return true;
        }

        public int hashCode() {
            return -9297430;
        }

        public String toString() {
            return "RowCanBeRemovedUpdatedEventMatcher{}";
        }

        public static RowCanBeRemovedUpdatedEventMatcher copyOf(EventMatchers.RowCanBeRemovedUpdatedEventMatcher instance) {
            if (instance instanceof RowCanBeRemovedUpdatedEventMatcher) {
                return (RowCanBeRemovedUpdatedEventMatcher)instance;
            }
            return RowCanBeRemovedUpdatedEventMatcher.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EventMatchers.RowCanBeRemovedUpdatedEventMatcher", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EventMatchers.RowCanBeRemovedUpdatedEventMatcher instance) {
                Objects.requireNonNull(instance, "instance");
                return this;
            }

            public RowCanBeRemovedUpdatedEventMatcher build() {
                return new RowCanBeRemovedUpdatedEventMatcher(this);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EventMatchers.RowsCanBeAddedUpdatedEventMatcher", generator="Immutables")
    @Immutable
    static final class RowsCanBeAddedUpdatedEventMatcher
    implements EventMatchers.RowsCanBeAddedUpdatedEventMatcher {
        private RowsCanBeAddedUpdatedEventMatcher(Builder builder) {
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof RowsCanBeAddedUpdatedEventMatcher && this.equalsByValue((RowsCanBeAddedUpdatedEventMatcher)another);
        }

        private boolean equalsByValue(RowsCanBeAddedUpdatedEventMatcher another) {
            return true;
        }

        public int hashCode() {
            return -337496755;
        }

        public String toString() {
            return "RowsCanBeAddedUpdatedEventMatcher{}";
        }

        public static RowsCanBeAddedUpdatedEventMatcher copyOf(EventMatchers.RowsCanBeAddedUpdatedEventMatcher instance) {
            if (instance instanceof RowsCanBeAddedUpdatedEventMatcher) {
                return (RowsCanBeAddedUpdatedEventMatcher)instance;
            }
            return RowsCanBeAddedUpdatedEventMatcher.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EventMatchers.RowsCanBeAddedUpdatedEventMatcher", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EventMatchers.RowsCanBeAddedUpdatedEventMatcher instance) {
                Objects.requireNonNull(instance, "instance");
                return this;
            }

            public RowsCanBeAddedUpdatedEventMatcher build() {
                return new RowsCanBeAddedUpdatedEventMatcher(this);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EventMatchers.RowGroupItemsInitEventMatcher", generator="Immutables")
    @Immutable
    static final class RowGroupItemsInitEventMatcher
    implements EventMatchers.RowGroupItemsInitEventMatcher {
        private final ItemId prototypeId;

        private RowGroupItemsInitEventMatcher(ItemId prototypeId) {
            this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
        }

        private RowGroupItemsInitEventMatcher(RowGroupItemsInitEventMatcher original, ItemId prototypeId) {
            this.prototypeId = prototypeId;
        }

        @Override
        public ItemId getPrototypeId() {
            return this.prototypeId;
        }

        public final RowGroupItemsInitEventMatcher withPrototypeId(ItemId value) {
            if (this.prototypeId == value) {
                return this;
            }
            ItemId newValue = Objects.requireNonNull(value, "prototypeId");
            return new RowGroupItemsInitEventMatcher(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof RowGroupItemsInitEventMatcher && this.equalsByValue((RowGroupItemsInitEventMatcher)another);
        }

        private boolean equalsByValue(RowGroupItemsInitEventMatcher another) {
            return this.prototypeId.equals(another.prototypeId);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.prototypeId.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"RowGroupItemsInitEventMatcher").omitNullValues().add("prototypeId", (Object)this.prototypeId).toString();
        }

        public static RowGroupItemsInitEventMatcher of(ItemId prototypeId) {
            return new RowGroupItemsInitEventMatcher(prototypeId);
        }

        public static RowGroupItemsInitEventMatcher copyOf(EventMatchers.RowGroupItemsInitEventMatcher instance) {
            if (instance instanceof RowGroupItemsInitEventMatcher) {
                return (RowGroupItemsInitEventMatcher)instance;
            }
            return RowGroupItemsInitEventMatcher.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EventMatchers.RowGroupItemsInitEventMatcher", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_PROTOTYPE_ID = 1L;
            private long initBits = 1L;
            @Nullable
            private ItemId prototypeId;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EventMatchers.RowGroupItemsInitEventMatcher instance) {
                Objects.requireNonNull(instance, "instance");
                this.prototypeId(instance.getPrototypeId());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder prototypeId(ItemId prototypeId) {
                this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public RowGroupItemsInitEventMatcher build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new RowGroupItemsInitEventMatcher(null, this.prototypeId);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("prototypeId");
                }
                return "Cannot build RowGroupItemsInitEventMatcher, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EventMatchers.ItemRemovedEventMatcher", generator="Immutables")
    @Immutable
    static final class ItemRemovedEventMatcher
    implements EventMatchers.ItemRemovedEventMatcher {
        private final ItemId prototypeId;

        private ItemRemovedEventMatcher(ItemId prototypeId) {
            this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
        }

        private ItemRemovedEventMatcher(ItemRemovedEventMatcher original, ItemId prototypeId) {
            this.prototypeId = prototypeId;
        }

        @Override
        public ItemId getPrototypeId() {
            return this.prototypeId;
        }

        public final ItemRemovedEventMatcher withPrototypeId(ItemId value) {
            if (this.prototypeId == value) {
                return this;
            }
            ItemId newValue = Objects.requireNonNull(value, "prototypeId");
            return new ItemRemovedEventMatcher(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ItemRemovedEventMatcher && this.equalsByValue((ItemRemovedEventMatcher)another);
        }

        private boolean equalsByValue(ItemRemovedEventMatcher another) {
            return this.prototypeId.equals(another.prototypeId);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.prototypeId.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ItemRemovedEventMatcher").omitNullValues().add("prototypeId", (Object)this.prototypeId).toString();
        }

        public static ItemRemovedEventMatcher of(ItemId prototypeId) {
            return new ItemRemovedEventMatcher(prototypeId);
        }

        public static ItemRemovedEventMatcher copyOf(EventMatchers.ItemRemovedEventMatcher instance) {
            if (instance instanceof ItemRemovedEventMatcher) {
                return (ItemRemovedEventMatcher)instance;
            }
            return ItemRemovedEventMatcher.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EventMatchers.ItemRemovedEventMatcher", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_PROTOTYPE_ID = 1L;
            private long initBits = 1L;
            @Nullable
            private ItemId prototypeId;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EventMatchers.ItemRemovedEventMatcher instance) {
                Objects.requireNonNull(instance, "instance");
                this.prototypeId(instance.getPrototypeId());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder prototypeId(ItemId prototypeId) {
                this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public ItemRemovedEventMatcher build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ItemRemovedEventMatcher(null, this.prototypeId);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("prototypeId");
                }
                return "Cannot build ItemRemovedEventMatcher, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EventMatchers.ItemAddedEventMatcher", generator="Immutables")
    @Immutable
    static final class ItemAddedEventMatcher
    implements EventMatchers.ItemAddedEventMatcher {
        private final ItemId prototypeId;

        private ItemAddedEventMatcher(ItemId prototypeId) {
            this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
        }

        private ItemAddedEventMatcher(ItemAddedEventMatcher original, ItemId prototypeId) {
            this.prototypeId = prototypeId;
        }

        @Override
        public ItemId getPrototypeId() {
            return this.prototypeId;
        }

        public final ItemAddedEventMatcher withPrototypeId(ItemId value) {
            if (this.prototypeId == value) {
                return this;
            }
            ItemId newValue = Objects.requireNonNull(value, "prototypeId");
            return new ItemAddedEventMatcher(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ItemAddedEventMatcher && this.equalsByValue((ItemAddedEventMatcher)another);
        }

        private boolean equalsByValue(ItemAddedEventMatcher another) {
            return this.prototypeId.equals(another.prototypeId);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.prototypeId.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ItemAddedEventMatcher").omitNullValues().add("prototypeId", (Object)this.prototypeId).toString();
        }

        public static ItemAddedEventMatcher of(ItemId prototypeId) {
            return new ItemAddedEventMatcher(prototypeId);
        }

        public static ItemAddedEventMatcher copyOf(EventMatchers.ItemAddedEventMatcher instance) {
            if (instance instanceof ItemAddedEventMatcher) {
                return (ItemAddedEventMatcher)instance;
            }
            return ItemAddedEventMatcher.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EventMatchers.ItemAddedEventMatcher", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_PROTOTYPE_ID = 1L;
            private long initBits = 1L;
            @Nullable
            private ItemId prototypeId;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EventMatchers.ItemAddedEventMatcher instance) {
                Objects.requireNonNull(instance, "instance");
                this.prototypeId(instance.getPrototypeId());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder prototypeId(ItemId prototypeId) {
                this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public ItemAddedEventMatcher build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ItemAddedEventMatcher(null, this.prototypeId);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("prototypeId");
                }
                return "Cannot build ItemAddedEventMatcher, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EventMatchers.AnyInvalidAnswersUpdatedEventMatcher", generator="Immutables")
    @Immutable
    static final class AnyInvalidAnswersUpdatedEventMatcher
    implements EventMatchers.AnyInvalidAnswersUpdatedEventMatcher {
        private AnyInvalidAnswersUpdatedEventMatcher(Builder builder) {
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof AnyInvalidAnswersUpdatedEventMatcher && this.equalsByValue((AnyInvalidAnswersUpdatedEventMatcher)another);
        }

        private boolean equalsByValue(AnyInvalidAnswersUpdatedEventMatcher another) {
            return true;
        }

        public int hashCode() {
            return -1612456601;
        }

        public String toString() {
            return "AnyInvalidAnswersUpdatedEventMatcher{}";
        }

        public static AnyInvalidAnswersUpdatedEventMatcher copyOf(EventMatchers.AnyInvalidAnswersUpdatedEventMatcher instance) {
            if (instance instanceof AnyInvalidAnswersUpdatedEventMatcher) {
                return (AnyInvalidAnswersUpdatedEventMatcher)instance;
            }
            return AnyInvalidAnswersUpdatedEventMatcher.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EventMatchers.AnyInvalidAnswersUpdatedEventMatcher", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EventMatchers.AnyInvalidAnswersUpdatedEventMatcher instance) {
                Objects.requireNonNull(instance, "instance");
                return this;
            }

            public AnyInvalidAnswersUpdatedEventMatcher build() {
                return new AnyInvalidAnswersUpdatedEventMatcher(this);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EventMatchers.IsValidTargetEventMatcher", generator="Immutables")
    @Immutable
    static final class IsValidTargetEventMatcher
    implements EventMatchers.IsValidTargetEventMatcher {
        private final ItemId targetMatcher;

        private IsValidTargetEventMatcher(ItemId targetMatcher) {
            this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
        }

        private IsValidTargetEventMatcher(IsValidTargetEventMatcher original, ItemId targetMatcher) {
            this.targetMatcher = targetMatcher;
        }

        @Override
        public ItemId getTargetMatcher() {
            return this.targetMatcher;
        }

        public final IsValidTargetEventMatcher withTargetMatcher(ItemId value) {
            if (this.targetMatcher == value) {
                return this;
            }
            ItemId newValue = Objects.requireNonNull(value, "targetMatcher");
            return new IsValidTargetEventMatcher(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IsValidTargetEventMatcher && this.equalsByValue((IsValidTargetEventMatcher)another);
        }

        private boolean equalsByValue(IsValidTargetEventMatcher another) {
            return this.targetMatcher.equals(another.targetMatcher);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.targetMatcher.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"IsValidTargetEventMatcher").omitNullValues().add("targetMatcher", (Object)this.targetMatcher).toString();
        }

        public static IsValidTargetEventMatcher of(ItemId targetMatcher) {
            return new IsValidTargetEventMatcher(targetMatcher);
        }

        public static IsValidTargetEventMatcher copyOf(EventMatchers.IsValidTargetEventMatcher instance) {
            if (instance instanceof IsValidTargetEventMatcher) {
                return (IsValidTargetEventMatcher)instance;
            }
            return IsValidTargetEventMatcher.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EventMatchers.IsValidTargetEventMatcher", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_TARGET_MATCHER = 1L;
            private long initBits = 1L;
            @Nullable
            private ItemId targetMatcher;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EventMatchers.IsValidTargetEventMatcher instance) {
                Objects.requireNonNull(instance, "instance");
                this.targetMatcher(instance.getTargetMatcher());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder targetMatcher(ItemId targetMatcher) {
                this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public IsValidTargetEventMatcher build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new IsValidTargetEventMatcher(null, this.targetMatcher);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("targetMatcher");
                }
                return "Cannot build IsValidTargetEventMatcher, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EventMatchers.IsDisabledTargetEventMatcher", generator="Immutables")
    @Immutable
    static final class IsDisabledTargetEventMatcher
    implements EventMatchers.IsDisabledTargetEventMatcher {
        private final ItemId targetMatcher;

        private IsDisabledTargetEventMatcher(ItemId targetMatcher) {
            this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
        }

        private IsDisabledTargetEventMatcher(IsDisabledTargetEventMatcher original, ItemId targetMatcher) {
            this.targetMatcher = targetMatcher;
        }

        @Override
        public ItemId getTargetMatcher() {
            return this.targetMatcher;
        }

        public final IsDisabledTargetEventMatcher withTargetMatcher(ItemId value) {
            if (this.targetMatcher == value) {
                return this;
            }
            ItemId newValue = Objects.requireNonNull(value, "targetMatcher");
            return new IsDisabledTargetEventMatcher(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IsDisabledTargetEventMatcher && this.equalsByValue((IsDisabledTargetEventMatcher)another);
        }

        private boolean equalsByValue(IsDisabledTargetEventMatcher another) {
            return this.targetMatcher.equals(another.targetMatcher);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.targetMatcher.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"IsDisabledTargetEventMatcher").omitNullValues().add("targetMatcher", (Object)this.targetMatcher).toString();
        }

        public static IsDisabledTargetEventMatcher of(ItemId targetMatcher) {
            return new IsDisabledTargetEventMatcher(targetMatcher);
        }

        public static IsDisabledTargetEventMatcher copyOf(EventMatchers.IsDisabledTargetEventMatcher instance) {
            if (instance instanceof IsDisabledTargetEventMatcher) {
                return (IsDisabledTargetEventMatcher)instance;
            }
            return IsDisabledTargetEventMatcher.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EventMatchers.IsDisabledTargetEventMatcher", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_TARGET_MATCHER = 1L;
            private long initBits = 1L;
            @Nullable
            private ItemId targetMatcher;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EventMatchers.IsDisabledTargetEventMatcher instance) {
                Objects.requireNonNull(instance, "instance");
                this.targetMatcher(instance.getTargetMatcher());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder targetMatcher(ItemId targetMatcher) {
                this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public IsDisabledTargetEventMatcher build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new IsDisabledTargetEventMatcher(null, this.targetMatcher);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("targetMatcher");
                }
                return "Cannot build IsDisabledTargetEventMatcher, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EventMatchers.IsRequiredTargetEventMatcher", generator="Immutables")
    @Immutable
    static final class IsRequiredTargetEventMatcher
    implements EventMatchers.IsRequiredTargetEventMatcher {
        private final ItemId targetMatcher;

        private IsRequiredTargetEventMatcher(ItemId targetMatcher) {
            this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
        }

        private IsRequiredTargetEventMatcher(IsRequiredTargetEventMatcher original, ItemId targetMatcher) {
            this.targetMatcher = targetMatcher;
        }

        @Override
        public ItemId getTargetMatcher() {
            return this.targetMatcher;
        }

        public final IsRequiredTargetEventMatcher withTargetMatcher(ItemId value) {
            if (this.targetMatcher == value) {
                return this;
            }
            ItemId newValue = Objects.requireNonNull(value, "targetMatcher");
            return new IsRequiredTargetEventMatcher(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IsRequiredTargetEventMatcher && this.equalsByValue((IsRequiredTargetEventMatcher)another);
        }

        private boolean equalsByValue(IsRequiredTargetEventMatcher another) {
            return this.targetMatcher.equals(another.targetMatcher);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.targetMatcher.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"IsRequiredTargetEventMatcher").omitNullValues().add("targetMatcher", (Object)this.targetMatcher).toString();
        }

        public static IsRequiredTargetEventMatcher of(ItemId targetMatcher) {
            return new IsRequiredTargetEventMatcher(targetMatcher);
        }

        public static IsRequiredTargetEventMatcher copyOf(EventMatchers.IsRequiredTargetEventMatcher instance) {
            if (instance instanceof IsRequiredTargetEventMatcher) {
                return (IsRequiredTargetEventMatcher)instance;
            }
            return IsRequiredTargetEventMatcher.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EventMatchers.IsRequiredTargetEventMatcher", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_TARGET_MATCHER = 1L;
            private long initBits = 1L;
            @Nullable
            private ItemId targetMatcher;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EventMatchers.IsRequiredTargetEventMatcher instance) {
                Objects.requireNonNull(instance, "instance");
                this.targetMatcher(instance.getTargetMatcher());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder targetMatcher(ItemId targetMatcher) {
                this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public IsRequiredTargetEventMatcher build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new IsRequiredTargetEventMatcher(null, this.targetMatcher);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("targetMatcher");
                }
                return "Cannot build IsRequiredTargetEventMatcher, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EventMatchers.IsActiveTargetEventMatcher", generator="Immutables")
    @Immutable
    static final class IsActiveTargetEventMatcher
    implements EventMatchers.IsActiveTargetEventMatcher {
        private final ItemId targetMatcher;

        private IsActiveTargetEventMatcher(ItemId targetMatcher) {
            this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
        }

        private IsActiveTargetEventMatcher(IsActiveTargetEventMatcher original, ItemId targetMatcher) {
            this.targetMatcher = targetMatcher;
        }

        @Override
        public ItemId getTargetMatcher() {
            return this.targetMatcher;
        }

        public final IsActiveTargetEventMatcher withTargetMatcher(ItemId value) {
            if (this.targetMatcher == value) {
                return this;
            }
            ItemId newValue = Objects.requireNonNull(value, "targetMatcher");
            return new IsActiveTargetEventMatcher(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IsActiveTargetEventMatcher && this.equalsByValue((IsActiveTargetEventMatcher)another);
        }

        private boolean equalsByValue(IsActiveTargetEventMatcher another) {
            return this.targetMatcher.equals(another.targetMatcher);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.targetMatcher.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"IsActiveTargetEventMatcher").omitNullValues().add("targetMatcher", (Object)this.targetMatcher).toString();
        }

        public static IsActiveTargetEventMatcher of(ItemId targetMatcher) {
            return new IsActiveTargetEventMatcher(targetMatcher);
        }

        public static IsActiveTargetEventMatcher copyOf(EventMatchers.IsActiveTargetEventMatcher instance) {
            if (instance instanceof IsActiveTargetEventMatcher) {
                return (IsActiveTargetEventMatcher)instance;
            }
            return IsActiveTargetEventMatcher.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EventMatchers.IsActiveTargetEventMatcher", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_TARGET_MATCHER = 1L;
            private long initBits = 1L;
            @Nullable
            private ItemId targetMatcher;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EventMatchers.IsActiveTargetEventMatcher instance) {
                Objects.requireNonNull(instance, "instance");
                this.targetMatcher(instance.getTargetMatcher());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder targetMatcher(ItemId targetMatcher) {
                this.targetMatcher = Objects.requireNonNull(targetMatcher, "targetMatcher");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public IsActiveTargetEventMatcher build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new IsActiveTargetEventMatcher(null, this.targetMatcher);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("targetMatcher");
                }
                return "Cannot build IsActiveTargetEventMatcher, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EventMatchers.TargetIdEventMatcher", generator="Immutables")
    @Immutable
    public static final class TargetIdEventMatcher
    implements EventMatchers.TargetIdEventMatcher {
        private final ItemId targetId;

        private TargetIdEventMatcher(ItemId targetId) {
            this.targetId = Objects.requireNonNull(targetId, "targetId");
        }

        private TargetIdEventMatcher(TargetIdEventMatcher original, ItemId targetId) {
            this.targetId = targetId;
        }

        @Override
        public ItemId getTargetId() {
            return this.targetId;
        }

        public final TargetIdEventMatcher withTargetId(ItemId value) {
            if (this.targetId == value) {
                return this;
            }
            ItemId newValue = Objects.requireNonNull(value, "targetId");
            return new TargetIdEventMatcher(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof TargetIdEventMatcher && this.equalsByValue((TargetIdEventMatcher)another);
        }

        private boolean equalsByValue(TargetIdEventMatcher another) {
            return this.targetId.equals(another.targetId);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.targetId.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"TargetIdEventMatcher").omitNullValues().add("targetId", (Object)this.targetId).toString();
        }

        public static TargetIdEventMatcher of(ItemId targetId) {
            return new TargetIdEventMatcher(targetId);
        }

        public static TargetIdEventMatcher copyOf(EventMatchers.TargetIdEventMatcher instance) {
            if (instance instanceof TargetIdEventMatcher) {
                return (TargetIdEventMatcher)instance;
            }
            return TargetIdEventMatcher.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="EventMatchers.TargetIdEventMatcher", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_TARGET_ID = 1L;
            private long initBits = 1L;
            @Nullable
            private ItemId targetId;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(EventMatchers.TargetIdEventMatcher instance) {
                Objects.requireNonNull(instance, "instance");
                this.targetId(instance.getTargetId());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder targetId(ItemId targetId) {
                this.targetId = Objects.requireNonNull(targetId, "targetId");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public TargetIdEventMatcher build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new TargetIdEventMatcher(null, this.targetId);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("targetId");
                }
                return "Cannot build TargetIdEventMatcher, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }
}

