/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.AbstractUpdateCommand;
import io.dialob.session.engine.session.command.EventMatcher;
import io.dialob.session.engine.session.command.EventMatchers;
import io.dialob.session.engine.session.command.ItemUpdateCommand;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.HashSet;
import java.util.Set;
import org.immutables.value.Value;

public interface AbstractUpdateAttributeCommand<T>
extends AbstractUpdateCommand<ItemId, ItemState>,
ItemUpdateCommand {
    @Value.Parameter(order=1)
    public Expression getExpression();

    @Override
    @NonNull
    default public Set<EventMatcher> getEventMatchers() {
        Set<EventMatcher> eventMatchers = this.getExpression().getEvalRequiredConditions();
        if (this.getTargetId().isPartial()) {
            HashSet<EventMatcher> set = new HashSet<EventMatcher>(eventMatchers);
            set.add(EventMatchers.whenItemAdded(this.getTargetId()));
            return Set.copyOf(set);
        }
        return eventMatchers;
    }

    default public T evalExpression(EvalContext context) {
        return (T)this.getExpression().eval(context);
    }
}

