/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session.command;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.session.command.AbstractUpdateCommand;
import io.dialob.session.engine.session.command.ItemUpdateCommand;
import io.dialob.session.engine.session.model.DialobSession;
import io.dialob.session.engine.session.model.ErrorState;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import org.immutables.value.Value;

interface AbstractPageCommand
extends AbstractUpdateCommand<ItemId, ItemState>,
ItemUpdateCommand {
    @Override
    @NonNull
    @Value.Default
    default public ItemId getTargetId() {
        return DialobSession.QUESTIONNAIRE_REF;
    }

    default public boolean pageIsInactive(EvalContext context, ItemId page) {
        if (page == null) {
            return true;
        }
        return context.getItemState(page).map(ItemState::isActive).orElse(false) == false;
    }

    default public boolean anyErrors(EvalContext context) {
        return context.getErrorStates().stream().anyMatch(ErrorState::isActive);
    }

    default public ItemState gotoPage(EvalContext context, ItemState itemState, ItemId page) {
        if (page != null) {
            return itemState.update().setActivePage(page).get();
        }
        return itemState;
    }
}

