/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.session.engine.DebugUtil;
import io.dialob.session.engine.program.DialobProgram;
import io.dialob.session.engine.program.DialobSessionEvalContext;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.session.DialobSessionUpdater;
import io.dialob.session.engine.session.command.Command;
import io.dialob.session.engine.session.command.event.Event;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveDialobSessionUpdater
implements DialobSessionUpdater {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveDialobSessionUpdater.class);
    private final ContextProvider contextProvider;
    private final DialobProgram dialobProgram;
    private final Set<Command<?>> updatedCommands = new HashSet();
    protected final List<Command<?>> evalQueue = new LinkedList();

    public ActiveDialobSessionUpdater(@NonNull ContextProvider contextProvider, @NonNull DialobProgram dialobProgram) {
        this.contextProvider = Objects.requireNonNull(contextProvider, "contextProvider may not be null");
        this.dialobProgram = Objects.requireNonNull(dialobProgram, "dialobProgram may not be null");
    }

    @Override
    public Consumer<EvalContext.UpdatedItemsVisitor> applyCommands(@NonNull Iterable<Command<?>> commands) {
        DialobSessionEvalContext evalContext = this.createEvalContext();
        commands.forEach(this::queueCommand);
        while (!this.evalQueue.isEmpty()) {
            Command<?> command = this.evalQueue.removeFirst();
            this.updatedCommands.add(command);
            evalContext.applyCommand(command);
        }
        this.updatedCommands.clear();
        LOGGER.debug("Update completed.");
        return evalContext::accept;
    }

    protected DialobSessionEvalContext createEvalContext() {
        return this.contextProvider.createDialobSessionEvalContext(this::queueUpdate);
    }

    private void queueUpdate(@NonNull Event event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(" -> event({})", (Object)event);
        }
        this.dialobProgram.findDependencies(event).forEach(this::queueCommand);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  = {}", (Object)StringUtils.join((Object[])this.evalQueue.stream().map(DebugUtil::commandToString).toArray(), (String)" ,"));
        }
    }

    protected void queueCommand(@NonNull Command<?> updateCommand) {
        Set<Command<?>> mustBeBefore = this.dialobProgram.getCommandsToCommands(updateCommand);
        if (mustBeBefore.isEmpty()) {
            this.evalQueue.add(updateCommand);
            return;
        }
        ListIterator<Command<?>> iterator = this.evalQueue.listIterator();
        while (iterator.hasNext()) {
            Command<?> command = iterator.next();
            if (updateCommand.equals(command)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("  - skip {} (on queue already)", (Object)DebugUtil.commandToString(updateCommand));
                }
                return;
            }
            if (!mustBeBefore.contains(command)) continue;
            iterator.previous();
            break;
        }
        iterator.add(updateCommand);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  + queued {}", (Object)DebugUtil.commandToString(updateCommand));
            if (this.updatedCommands.contains(updateCommand)) {
                LOGGER.debug("Target {} already executed. Cyclic dependency?", (Object)DebugUtil.commandToString(updateCommand));
            }
        }
    }

    public static interface ContextProvider {
        public DialobSessionEvalContext createDialobSessionEvalContext(@NonNull Consumer<Event> var1);
    }
}

