/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.session;

import io.dialob.api.proto.Action;
import io.dialob.session.engine.session.command.Command;
import io.dialob.session.engine.session.command.CommandFactory;
import io.dialob.session.engine.session.command.ItemUpdateCommand;
import io.dialob.session.engine.session.model.IdUtils;
import io.dialob.session.engine.session.model.ItemId;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActionToCommandMapper
implements Function<Action, Command<?>> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionToCommandMapper.class);
    public static final ActionToCommandMapper INSTANCE = new ActionToCommandMapper();

    private ActionToCommandMapper() {
    }

    public static List<Command<?>> toCommands(Iterable<Action> actions) {
        return StreamSupport.stream(actions.spliterator(), false).map(INSTANCE).filter(Objects::nonNull).toList();
    }

    @Override
    public Command<?> apply(Action action) {
        ItemUpdateCommand ret;
        ItemId itemId = IdUtils.toIdNullable(action.getId());
        switch (action.getType()) {
            default: {
                throw new MatchException(null, null);
            }
            case ANSWER: {
                ItemUpdateCommand itemUpdateCommand = CommandFactory.setAnswer(Objects.requireNonNull(itemId), action.getAnswer());
                break;
            }
            case SET_VALUE: {
                ItemUpdateCommand itemUpdateCommand = CommandFactory.setVariableValue(Objects.requireNonNull(itemId), action.getValue());
                break;
            }
            case SET_FAILED: {
                ItemUpdateCommand itemUpdateCommand = CommandFactory.setVariableFailed(Objects.requireNonNull(itemId));
                break;
            }
            case NEXT: {
                ItemUpdateCommand itemUpdateCommand = CommandFactory.nextPage();
                break;
            }
            case PREVIOUS: {
                ItemUpdateCommand itemUpdateCommand = CommandFactory.prevPage();
                break;
            }
            case GOTO: {
                ItemUpdateCommand itemUpdateCommand = CommandFactory.gotoPage(Objects.requireNonNull(itemId));
                break;
            }
            case COMPLETE: {
                ItemUpdateCommand itemUpdateCommand = CommandFactory.complete();
                break;
            }
            case ADD_ROW: {
                ItemUpdateCommand itemUpdateCommand = CommandFactory.addRow(Objects.requireNonNull(itemId));
                break;
            }
            case DELETE_ROW: {
                ItemUpdateCommand itemUpdateCommand = CommandFactory.deleteRow(Objects.requireNonNull(itemId));
                break;
            }
            case SET_LOCALE: {
                ItemUpdateCommand itemUpdateCommand;
                if (action.getValue() instanceof String) {
                    itemUpdateCommand = CommandFactory.setLocale((String)action.getValue());
                    break;
                }
                itemUpdateCommand = null;
                break;
            }
            case REMOVE_ANSWERS: 
            case RESET: 
            case ITEM: 
            case REMOVE_ITEMS: 
            case ERROR: 
            case REMOVE_ERROR: 
            case VALUE_SET: 
            case REMOVE_VALUE_SETS: 
            case NOT_FOUND: 
            case SERVER_ERROR: 
            case ROWS: 
            case LOCALE: {
                ItemUpdateCommand itemUpdateCommand = ret = null;
            }
        }
        if (ret == null) {
            LOGGER.debug("Action \"{}\" ignored.", (Object)action);
        }
        return ret;
    }
}

