/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.rule.parser.api.ObjectValueType;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public record ObjectOperator(Collection<Expression> fields) implements Expression
{
    @Override
    @NonNull
    public ValueType getValueType() {
        return ObjectValueType.objectOf(Collections.emptyMap());
    }

    @Override
    public Object eval(@NonNull EvalContext evalContext) {
        HashMap map = new HashMap();
        for (Expression entry : this.fields) {
            Object result = entry.eval(evalContext);
            if (!(result instanceof Map)) continue;
            Map resultMap = (Map)result;
            map.putAll(resultMap);
        }
        return map;
    }

    @Override
    @NonNull
    public Set<EventMatcher> getEvalRequiredConditions() {
        return this.fields.stream().map(Expression::getEvalRequiredConditions).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

