/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.expr.arith.ContextVariableReference;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ContextVariableReference", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableContextVariableReference<T>
implements ContextVariableReference<T> {
    private final ValueType valueType;
    private final ItemId itemId;

    private ImmutableContextVariableReference(ItemId itemId, ValueType valueType) {
        this.itemId = Objects.requireNonNull(itemId, "itemId");
        this.valueType = Objects.requireNonNull(valueType, "valueType");
    }

    private ImmutableContextVariableReference(ImmutableContextVariableReference<T> original, ValueType valueType, ItemId itemId) {
        this.valueType = valueType;
        this.itemId = itemId;
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public ItemId getItemId() {
        return this.itemId;
    }

    public final ImmutableContextVariableReference<T> withValueType(ValueType value) {
        if (this.valueType == value) {
            return this;
        }
        ValueType newValue = Objects.requireNonNull(value, "valueType");
        return new ImmutableContextVariableReference<T>(this, newValue, this.itemId);
    }

    public final ImmutableContextVariableReference<T> withItemId(ItemId value) {
        if (this.itemId == value) {
            return this;
        }
        ItemId newValue = Objects.requireNonNull(value, "itemId");
        return new ImmutableContextVariableReference<T>(this, this.valueType, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContextVariableReference && this.equalsByValue((ImmutableContextVariableReference)another);
    }

    private boolean equalsByValue(ImmutableContextVariableReference<?> another) {
        return this.valueType.equals((Object)another.valueType) && this.itemId.equals(another.itemId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.valueType.hashCode();
        h += (h << 5) + this.itemId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ContextVariableReference").omitNullValues().add("valueType", (Object)this.valueType).add("itemId", (Object)this.itemId).toString();
    }

    public static <T> ImmutableContextVariableReference<T> of(ItemId itemId, ValueType valueType) {
        return new ImmutableContextVariableReference<T>(itemId, valueType);
    }

    public static <T> ImmutableContextVariableReference<T> copyOf(ContextVariableReference<T> instance) {
        if (instance instanceof ImmutableContextVariableReference) {
            return (ImmutableContextVariableReference)instance;
        }
        return ImmutableContextVariableReference.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="ContextVariableReference", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T> {
        private static final long INIT_BIT_VALUE_TYPE = 1L;
        private static final long INIT_BIT_ITEM_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private ValueType valueType;
        @Nullable
        private ItemId itemId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(ContextVariableReference<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(Expression instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            Expression instance;
            long bits = 0L;
            if (object instanceof ContextVariableReference) {
                instance = (ContextVariableReference)object;
                this.itemId(instance.getItemId());
                if ((bits & 1L) == 0L) {
                    this.valueType(instance.getValueType());
                    bits |= 1L;
                }
            }
            if (object instanceof Expression) {
                instance = (Expression)object;
                if ((bits & 1L) == 0L) {
                    this.valueType(instance.getValueType());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder<T> valueType(ValueType valueType) {
            this.valueType = Objects.requireNonNull(valueType, "valueType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> itemId(ItemId itemId) {
            this.itemId = Objects.requireNonNull(itemId, "itemId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableContextVariableReference<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContextVariableReference(null, this.valueType, this.itemId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("valueType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("itemId");
            }
            return "Cannot build ContextVariableReference, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

