/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.expr.arith.Constant;
import io.dialob.session.engine.program.expr.arith.ImmutableConstant;
import io.dialob.session.engine.program.expr.arith.ImmutableEqOperator;
import io.dialob.session.engine.program.expr.arith.ImmutableNeOperator;
import io.dialob.session.engine.program.expr.arith.InfixOperator;
import io.dialob.session.engine.program.expr.arith.Operators;
import io.dialob.session.engine.program.model.Expression;

public class BooleanOperators
implements Operators {
    public static final Constant<Boolean> FALSE = ImmutableConstant.builder().valueType(ValueType.BOOLEAN).value(Boolean.FALSE).build();
    public static final Constant<Boolean> TRUE = ImmutableConstant.builder().valueType(ValueType.BOOLEAN).value(Boolean.TRUE).build();

    @Override
    public InfixOperator eq(Expression lhs, Expression rhs) {
        return ImmutableEqOperator.builder().lhs(lhs).rhs(rhs).build();
    }

    @Override
    public InfixOperator ne(Expression lhs, Expression rhs) {
        return ImmutableNeOperator.builder().lhs(lhs).rhs(rhs).build();
    }

    @Override
    public InfixOperator le(Expression lhs, Expression rhs) {
        return BooleanOperators.noRelationError();
    }

    @Override
    public InfixOperator lt(Expression lhs, Expression rhs) {
        return BooleanOperators.noRelationError();
    }

    @Override
    public InfixOperator ge(Expression lhs, Expression rhs) {
        return BooleanOperators.noRelationError();
    }

    @Override
    public InfixOperator gt(Expression lhs, Expression rhs) {
        return BooleanOperators.noRelationError();
    }

    private static InfixOperator noRelationError() {
        throw new RuntimeException("No relation operator between boolean types");
    }
}

