/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program.expr.arith;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.immutables.value.Value;

@Value.Immutable
public interface ArrayReducerOperator<T>
extends Expression {
    public static final BinaryOperator<Object> ANSWER_COUNT = (result, element) -> {
        if (element != null) {
            return result == null ? Integer.valueOf(1) : ((BigInteger)result).add(BigInteger.ONE);
        }
        return result;
    };
    public static final BinaryOperator<BigInteger> INTEGER_SUM = (result, element) -> {
        if (element != null) {
            return result == null ? element : result.add((BigInteger)element);
        }
        return result;
    };
    public static final BinaryOperator<BigDecimal> DECIMAL_SUM = (result, element) -> {
        if (element != null) {
            return result == null ? element : result.add((BigDecimal)element);
        }
        return result;
    };
    public static final BinaryOperator<BigInteger> INTEGER_MIN = (result, element) -> {
        if (element != null) {
            return result == null ? element : result.min((BigInteger)element);
        }
        return result;
    };
    public static final BinaryOperator<BigDecimal> DECIMAL_MIN = (result, element) -> {
        if (element != null) {
            return result == null ? element : result.min((BigDecimal)element);
        }
        return result;
    };
    public static final BinaryOperator<BigInteger> INTEGER_MAX = (result, element) -> {
        if (element != null) {
            return result == null ? element : result.max((BigInteger)element);
        }
        return result;
    };
    public static final BinaryOperator<BigDecimal> DECIMAL_MAX = (result, element) -> {
        if (element != null) {
            return result == null ? element : result.max((BigDecimal)element);
        }
        return result;
    };
    public static final BinaryOperator<Boolean> ANY = (result, element) -> {
        if (element != null) {
            return result == null ? element : result != false || element != false;
        }
        return result;
    };
    public static final BinaryOperator<Boolean> ALL = (result, element) -> {
        if (element != null) {
            return result == null ? element : result != false && element != false;
        }
        return result;
    };

    @Value.Parameter
    public BinaryOperator<T> getReducer();

    @Value.Parameter
    public Expression getArrayExpression();

    @Value.Default
    @Nullable
    default public Object getPlaceholderValue() {
        return null;
    }

    @Override
    @Nullable
    default public Object eval(@NonNull EvalContext evalContext) {
        List values = (List)this.getArrayExpression().eval(evalContext);
        if (values == null) {
            return null;
        }
        return values.stream().filter(Objects::nonNull).reduce(this.getReducer()).orElse(this.getPlaceholderValue());
    }

    @Override
    @NonNull
    default public ValueType getValueType() {
        return this.getArrayExpression().getValueType().getItemValueType();
    }

    @Override
    @NonNull
    default public Set<EventMatcher> getEvalRequiredConditions() {
        return this.getArrayExpression().getEvalRequiredConditions();
    }

    public static BinaryOperator<? extends Number> sumOp(ValueType valueType) {
        if (valueType == ValueType.INTEGER) {
            return INTEGER_SUM;
        }
        if (valueType == ValueType.DECIMAL) {
            return DECIMAL_SUM;
        }
        return null;
    }

    public static BinaryOperator<? extends Number> minOp(ValueType valueType) {
        if (valueType == ValueType.INTEGER) {
            return INTEGER_MIN;
        }
        if (valueType == ValueType.DECIMAL) {
            return DECIMAL_MIN;
        }
        return null;
    }

    public static BinaryOperator<? extends Number> maxOp(ValueType valueType) {
        if (valueType == ValueType.INTEGER) {
            return INTEGER_MAX;
        }
        if (valueType == ValueType.DECIMAL) {
            return DECIMAL_MAX;
        }
        return null;
    }

    public static BinaryOperator<Boolean> allOp(ValueType valueType) {
        if (valueType == ValueType.BOOLEAN) {
            return ALL;
        }
        return null;
    }

    public static BinaryOperator<Boolean> anyOp(ValueType valueType) {
        if (valueType == ValueType.BOOLEAN) {
            return ANY;
        }
        return null;
    }
}

