/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine.program;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.dialob.rule.parser.function.FunctionRegistry;
import io.dialob.session.engine.DialobSessionUpdateHook;
import io.dialob.session.engine.program.DialobProgram;
import io.dialob.session.engine.program.DialobSessionEvalContext;
import io.dialob.session.engine.session.ActiveDialobSessionUpdater;
import io.dialob.session.engine.session.DialobSessionUpdater;
import io.dialob.session.engine.session.model.DialobSession;

public class DialobSessionEvalContextFactory {
    @NonNull
    private final FunctionRegistry functionRegistry;
    @Nullable
    private final DialobSessionUpdateHook dialobSessionUpdateHook;

    public DialobSessionEvalContextFactory(@NonNull FunctionRegistry functionRegistry, @Nullable DialobSessionUpdateHook dialobSessionUpdateHook) {
        this.functionRegistry = functionRegistry;
        this.dialobSessionUpdateHook = dialobSessionUpdateHook;
    }

    @NonNull
    public DialobSessionUpdater createSessionUpdater(@NonNull DialobProgram dialobProgram, @NonNull DialobSession dialobSession, boolean activating) {
        if (dialobSession.isCompleted()) {
            return DialobSessionUpdater.NOOP_UPDATER;
        }
        return new ActiveDialobSessionUpdater(updatesConsumer -> new DialobSessionEvalContext(this.functionRegistry, dialobSession, updatesConsumer, activating, this.dialobSessionUpdateHook), dialobProgram);
    }
}

