/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.engine;

import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.api.form.Form;
import io.dialob.api.form.FormItem;
import io.dialob.api.form.FormValidationError;
import io.dialob.api.form.FormValueSetEntry;
import io.dialob.api.form.Validation;
import io.dialob.form.service.api.repository.FormItemVisitor;
import io.dialob.form.service.api.repository.FormValueSetVisitor;
import io.dialob.form.service.api.repository.FormVariableVisitor;
import io.dialob.form.service.api.repository.FormVisitor;
import io.dialob.form.service.api.repository.VisitableForm;
import io.dialob.rule.parser.function.FunctionRegistry;
import io.dialob.session.engine.DialobProgramErrorsException;
import io.dialob.session.engine.program.DialobProgram;
import io.dialob.session.engine.program.GroupBuilder;
import io.dialob.session.engine.program.ProgramBuilder;
import io.dialob.session.engine.program.QuestionBuilder;
import io.dialob.session.engine.program.ValidationBuilder;
import io.dialob.session.engine.program.ValueSetBuilder;
import io.dialob.session.engine.program.ValueSetEntryBuilder;
import io.dialob.session.engine.program.model.Program;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialobProgramFromFormCompiler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobProgramFromFormCompiler.class);
    private final FunctionRegistry functionRegistry;

    public DialobProgramFromFormCompiler(FunctionRegistry functionRegistry) {
        this.functionRegistry = functionRegistry;
    }

    public DialobProgram compileForm(@NonNull Form formDocument) {
        List<FormValidationError> builderErrors;
        final ProgramBuilder builder = new ProgramBuilder(this.functionRegistry);
        VisitableForm.makeVisitableForm((Form)formDocument).accept(new FormVisitor(){
            private boolean answersRequiredByDefault = false;
            Set<String> languages;
            private String formLabel;

            public void start() {
                builder.startProgram();
            }

            public void visitForm(@NonNull Form formDocument) {
                String string;
                builder.setId(formDocument.getId());
                this.formLabel = formDocument.getMetadata().getLabel();
                this.languages = formDocument.getMetadata().getLanguages();
                Object allRequiredByDefault = formDocument.getMetadata().getAdditionalProperties().get("answersRequiredByDefault");
                if (Boolean.TRUE.equals(allRequiredByDefault) || allRequiredByDefault instanceof String && BooleanUtils.toBoolean((String)(string = (String)allRequiredByDefault))) {
                    this.answersRequiredByDefault = true;
                }
                if (this.languages.isEmpty()) {
                    this.languages = Set.of("en");
                }
            }

            public Optional<FormItemVisitor> startFormItems() {
                return Optional.of(new FormItemVisitor(){

                    public void visitQuestionnaireItem(@NonNull FormItem formItem) {
                        ((GroupBuilder)((GroupBuilder)((GroupBuilder)builder.addRoot().setView(formItem.getView()).setLabel(Maps.asMap(languages, input -> formLabel))).addItems(formItem.getItems()).addClassnames(formItem.getClassName())).setProps(formItem.getProps())).build();
                    }

                    public void visitGroup(@NonNull FormItem formItem) {
                        ((GroupBuilder)((GroupBuilder)((GroupBuilder)((GroupBuilder)((GroupBuilder)builder.addGroup(formItem.getId()).setView(formItem.getView()).setLabel(formItem.getLabel())).setDescription(formItem.getDescription())).setActiveWhen(formItem.getActiveWhen())).addItems(formItem.getItems()).addClassnames(formItem.getClassName())).setProps(formItem.getProps())).build();
                    }

                    public void visitSurveyGroup(@NonNull FormItem formItem) {
                        ((GroupBuilder)((GroupBuilder)((GroupBuilder)((GroupBuilder)((GroupBuilder)builder.addSurveyGroup(formItem.getId()).setView(formItem.getView()).setLabel(formItem.getLabel())).setDescription(formItem.getDescription())).setActiveWhen(formItem.getActiveWhen())).addItems(formItem.getItems()).addClassnames(formItem.getClassName())).setValueSet(formItem.getValueSetId()).setProps(formItem.getProps())).build();
                    }

                    public void visitRowGroup(@NonNull FormItem formItem) {
                        ((GroupBuilder)((GroupBuilder)((GroupBuilder)((GroupBuilder)((GroupBuilder)builder.addRowGroup(formItem.getId()).setView(formItem.getView()).setLabel(formItem.getLabel())).setDescription(formItem.getDescription())).setActiveWhen(formItem.getActiveWhen())).setCanAddRowWhen(formItem.getCanAddRowWhen()).setCanRemoveRowWhen(formItem.getCanRemoveRowWhen()).addItems(formItem.getItems()).addClassnames(formItem.getClassName())).setValueSet(formItem.getValueSetId()).setProps(formItem.getProps())).build();
                    }

                    public void visitPage(@NonNull FormItem formItem) {
                        ((GroupBuilder)((GroupBuilder)((GroupBuilder)((GroupBuilder)((GroupBuilder)builder.addPage(formItem.getId()).setView(formItem.getView()).setLabel(formItem.getLabel())).setDescription(formItem.getDescription())).setActiveWhen(formItem.getActiveWhen())).addItems(formItem.getItems()).addClassnames(formItem.getClassName())).setProps(formItem.getProps())).build();
                    }

                    public void visitQuestion(@NonNull FormItem formItem) {
                        QuestionBuilder questionBuilder = (QuestionBuilder)((QuestionBuilder)((QuestionBuilder)((QuestionBuilder)((QuestionBuilder)builder.addQuestion(formItem.getId()).setLabel(formItem.getLabel())).setDescription(formItem.getDescription())).setActiveWhen(formItem.getActiveWhen())).setType(formItem.getType()).setView(formItem.getView()).setDefaultValue(formItem.getDefaultValue()).setValueSet(formItem.getValueSetId()).setProps(formItem.getProps())).addClassnames(formItem.getClassName());
                        if (StringUtils.isNotBlank((CharSequence)formItem.getRequired())) {
                            questionBuilder.setRequiredWhen(formItem.getRequired());
                        } else if (answersRequiredByDefault && !"note".equals(formItem.getType())) {
                            questionBuilder.setRequired(true);
                        }
                        int i = 1;
                        if (!"note".equals(formItem.getType())) {
                            for (Validation validationBean : formItem.getValidations()) {
                                ((ValidationBuilder)questionBuilder.addValidation(formItem.getId() + "_error" + i++).setActiveWhen(validationBean.getRule()).setLabel(validationBean.getMessage())).build();
                            }
                        }
                        questionBuilder.build();
                    }

                    public void visitNote(@NonNull FormItem formItem) {
                        this.visitQuestion(formItem);
                    }
                });
            }

            @NonNull
            public Optional<FormValueSetVisitor> startValueSets() {
                return Optional.of(valueSet -> {
                    ValueSetBuilder valueSetBuilder = builder.addValueSet(valueSet.getId());
                    for (FormValueSetEntry entry : valueSet.getEntries()) {
                        ((ValueSetEntryBuilder)((ValueSetEntryBuilder)valueSetBuilder.addValue(entry.getId()).setActiveWhen(entry.getWhen())).setLabel(entry.getLabel())).build();
                    }
                    valueSetBuilder.build();
                });
            }

            @NonNull
            public Optional<FormVariableVisitor> startFormVariables() {
                return Optional.of(formVariable -> builder.addVariable(formVariable.getName()).setContext(formVariable.getContext()).setPublished(formVariable.getPublished()).setValueExpression(formVariable.getExpression()).setDefaultValue(formVariable.getDefaultValue()).setType(formVariable.getContextType()).build());
            }
        });
        Program program = builder.build();
        if (program != null && LOGGER.isDebugEnabled()) {
            LOGGER.debug(program.toString());
        }
        if (!(builderErrors = builder.getErrors()).isEmpty() || program == null) {
            throw new DialobProgramErrorsException("Could not compile program due errors.", builderErrors);
        }
        return DialobProgram.createDialobProgram(program);
    }
}

