package io.dialob.session.engine.session.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Scope}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableScope.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableScope.of()}.
 */
@Generated(from = "Scope", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableScope implements Scope {
  private final ItemId scopeId;
  private final ImmutableSet<ItemId> scopeItems;

  private ImmutableScope(
      ItemId scopeId,
      Iterable<? extends ItemId> scopeItems) {
    this.scopeId = Objects.requireNonNull(scopeId, "scopeId");
    this.scopeItems = ImmutableSet.copyOf(scopeItems);
  }

  private ImmutableScope(
      ImmutableScope original,
      ItemId scopeId,
      ImmutableSet<ItemId> scopeItems) {
    this.scopeId = scopeId;
    this.scopeItems = scopeItems;
  }

  /**
   * @return The value of the {@code scopeId} attribute
   */
  @Override
  public ItemId getScopeId() {
    return scopeId;
  }

  /**
   * @return The value of the {@code scopeItems} attribute
   */
  @Override
  public ImmutableSet<ItemId> getScopeItems() {
    return scopeItems;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Scope#getScopeId() scopeId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for scopeId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableScope withScopeId(ItemId value) {
    if (this.scopeId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "scopeId");
    return new ImmutableScope(this, newValue, this.scopeItems);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Scope#getScopeItems() scopeItems}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableScope withScopeItems(ItemId... elements) {
    ImmutableSet<ItemId> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableScope(this, this.scopeId, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Scope#getScopeItems() scopeItems}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of scopeItems elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableScope withScopeItems(Iterable<? extends ItemId> elements) {
    if (this.scopeItems == elements) return this;
    ImmutableSet<ItemId> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableScope(this, this.scopeId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableScope} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableScope
        && equalTo((ImmutableScope) another);
  }

  private boolean equalTo(ImmutableScope another) {
    return scopeId.equals(another.scopeId)
        && scopeItems.equals(another.scopeItems);
  }

  /**
   * Computes a hash code from attributes: {@code scopeId}, {@code scopeItems}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + scopeId.hashCode();
    h += (h << 5) + scopeItems.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Scope} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Scope")
        .omitNullValues()
        .add("scopeId", scopeId)
        .add("scopeItems", scopeItems)
        .toString();
  }

  /**
   * Construct a new immutable {@code Scope} instance.
   * @param scopeId The value for the {@code scopeId} attribute
   * @param scopeItems The value for the {@code scopeItems} attribute
   * @return An immutable Scope instance
   */
  public static ImmutableScope of(ItemId scopeId, Set<ItemId> scopeItems) {
    return of(scopeId, (Iterable<? extends ItemId>) scopeItems);
  }

  /**
   * Construct a new immutable {@code Scope} instance.
   * @param scopeId The value for the {@code scopeId} attribute
   * @param scopeItems The value for the {@code scopeItems} attribute
   * @return An immutable Scope instance
   */
  public static ImmutableScope of(ItemId scopeId, Iterable<? extends ItemId> scopeItems) {
    return new ImmutableScope(scopeId, scopeItems);
  }

  /**
   * Creates an immutable copy of a {@link Scope} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Scope instance
   */
  public static ImmutableScope copyOf(Scope instance) {
    if (instance instanceof ImmutableScope) {
      return (ImmutableScope) instance;
    }
    return ImmutableScope.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableScope ImmutableScope}.
   * <pre>
   * ImmutableScope.builder()
   *    .scopeId(io.dialob.session.engine.session.model.ItemId) // required {@link Scope#getScopeId() scopeId}
   *    .addScopeItems|addAllScopeItems(io.dialob.session.engine.session.model.ItemId) // {@link Scope#getScopeItems() scopeItems} elements
   *    .build();
   * </pre>
   * @return A new ImmutableScope builder
   */
  public static ImmutableScope.Builder builder() {
    return new ImmutableScope.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableScope ImmutableScope}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Scope", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SCOPE_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ItemId scopeId;
    private ImmutableSet.Builder<ItemId> scopeItems = ImmutableSet.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Scope} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Scope instance) {
      Objects.requireNonNull(instance, "instance");
      scopeId(instance.getScopeId());
      addAllScopeItems(instance.getScopeItems());
      return this;
    }

    /**
     * Initializes the value for the {@link Scope#getScopeId() scopeId} attribute.
     * @param scopeId The value for scopeId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder scopeId(ItemId scopeId) {
      this.scopeId = Objects.requireNonNull(scopeId, "scopeId");
      initBits &= ~INIT_BIT_SCOPE_ID;
      return this;
    }

    /**
     * Adds one element to {@link Scope#getScopeItems() scopeItems} set.
     * @param element A scopeItems element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addScopeItems(ItemId element) {
      this.scopeItems.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Scope#getScopeItems() scopeItems} set.
     * @param elements An array of scopeItems elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addScopeItems(ItemId... elements) {
      this.scopeItems.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Scope#getScopeItems() scopeItems} set.
     * @param elements An iterable of scopeItems elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder scopeItems(Iterable<? extends ItemId> elements) {
      this.scopeItems = ImmutableSet.builder();
      return addAllScopeItems(elements);
    }

    /**
     * Adds elements to {@link Scope#getScopeItems() scopeItems} set.
     * @param elements An iterable of scopeItems elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllScopeItems(Iterable<? extends ItemId> elements) {
      this.scopeItems.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableScope ImmutableScope}.
     * @return An immutable instance of Scope
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableScope build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableScope(null, scopeId, scopeItems.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SCOPE_ID) != 0) attributes.add("scopeId");
      return "Cannot build Scope, some of required attributes are not set " + attributes;
    }
  }
}
