package io.dialob.session.engine.session.command.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RowItemsAddedEventsProvider}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRowItemsAddedEventsProvider.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableRowItemsAddedEventsProvider.of()}.
 */
@Generated(from = "RowItemsAddedEventsProvider", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRowItemsAddedEventsProvider
    implements RowItemsAddedEventsProvider {
  private final ItemId rowProtoTypeId;

  private ImmutableRowItemsAddedEventsProvider(ItemId rowProtoTypeId) {
    this.rowProtoTypeId = Objects.requireNonNull(rowProtoTypeId, "rowProtoTypeId");
  }

  private ImmutableRowItemsAddedEventsProvider(
      ImmutableRowItemsAddedEventsProvider original,
      ItemId rowProtoTypeId) {
    this.rowProtoTypeId = rowProtoTypeId;
  }

  /**
   * @return The value of the {@code rowProtoTypeId} attribute
   */
  @Override
  public ItemId getRowProtoTypeId() {
    return rowProtoTypeId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RowItemsAddedEventsProvider#getRowProtoTypeId() rowProtoTypeId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rowProtoTypeId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRowItemsAddedEventsProvider withRowProtoTypeId(ItemId value) {
    if (this.rowProtoTypeId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "rowProtoTypeId");
    return new ImmutableRowItemsAddedEventsProvider(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRowItemsAddedEventsProvider} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRowItemsAddedEventsProvider
        && equalTo((ImmutableRowItemsAddedEventsProvider) another);
  }

  private boolean equalTo(ImmutableRowItemsAddedEventsProvider another) {
    return rowProtoTypeId.equals(another.rowProtoTypeId);
  }

  /**
   * Computes a hash code from attributes: {@code rowProtoTypeId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + rowProtoTypeId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RowItemsAddedEventsProvider} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RowItemsAddedEventsProvider")
        .omitNullValues()
        .add("rowProtoTypeId", rowProtoTypeId)
        .toString();
  }

  /**
   * Construct a new immutable {@code RowItemsAddedEventsProvider} instance.
   * @param rowProtoTypeId The value for the {@code rowProtoTypeId} attribute
   * @return An immutable RowItemsAddedEventsProvider instance
   */
  public static ImmutableRowItemsAddedEventsProvider of(ItemId rowProtoTypeId) {
    return new ImmutableRowItemsAddedEventsProvider(rowProtoTypeId);
  }

  /**
   * Creates an immutable copy of a {@link RowItemsAddedEventsProvider} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RowItemsAddedEventsProvider instance
   */
  public static ImmutableRowItemsAddedEventsProvider copyOf(RowItemsAddedEventsProvider instance) {
    if (instance instanceof ImmutableRowItemsAddedEventsProvider) {
      return (ImmutableRowItemsAddedEventsProvider) instance;
    }
    return ImmutableRowItemsAddedEventsProvider.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRowItemsAddedEventsProvider ImmutableRowItemsAddedEventsProvider}.
   * <pre>
   * ImmutableRowItemsAddedEventsProvider.builder()
   *    .rowProtoTypeId(io.dialob.session.engine.session.model.ItemId) // required {@link RowItemsAddedEventsProvider#getRowProtoTypeId() rowProtoTypeId}
   *    .build();
   * </pre>
   * @return A new ImmutableRowItemsAddedEventsProvider builder
   */
  public static ImmutableRowItemsAddedEventsProvider.Builder builder() {
    return new ImmutableRowItemsAddedEventsProvider.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRowItemsAddedEventsProvider ImmutableRowItemsAddedEventsProvider}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RowItemsAddedEventsProvider", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ROW_PROTO_TYPE_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ItemId rowProtoTypeId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RowItemsAddedEventsProvider} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RowItemsAddedEventsProvider instance) {
      Objects.requireNonNull(instance, "instance");
      rowProtoTypeId(instance.getRowProtoTypeId());
      return this;
    }

    /**
     * Initializes the value for the {@link RowItemsAddedEventsProvider#getRowProtoTypeId() rowProtoTypeId} attribute.
     * @param rowProtoTypeId The value for rowProtoTypeId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder rowProtoTypeId(ItemId rowProtoTypeId) {
      this.rowProtoTypeId = Objects.requireNonNull(rowProtoTypeId, "rowProtoTypeId");
      initBits &= ~INIT_BIT_ROW_PROTO_TYPE_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRowItemsAddedEventsProvider ImmutableRowItemsAddedEventsProvider}.
     * @return An immutable instance of RowItemsAddedEventsProvider
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRowItemsAddedEventsProvider build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRowItemsAddedEventsProvider(null, rowProtoTypeId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ROW_PROTO_TYPE_ID) != 0) attributes.add("rowProtoTypeId");
      return "Cannot build RowItemsAddedEventsProvider, some of required attributes are not set " + attributes;
    }
  }
}
