package io.dialob.session.engine.session.command.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ItemAddedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableItemAddedEvent.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableItemAddedEvent.of()}.
 */
@Generated(from = "ItemAddedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableItemAddedEvent
    implements ItemAddedEvent {
  private final ItemId addItemId;
  private final ItemId prototypeId;

  private ImmutableItemAddedEvent(
      ItemId addItemId,
      ItemId prototypeId) {
    this.addItemId = Objects.requireNonNull(addItemId, "addItemId");
    this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
  }

  private ImmutableItemAddedEvent(
      ImmutableItemAddedEvent original,
      ItemId addItemId,
      ItemId prototypeId) {
    this.addItemId = addItemId;
    this.prototypeId = prototypeId;
  }

  /**
   * @return The value of the {@code addItemId} attribute
   */
  @Override
  public ItemId getAddItemId() {
    return addItemId;
  }

  /**
   * @return The value of the {@code prototypeId} attribute
   */
  @Override
  public ItemId getPrototypeId() {
    return prototypeId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemAddedEvent#getAddItemId() addItemId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for addItemId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemAddedEvent withAddItemId(ItemId value) {
    if (this.addItemId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "addItemId");
    return new ImmutableItemAddedEvent(this, newValue, this.prototypeId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemAddedEvent#getPrototypeId() prototypeId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for prototypeId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemAddedEvent withPrototypeId(ItemId value) {
    if (this.prototypeId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "prototypeId");
    return new ImmutableItemAddedEvent(this, this.addItemId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableItemAddedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableItemAddedEvent
        && equalTo((ImmutableItemAddedEvent) another);
  }

  private boolean equalTo(ImmutableItemAddedEvent another) {
    return addItemId.equals(another.addItemId)
        && prototypeId.equals(another.prototypeId);
  }

  /**
   * Computes a hash code from attributes: {@code addItemId}, {@code prototypeId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + addItemId.hashCode();
    h += (h << 5) + prototypeId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ItemAddedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ItemAddedEvent")
        .omitNullValues()
        .add("addItemId", addItemId)
        .add("prototypeId", prototypeId)
        .toString();
  }

  /**
   * Construct a new immutable {@code ItemAddedEvent} instance.
   * @param addItemId The value for the {@code addItemId} attribute
   * @param prototypeId The value for the {@code prototypeId} attribute
   * @return An immutable ItemAddedEvent instance
   */
  public static ImmutableItemAddedEvent of(ItemId addItemId, ItemId prototypeId) {
    return new ImmutableItemAddedEvent(addItemId, prototypeId);
  }

  /**
   * Creates an immutable copy of a {@link ItemAddedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ItemAddedEvent instance
   */
  public static ImmutableItemAddedEvent copyOf(ItemAddedEvent instance) {
    if (instance instanceof ImmutableItemAddedEvent) {
      return (ImmutableItemAddedEvent) instance;
    }
    return ImmutableItemAddedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableItemAddedEvent ImmutableItemAddedEvent}.
   * <pre>
   * ImmutableItemAddedEvent.builder()
   *    .addItemId(io.dialob.session.engine.session.model.ItemId) // required {@link ItemAddedEvent#getAddItemId() addItemId}
   *    .prototypeId(io.dialob.session.engine.session.model.ItemId) // required {@link ItemAddedEvent#getPrototypeId() prototypeId}
   *    .build();
   * </pre>
   * @return A new ImmutableItemAddedEvent builder
   */
  public static ImmutableItemAddedEvent.Builder builder() {
    return new ImmutableItemAddedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableItemAddedEvent ImmutableItemAddedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ItemAddedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ADD_ITEM_ID = 0x1L;
    private static final long INIT_BIT_PROTOTYPE_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ItemId addItemId;
    private @Nullable ItemId prototypeId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ItemAddedEvent} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ItemAddedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      addItemId(instance.getAddItemId());
      prototypeId(instance.getPrototypeId());
      return this;
    }

    /**
     * Initializes the value for the {@link ItemAddedEvent#getAddItemId() addItemId} attribute.
     * @param addItemId The value for addItemId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addItemId(ItemId addItemId) {
      this.addItemId = Objects.requireNonNull(addItemId, "addItemId");
      initBits &= ~INIT_BIT_ADD_ITEM_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ItemAddedEvent#getPrototypeId() prototypeId} attribute.
     * @param prototypeId The value for prototypeId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder prototypeId(ItemId prototypeId) {
      this.prototypeId = Objects.requireNonNull(prototypeId, "prototypeId");
      initBits &= ~INIT_BIT_PROTOTYPE_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableItemAddedEvent ImmutableItemAddedEvent}.
     * @return An immutable instance of ItemAddedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableItemAddedEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableItemAddedEvent(null, addItemId, prototypeId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ADD_ITEM_ID) != 0) attributes.add("addItemId");
      if ((initBits & INIT_BIT_PROTOTYPE_ID) != 0) attributes.add("prototypeId");
      return "Cannot build ItemAddedEvent, some of required attributes are not set " + attributes;
    }
  }
}
