package io.dialob.session.engine.session.command.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ActiveUpdatedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableActiveUpdatedEvent.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableActiveUpdatedEvent.of()}.
 */
@Generated(from = "ActiveUpdatedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableActiveUpdatedEvent
    implements ActiveUpdatedEvent {
  private final TargetEvent target;

  private ImmutableActiveUpdatedEvent(TargetEvent target) {
    this.target = Objects.requireNonNull(target, "target");
  }

  private ImmutableActiveUpdatedEvent(
      ImmutableActiveUpdatedEvent original,
      TargetEvent target) {
    this.target = target;
  }

  /**
   * @return The value of the {@code target} attribute
   */
  @Override
  public TargetEvent getTarget() {
    return target;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ActiveUpdatedEvent#getTarget() target} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for target
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableActiveUpdatedEvent withTarget(TargetEvent value) {
    if (this.target == value) return this;
    TargetEvent newValue = Objects.requireNonNull(value, "target");
    return new ImmutableActiveUpdatedEvent(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableActiveUpdatedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableActiveUpdatedEvent
        && equalTo((ImmutableActiveUpdatedEvent) another);
  }

  private boolean equalTo(ImmutableActiveUpdatedEvent another) {
    return target.equals(another.target);
  }

  /**
   * Computes a hash code from attributes: {@code target}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + target.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ActiveUpdatedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ActiveUpdatedEvent")
        .omitNullValues()
        .add("target", target)
        .toString();
  }

  /**
   * Construct a new immutable {@code ActiveUpdatedEvent} instance.
   * @param target The value for the {@code target} attribute
   * @return An immutable ActiveUpdatedEvent instance
   */
  public static ImmutableActiveUpdatedEvent of(TargetEvent target) {
    return new ImmutableActiveUpdatedEvent(target);
  }

  /**
   * Creates an immutable copy of a {@link ActiveUpdatedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ActiveUpdatedEvent instance
   */
  public static ImmutableActiveUpdatedEvent copyOf(ActiveUpdatedEvent instance) {
    if (instance instanceof ImmutableActiveUpdatedEvent) {
      return (ImmutableActiveUpdatedEvent) instance;
    }
    return ImmutableActiveUpdatedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableActiveUpdatedEvent ImmutableActiveUpdatedEvent}.
   * <pre>
   * ImmutableActiveUpdatedEvent.builder()
   *    .target(io.dialob.session.engine.session.command.event.TargetEvent) // required {@link ActiveUpdatedEvent#getTarget() target}
   *    .build();
   * </pre>
   * @return A new ImmutableActiveUpdatedEvent builder
   */
  public static ImmutableActiveUpdatedEvent.Builder builder() {
    return new ImmutableActiveUpdatedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableActiveUpdatedEvent ImmutableActiveUpdatedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ActiveUpdatedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TARGET = 0x1L;
    private long initBits = 0x1L;

    private @Nullable TargetEvent target;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.event.AttributeEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AttributeEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.event.ActiveUpdatedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ActiveUpdatedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AttributeEvent) {
        AttributeEvent instance = (AttributeEvent) object;
        target(instance.getTarget());
      }
    }

    /**
     * Initializes the value for the {@link ActiveUpdatedEvent#getTarget() target} attribute.
     * @param target The value for target 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder target(TargetEvent target) {
      this.target = Objects.requireNonNull(target, "target");
      initBits &= ~INIT_BIT_TARGET;
      return this;
    }

    /**
     * Builds a new {@link ImmutableActiveUpdatedEvent ImmutableActiveUpdatedEvent}.
     * @return An immutable instance of ActiveUpdatedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableActiveUpdatedEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableActiveUpdatedEvent(null, target);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TARGET) != 0) attributes.add("target");
      return "Cannot build ActiveUpdatedEvent, some of required attributes are not set " + attributes;
    }
  }
}
