package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.program.model.Value;
import io.dialob.session.engine.program.model.ValueSet;
import io.dialob.session.engine.session.model.ValueSetId;
import io.dialob.session.engine.session.model.ValueSetState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UpdateValueSetCommand}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUpdateValueSetCommand.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableUpdateValueSetCommand.of()}.
 */
@Generated(from = "UpdateValueSetCommand", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableUpdateValueSetCommand
    implements UpdateValueSetCommand {
  private final ImmutableList<Trigger<ValueSetState>> triggers;
  private final ValueSetId targetId;
  private final ImmutableList<Value<ValueSet.Entry>> entries;

  private ImmutableUpdateValueSetCommand(
      ValueSetId targetId,
      Iterable<? extends Value<ValueSet.Entry>> entries,
      Iterable<? extends Trigger<ValueSetState>> triggers) {
    this.targetId = Objects.requireNonNull(targetId, "targetId");
    this.entries = ImmutableList.copyOf(entries);
    this.triggers = ImmutableList.copyOf(triggers);
  }

  private ImmutableUpdateValueSetCommand(
      ImmutableUpdateValueSetCommand original,
      ImmutableList<Trigger<ValueSetState>> triggers,
      ValueSetId targetId,
      ImmutableList<Value<ValueSet.Entry>> entries) {
    this.triggers = triggers;
    this.targetId = targetId;
    this.entries = entries;
  }

  /**
   * @return The value of the {@code triggers} attribute
   */
  @Override
  public ImmutableList<Trigger<ValueSetState>> getTriggers() {
    return triggers;
  }

  /**
   * @return The value of the {@code targetId} attribute
   */
  @Override
  public ValueSetId getTargetId() {
    return targetId;
  }

  /**
   * @return The value of the {@code entries} attribute
   */
  @Override
  public ImmutableList<Value<ValueSet.Entry>> getEntries() {
    return entries;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UpdateValueSetCommand#getTriggers() triggers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableUpdateValueSetCommand withTriggers(Trigger<ValueSetState>... elements) {
    ImmutableList<Trigger<ValueSetState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableUpdateValueSetCommand(this, newValue, this.targetId, this.entries);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UpdateValueSetCommand#getTriggers() triggers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of triggers elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUpdateValueSetCommand withTriggers(Iterable<? extends Trigger<ValueSetState>> elements) {
    if (this.triggers == elements) return this;
    ImmutableList<Trigger<ValueSetState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableUpdateValueSetCommand(this, newValue, this.targetId, this.entries);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateValueSetCommand#getTargetId() targetId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpdateValueSetCommand withTargetId(ValueSetId value) {
    if (this.targetId == value) return this;
    ValueSetId newValue = Objects.requireNonNull(value, "targetId");
    return new ImmutableUpdateValueSetCommand(this, this.triggers, newValue, this.entries);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UpdateValueSetCommand#getEntries() entries}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableUpdateValueSetCommand withEntries(Value<ValueSet.Entry>... elements) {
    ImmutableList<Value<ValueSet.Entry>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableUpdateValueSetCommand(this, this.triggers, this.targetId, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UpdateValueSetCommand#getEntries() entries}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of entries elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUpdateValueSetCommand withEntries(Iterable<? extends Value<ValueSet.Entry>> elements) {
    if (this.entries == elements) return this;
    ImmutableList<Value<ValueSet.Entry>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableUpdateValueSetCommand(this, this.triggers, this.targetId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUpdateValueSetCommand} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUpdateValueSetCommand
        && equalTo((ImmutableUpdateValueSetCommand) another);
  }

  private boolean equalTo(ImmutableUpdateValueSetCommand another) {
    return triggers.equals(another.triggers)
        && targetId.equals(another.targetId)
        && entries.equals(another.entries);
  }

  /**
   * Computes a hash code from attributes: {@code triggers}, {@code targetId}, {@code entries}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + triggers.hashCode();
    h += (h << 5) + targetId.hashCode();
    h += (h << 5) + entries.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateValueSetCommand} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("UpdateValueSetCommand")
        .omitNullValues()
        .add("triggers", triggers)
        .add("targetId", targetId)
        .add("entries", entries)
        .toString();
  }

  /**
   * Construct a new immutable {@code UpdateValueSetCommand} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param entries The value for the {@code entries} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable UpdateValueSetCommand instance
   */
  public static ImmutableUpdateValueSetCommand of(ValueSetId targetId, List<Value<ValueSet.Entry>> entries, List<Trigger<ValueSetState>> triggers) {
    return of(targetId, (Iterable<? extends Value<ValueSet.Entry>>) entries, (Iterable<? extends Trigger<ValueSetState>>) triggers);
  }

  /**
   * Construct a new immutable {@code UpdateValueSetCommand} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param entries The value for the {@code entries} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable UpdateValueSetCommand instance
   */
  public static ImmutableUpdateValueSetCommand of(ValueSetId targetId, Iterable<? extends Value<ValueSet.Entry>> entries, Iterable<? extends Trigger<ValueSetState>> triggers) {
    return new ImmutableUpdateValueSetCommand(targetId, entries, triggers);
  }

  /**
   * Creates an immutable copy of a {@link UpdateValueSetCommand} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UpdateValueSetCommand instance
   */
  public static ImmutableUpdateValueSetCommand copyOf(UpdateValueSetCommand instance) {
    if (instance instanceof ImmutableUpdateValueSetCommand) {
      return (ImmutableUpdateValueSetCommand) instance;
    }
    return ImmutableUpdateValueSetCommand.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUpdateValueSetCommand ImmutableUpdateValueSetCommand}.
   * <pre>
   * ImmutableUpdateValueSetCommand.builder()
   *    .addTriggers|addAllTriggers(io.dialob.session.engine.session.command.Trigger&amp;lt;io.dialob.session.engine.session.model.ValueSetState&amp;gt;) // {@link UpdateValueSetCommand#getTriggers() triggers} elements
   *    .targetId(io.dialob.session.engine.session.model.ValueSetId) // required {@link UpdateValueSetCommand#getTargetId() targetId}
   *    .addEntries|addAllEntries(io.dialob.session.engine.program.model.Value&amp;lt;io.dialob.session.engine.program.model.ValueSet.Entry&amp;gt;) // {@link UpdateValueSetCommand#getEntries() entries} elements
   *    .build();
   * </pre>
   * @return A new ImmutableUpdateValueSetCommand builder
   */
  public static ImmutableUpdateValueSetCommand.Builder builder() {
    return new ImmutableUpdateValueSetCommand.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUpdateValueSetCommand ImmutableUpdateValueSetCommand}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UpdateValueSetCommand", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TARGET_ID = 0x1L;
    private long initBits = 0x1L;

    private ImmutableList.Builder<Trigger<ValueSetState>> triggers = ImmutableList.builder();
    private @Nullable ValueSetId targetId;
    private ImmutableList.Builder<Value<ValueSet.Entry>> entries = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateValueSetCommand} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateValueSetCommand instance) {
      Objects.requireNonNull(instance, "instance");
      addAllTriggers(instance.getTriggers());
      targetId(instance.getTargetId());
      addAllEntries(instance.getEntries());
      return this;
    }

    /**
     * Adds one element to {@link UpdateValueSetCommand#getTriggers() triggers} list.
     * @param element A triggers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTriggers(Trigger<ValueSetState> element) {
      this.triggers.add(element);
      return this;
    }

    /**
     * Adds elements to {@link UpdateValueSetCommand#getTriggers() triggers} list.
     * @param elements An array of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addTriggers(Trigger<ValueSetState>... elements) {
      this.triggers.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateValueSetCommand#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder triggers(Iterable<? extends Trigger<ValueSetState>> elements) {
      this.triggers = ImmutableList.builder();
      return addAllTriggers(elements);
    }

    /**
     * Adds elements to {@link UpdateValueSetCommand#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTriggers(Iterable<? extends Trigger<ValueSetState>> elements) {
      this.triggers.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateValueSetCommand#getTargetId() targetId} attribute.
     * @param targetId The value for targetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetId(ValueSetId targetId) {
      this.targetId = Objects.requireNonNull(targetId, "targetId");
      initBits &= ~INIT_BIT_TARGET_ID;
      return this;
    }

    /**
     * Adds one element to {@link UpdateValueSetCommand#getEntries() entries} list.
     * @param element A entries element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEntries(Value<ValueSet.Entry> element) {
      this.entries.add(element);
      return this;
    }

    /**
     * Adds elements to {@link UpdateValueSetCommand#getEntries() entries} list.
     * @param elements An array of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addEntries(Value<ValueSet.Entry>... elements) {
      this.entries.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateValueSetCommand#getEntries() entries} list.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder entries(Iterable<? extends Value<ValueSet.Entry>> elements) {
      this.entries = ImmutableList.builder();
      return addAllEntries(elements);
    }

    /**
     * Adds elements to {@link UpdateValueSetCommand#getEntries() entries} list.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllEntries(Iterable<? extends Value<ValueSet.Entry>> elements) {
      this.entries.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableUpdateValueSetCommand ImmutableUpdateValueSetCommand}.
     * @return An immutable instance of UpdateValueSetCommand
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUpdateValueSetCommand build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUpdateValueSetCommand(null, triggers.build(), targetId, entries.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TARGET_ID) != 0) attributes.add("targetId");
      return "Cannot build UpdateValueSetCommand, some of required attributes are not set " + attributes;
    }
  }
}
