package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UpdateIsInvalidAnswersCommand}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUpdateIsInvalidAnswersCommand.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableUpdateIsInvalidAnswersCommand.of()}.
 */
@Generated(from = "UpdateIsInvalidAnswersCommand", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableUpdateIsInvalidAnswersCommand
    implements UpdateIsInvalidAnswersCommand {
  private final ImmutableList<Trigger<ItemState>> triggers;
  private final ItemId targetId;
  private final Expression expression;

  private ImmutableUpdateIsInvalidAnswersCommand(
      ItemId targetId,
      Expression expression,
      Iterable<? extends Trigger<ItemState>> triggers) {
    this.targetId = Objects.requireNonNull(targetId, "targetId");
    this.expression = Objects.requireNonNull(expression, "expression");
    this.triggers = ImmutableList.copyOf(triggers);
  }

  private ImmutableUpdateIsInvalidAnswersCommand(
      ImmutableUpdateIsInvalidAnswersCommand original,
      ImmutableList<Trigger<ItemState>> triggers,
      ItemId targetId,
      Expression expression) {
    this.triggers = triggers;
    this.targetId = targetId;
    this.expression = expression;
  }

  /**
   * @return The value of the {@code triggers} attribute
   */
  @Override
  public ImmutableList<Trigger<ItemState>> getTriggers() {
    return triggers;
  }

  /**
   * @return The value of the {@code targetId} attribute
   */
  @Override
  public ItemId getTargetId() {
    return targetId;
  }

  /**
   * @return The value of the {@code expression} attribute
   */
  @Override
  public Expression getExpression() {
    return expression;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UpdateIsInvalidAnswersCommand#getTriggers() triggers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableUpdateIsInvalidAnswersCommand withTriggers(Trigger<ItemState>... elements) {
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableUpdateIsInvalidAnswersCommand(this, newValue, this.targetId, this.expression);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UpdateIsInvalidAnswersCommand#getTriggers() triggers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of triggers elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUpdateIsInvalidAnswersCommand withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
    if (this.triggers == elements) return this;
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableUpdateIsInvalidAnswersCommand(this, newValue, this.targetId, this.expression);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateIsInvalidAnswersCommand#getTargetId() targetId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpdateIsInvalidAnswersCommand withTargetId(ItemId value) {
    if (this.targetId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "targetId");
    return new ImmutableUpdateIsInvalidAnswersCommand(this, this.triggers, newValue, this.expression);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateIsInvalidAnswersCommand#getExpression() expression} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expression
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpdateIsInvalidAnswersCommand withExpression(Expression value) {
    if (this.expression == value) return this;
    Expression newValue = Objects.requireNonNull(value, "expression");
    return new ImmutableUpdateIsInvalidAnswersCommand(this, this.triggers, this.targetId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUpdateIsInvalidAnswersCommand} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUpdateIsInvalidAnswersCommand
        && equalTo((ImmutableUpdateIsInvalidAnswersCommand) another);
  }

  private boolean equalTo(ImmutableUpdateIsInvalidAnswersCommand another) {
    return triggers.equals(another.triggers)
        && targetId.equals(another.targetId)
        && expression.equals(another.expression);
  }

  /**
   * Computes a hash code from attributes: {@code triggers}, {@code targetId}, {@code expression}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + triggers.hashCode();
    h += (h << 5) + targetId.hashCode();
    h += (h << 5) + expression.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateIsInvalidAnswersCommand} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("UpdateIsInvalidAnswersCommand")
        .omitNullValues()
        .add("triggers", triggers)
        .add("targetId", targetId)
        .add("expression", expression)
        .toString();
  }

  /**
   * Construct a new immutable {@code UpdateIsInvalidAnswersCommand} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param expression The value for the {@code expression} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable UpdateIsInvalidAnswersCommand instance
   */
  public static ImmutableUpdateIsInvalidAnswersCommand of(ItemId targetId, Expression expression, List<Trigger<ItemState>> triggers) {
    return of(targetId, expression, (Iterable<? extends Trigger<ItemState>>) triggers);
  }

  /**
   * Construct a new immutable {@code UpdateIsInvalidAnswersCommand} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param expression The value for the {@code expression} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable UpdateIsInvalidAnswersCommand instance
   */
  public static ImmutableUpdateIsInvalidAnswersCommand of(ItemId targetId, Expression expression, Iterable<? extends Trigger<ItemState>> triggers) {
    return new ImmutableUpdateIsInvalidAnswersCommand(targetId, expression, triggers);
  }

  /**
   * Creates an immutable copy of a {@link UpdateIsInvalidAnswersCommand} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UpdateIsInvalidAnswersCommand instance
   */
  public static ImmutableUpdateIsInvalidAnswersCommand copyOf(UpdateIsInvalidAnswersCommand instance) {
    if (instance instanceof ImmutableUpdateIsInvalidAnswersCommand) {
      return (ImmutableUpdateIsInvalidAnswersCommand) instance;
    }
    return ImmutableUpdateIsInvalidAnswersCommand.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUpdateIsInvalidAnswersCommand ImmutableUpdateIsInvalidAnswersCommand}.
   * <pre>
   * ImmutableUpdateIsInvalidAnswersCommand.builder()
   *    .addTriggers|addAllTriggers(io.dialob.session.engine.session.command.Trigger&amp;lt;io.dialob.session.engine.session.model.ItemState&amp;gt;) // {@link UpdateIsInvalidAnswersCommand#getTriggers() triggers} elements
   *    .targetId(io.dialob.session.engine.session.model.ItemId) // required {@link UpdateIsInvalidAnswersCommand#getTargetId() targetId}
   *    .expression(io.dialob.session.engine.program.model.Expression) // required {@link UpdateIsInvalidAnswersCommand#getExpression() expression}
   *    .build();
   * </pre>
   * @return A new ImmutableUpdateIsInvalidAnswersCommand builder
   */
  public static ImmutableUpdateIsInvalidAnswersCommand.Builder builder() {
    return new ImmutableUpdateIsInvalidAnswersCommand.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUpdateIsInvalidAnswersCommand ImmutableUpdateIsInvalidAnswersCommand}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UpdateIsInvalidAnswersCommand", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TARGET_ID = 0x1L;
    private static final long INIT_BIT_EXPRESSION = 0x2L;
    private long initBits = 0x3L;

    private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
    private @Nullable ItemId targetId;
    private @Nullable Expression expression;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateIsInvalidAnswersCommand} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateIsInvalidAnswersCommand instance) {
      Objects.requireNonNull(instance, "instance");
      addAllTriggers(instance.getTriggers());
      targetId(instance.getTargetId());
      expression(instance.getExpression());
      return this;
    }

    /**
     * Adds one element to {@link UpdateIsInvalidAnswersCommand#getTriggers() triggers} list.
     * @param element A triggers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTriggers(Trigger<ItemState> element) {
      this.triggers.add(element);
      return this;
    }

    /**
     * Adds elements to {@link UpdateIsInvalidAnswersCommand#getTriggers() triggers} list.
     * @param elements An array of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addTriggers(Trigger<ItemState>... elements) {
      this.triggers.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateIsInvalidAnswersCommand#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers = ImmutableList.builder();
      return addAllTriggers(elements);
    }

    /**
     * Adds elements to {@link UpdateIsInvalidAnswersCommand#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateIsInvalidAnswersCommand#getTargetId() targetId} attribute.
     * @param targetId The value for targetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetId(ItemId targetId) {
      this.targetId = Objects.requireNonNull(targetId, "targetId");
      initBits &= ~INIT_BIT_TARGET_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateIsInvalidAnswersCommand#getExpression() expression} attribute.
     * @param expression The value for expression 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder expression(Expression expression) {
      this.expression = Objects.requireNonNull(expression, "expression");
      initBits &= ~INIT_BIT_EXPRESSION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUpdateIsInvalidAnswersCommand ImmutableUpdateIsInvalidAnswersCommand}.
     * @return An immutable instance of UpdateIsInvalidAnswersCommand
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUpdateIsInvalidAnswersCommand build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUpdateIsInvalidAnswersCommand(null, triggers.build(), targetId, expression);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TARGET_ID) != 0) attributes.add("targetId");
      if ((initBits & INIT_BIT_EXPRESSION) != 0) attributes.add("expression");
      return "Cannot build UpdateIsInvalidAnswersCommand, some of required attributes are not set " + attributes;
    }
  }
}
