package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.session.command.event.Event;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StaticTrigger}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStaticTrigger.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableStaticTrigger.of()}.
 */
@Generated(from = "StaticTrigger", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableStaticTrigger<T>
    implements StaticTrigger<T> {
  private final BiPredicate<T, T> when;
  private final ImmutableList<Event> allEvents;

  private ImmutableStaticTrigger(BiPredicate<T, T> when) {
    this.when = Objects.requireNonNull(when, "when");
    this.allEvents = ImmutableList.of();
  }

  private ImmutableStaticTrigger(
      BiPredicate<T, T> when,
      ImmutableList<Event> allEvents) {
    this.when = when;
    this.allEvents = allEvents;
  }

  /**
   * @return The value of the {@code when} attribute
   */
  @Override
  public BiPredicate<T, T> getWhen() {
    return when;
  }

  /**
   * @return The value of the {@code allEvents} attribute
   */
  @Override
  public ImmutableList<Event> getAllEvents() {
    return allEvents;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticTrigger#getWhen() when} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for when
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStaticTrigger<T> withWhen(BiPredicate<T, T> value) {
    if (this.when == value) return this;
    BiPredicate<T, T> newValue = Objects.requireNonNull(value, "when");
    return new ImmutableStaticTrigger<>(newValue, this.allEvents);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticTrigger#getAllEvents() allEvents}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStaticTrigger<T> withAllEvents(Event... elements) {
    ImmutableList<Event> newValue = ImmutableList.copyOf(elements);
    return new ImmutableStaticTrigger<>(this.when, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticTrigger#getAllEvents() allEvents}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of allEvents elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStaticTrigger<T> withAllEvents(Iterable<? extends Event> elements) {
    if (this.allEvents == elements) return this;
    ImmutableList<Event> newValue = ImmutableList.copyOf(elements);
    return new ImmutableStaticTrigger<>(this.when, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStaticTrigger} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStaticTrigger<?>
        && equalTo((ImmutableStaticTrigger<?>) another);
  }

  private boolean equalTo(ImmutableStaticTrigger<?> another) {
    return when.equals(another.when)
        && allEvents.equals(another.allEvents);
  }

  /**
   * Computes a hash code from attributes: {@code when}, {@code allEvents}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + when.hashCode();
    h += (h << 5) + allEvents.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StaticTrigger} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StaticTrigger")
        .omitNullValues()
        .add("when", when)
        .add("allEvents", allEvents)
        .toString();
  }

  /**
   * Construct a new immutable {@code StaticTrigger} instance.
 * @param <T> generic parameter T
   * @param when The value for the {@code when} attribute
   * @return An immutable StaticTrigger instance
   */
  public static <T> ImmutableStaticTrigger<T> of(BiPredicate<T, T> when) {
    return new ImmutableStaticTrigger<>(when);
  }

  /**
   * Creates an immutable copy of a {@link StaticTrigger} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable StaticTrigger instance
   */
  public static <T> ImmutableStaticTrigger<T> copyOf(StaticTrigger<T> instance) {
    if (instance instanceof ImmutableStaticTrigger<?>) {
      return (ImmutableStaticTrigger<T>) instance;
    }
    return ImmutableStaticTrigger.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStaticTrigger ImmutableStaticTrigger}.
   * <pre>
   * ImmutableStaticTrigger.&amp;lt;T&amp;gt;builder()
   *    .when(function.BiPredicate&amp;lt;T, T&amp;gt;) // required {@link StaticTrigger#getWhen() when}
   *    .addAllEvents|addAllAllEvents(io.dialob.session.engine.session.command.event.Event) // {@link StaticTrigger#getAllEvents() allEvents} elements
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableStaticTrigger builder
   */
  public static <T> ImmutableStaticTrigger.Builder<T> builder() {
    return new ImmutableStaticTrigger.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableStaticTrigger ImmutableStaticTrigger}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StaticTrigger", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_WHEN = 0x1L;
    private long initBits = 0x1L;

    private @Nullable BiPredicate<T, T> when;
    private ImmutableList.Builder<Event> allEvents = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.Trigger} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(Trigger<T> instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.StaticTrigger} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(StaticTrigger<T> instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    @SuppressWarnings("unchecked")
    private void from(Object object) {
      if (object instanceof Trigger<?>) {
        Trigger<T> instance = (Trigger<T>) object;
        addAllAllEvents(instance.getAllEvents());
        when(instance.getWhen());
      }
    }

    /**
     * Initializes the value for the {@link StaticTrigger#getWhen() when} attribute.
     * @param when The value for when 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> when(BiPredicate<T, T> when) {
      this.when = Objects.requireNonNull(when, "when");
      initBits &= ~INIT_BIT_WHEN;
      return this;
    }

    /**
     * Adds one element to {@link StaticTrigger#getAllEvents() allEvents} list.
     * @param element A allEvents element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> addAllEvents(Event element) {
      this.allEvents.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StaticTrigger#getAllEvents() allEvents} list.
     * @param elements An array of allEvents elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> addAllEvents(Event... elements) {
      this.allEvents.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StaticTrigger#getAllEvents() allEvents} list.
     * @param elements An iterable of allEvents elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> allEvents(Iterable<? extends Event> elements) {
      this.allEvents = ImmutableList.builder();
      return addAllAllEvents(elements);
    }

    /**
     * Adds elements to {@link StaticTrigger#getAllEvents() allEvents} list.
     * @param elements An iterable of allEvents elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> addAllAllEvents(Iterable<? extends Event> elements) {
      this.allEvents.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableStaticTrigger ImmutableStaticTrigger}.
     * @return An immutable instance of StaticTrigger
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStaticTrigger<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStaticTrigger<>(when, allEvents.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_WHEN) != 0) attributes.add("when");
      return "Cannot build StaticTrigger, some of required attributes are not set " + attributes;
    }
  }
}
