package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SetVariablePending}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSetVariablePending.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableSetVariablePending.of()}.
 */
@Generated(from = "SetVariablePending", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSetVariablePending
    implements SetVariablePending {
  private final ImmutableList<Trigger<ItemState>> triggers;
  private final ItemId targetId;

  private ImmutableSetVariablePending(
      ItemId targetId,
      Iterable<? extends Trigger<ItemState>> triggers) {
    this.targetId = Objects.requireNonNull(targetId, "targetId");
    this.triggers = ImmutableList.copyOf(triggers);
  }

  private ImmutableSetVariablePending(
      ImmutableSetVariablePending original,
      ImmutableList<Trigger<ItemState>> triggers,
      ItemId targetId) {
    this.triggers = triggers;
    this.targetId = targetId;
  }

  /**
   * @return The value of the {@code triggers} attribute
   */
  @Override
  public ImmutableList<Trigger<ItemState>> getTriggers() {
    return triggers;
  }

  /**
   * @return The value of the {@code targetId} attribute
   */
  @Override
  public ItemId getTargetId() {
    return targetId;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SetVariablePending#getTriggers() triggers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableSetVariablePending withTriggers(Trigger<ItemState>... elements) {
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSetVariablePending(this, newValue, this.targetId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SetVariablePending#getTriggers() triggers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of triggers elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSetVariablePending withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
    if (this.triggers == elements) return this;
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSetVariablePending(this, newValue, this.targetId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SetVariablePending#getTargetId() targetId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSetVariablePending withTargetId(ItemId value) {
    if (this.targetId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "targetId");
    return new ImmutableSetVariablePending(this, this.triggers, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSetVariablePending} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSetVariablePending
        && equalTo((ImmutableSetVariablePending) another);
  }

  private boolean equalTo(ImmutableSetVariablePending another) {
    return triggers.equals(another.triggers)
        && targetId.equals(another.targetId);
  }

  /**
   * Computes a hash code from attributes: {@code triggers}, {@code targetId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + triggers.hashCode();
    h += (h << 5) + targetId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SetVariablePending} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SetVariablePending")
        .omitNullValues()
        .add("triggers", triggers)
        .add("targetId", targetId)
        .toString();
  }

  /**
   * Construct a new immutable {@code SetVariablePending} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable SetVariablePending instance
   */
  public static ImmutableSetVariablePending of(ItemId targetId, List<Trigger<ItemState>> triggers) {
    return of(targetId, (Iterable<? extends Trigger<ItemState>>) triggers);
  }

  /**
   * Construct a new immutable {@code SetVariablePending} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable SetVariablePending instance
   */
  public static ImmutableSetVariablePending of(ItemId targetId, Iterable<? extends Trigger<ItemState>> triggers) {
    return new ImmutableSetVariablePending(targetId, triggers);
  }

  /**
   * Creates an immutable copy of a {@link SetVariablePending} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SetVariablePending instance
   */
  public static ImmutableSetVariablePending copyOf(SetVariablePending instance) {
    if (instance instanceof ImmutableSetVariablePending) {
      return (ImmutableSetVariablePending) instance;
    }
    return ImmutableSetVariablePending.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSetVariablePending ImmutableSetVariablePending}.
   * <pre>
   * ImmutableSetVariablePending.builder()
   *    .addTriggers|addAllTriggers(io.dialob.session.engine.session.command.Trigger&amp;lt;io.dialob.session.engine.session.model.ItemState&amp;gt;) // {@link SetVariablePending#getTriggers() triggers} elements
   *    .targetId(io.dialob.session.engine.session.model.ItemId) // required {@link SetVariablePending#getTargetId() targetId}
   *    .build();
   * </pre>
   * @return A new ImmutableSetVariablePending builder
   */
  public static ImmutableSetVariablePending.Builder builder() {
    return new ImmutableSetVariablePending.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSetVariablePending ImmutableSetVariablePending}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SetVariablePending", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TARGET_ID = 0x1L;
    private long initBits = 0x1L;

    private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
    private @Nullable ItemId targetId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SetVariablePending} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SetVariablePending instance) {
      Objects.requireNonNull(instance, "instance");
      addAllTriggers(instance.getTriggers());
      targetId(instance.getTargetId());
      return this;
    }

    /**
     * Adds one element to {@link SetVariablePending#getTriggers() triggers} list.
     * @param element A triggers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTriggers(Trigger<ItemState> element) {
      this.triggers.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SetVariablePending#getTriggers() triggers} list.
     * @param elements An array of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addTriggers(Trigger<ItemState>... elements) {
      this.triggers.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SetVariablePending#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers = ImmutableList.builder();
      return addAllTriggers(elements);
    }

    /**
     * Adds elements to {@link SetVariablePending#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link SetVariablePending#getTargetId() targetId} attribute.
     * @param targetId The value for targetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetId(ItemId targetId) {
      this.targetId = Objects.requireNonNull(targetId, "targetId");
      initBits &= ~INIT_BIT_TARGET_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSetVariablePending ImmutableSetVariablePending}.
     * @return An immutable instance of SetVariablePending
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSetVariablePending build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSetVariablePending(null, triggers.build(), targetId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TARGET_ID) != 0) attributes.add("targetId");
      return "Cannot build SetVariablePending, some of required attributes are not set " + attributes;
    }
  }
}
