package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SetLocale}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSetLocale.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableSetLocale.of()}.
 */
@Generated(from = "SetLocale", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSetLocale implements SetLocale {
  private final ImmutableList<Trigger<ItemState>> triggers;
  private final ItemId targetId;
  private final @Nullable String locale;

  private ImmutableSetLocale(
      @Nullable String locale,
      Iterable<? extends Trigger<ItemState>> triggers) {
    this.locale = locale;
    this.triggers = ImmutableList.copyOf(triggers);
    this.targetId = Objects.requireNonNull(SetLocale.super.getTargetId(), "targetId");
  }

  private ImmutableSetLocale(ImmutableSetLocale.Builder builder) {
    this.triggers = builder.triggers.build();
    this.locale = builder.locale;
    this.targetId = builder.targetId != null
        ? builder.targetId
        : Objects.requireNonNull(SetLocale.super.getTargetId(), "targetId");
  }

  private ImmutableSetLocale(
      ImmutableList<Trigger<ItemState>> triggers,
      ItemId targetId,
      @Nullable String locale) {
    this.triggers = triggers;
    this.targetId = targetId;
    this.locale = locale;
  }

  /**
   * @return The value of the {@code triggers} attribute
   */
  @Override
  public ImmutableList<Trigger<ItemState>> getTriggers() {
    return triggers;
  }

  /**
   * @return The value of the {@code targetId} attribute
   */
  @Override
  public ItemId getTargetId() {
    return targetId;
  }

  /**
   * @return The value of the {@code locale} attribute
   */
  @Override
  public @Nullable String getLocale() {
    return locale;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SetLocale#getTriggers() triggers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableSetLocale withTriggers(Trigger<ItemState>... elements) {
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSetLocale(newValue, this.targetId, this.locale);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SetLocale#getTriggers() triggers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of triggers elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSetLocale withTriggers(Iterable<? extends Trigger<ItemState>> elements) {
    if (this.triggers == elements) return this;
    ImmutableList<Trigger<ItemState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSetLocale(newValue, this.targetId, this.locale);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SetLocale#getTargetId() targetId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSetLocale withTargetId(ItemId value) {
    if (this.targetId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "targetId");
    return new ImmutableSetLocale(this.triggers, newValue, this.locale);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SetLocale#getLocale() locale} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locale (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSetLocale withLocale(@Nullable String value) {
    if (Objects.equals(this.locale, value)) return this;
    return new ImmutableSetLocale(this.triggers, this.targetId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSetLocale} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSetLocale
        && equalTo((ImmutableSetLocale) another);
  }

  private boolean equalTo(ImmutableSetLocale another) {
    return triggers.equals(another.triggers)
        && targetId.equals(another.targetId)
        && Objects.equals(locale, another.locale);
  }

  /**
   * Computes a hash code from attributes: {@code triggers}, {@code targetId}, {@code locale}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + triggers.hashCode();
    h += (h << 5) + targetId.hashCode();
    h += (h << 5) + Objects.hashCode(locale);
    return h;
  }

  /**
   * Prints the immutable value {@code SetLocale} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SetLocale")
        .omitNullValues()
        .add("triggers", triggers)
        .add("targetId", targetId)
        .add("locale", locale)
        .toString();
  }

  /**
   * Construct a new immutable {@code SetLocale} instance.
   * @param locale The value for the {@code locale} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable SetLocale instance
   */
  public static ImmutableSetLocale of(@Nullable String locale, List<Trigger<ItemState>> triggers) {
    return of(locale, (Iterable<? extends Trigger<ItemState>>) triggers);
  }

  /**
   * Construct a new immutable {@code SetLocale} instance.
   * @param locale The value for the {@code locale} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable SetLocale instance
   */
  public static ImmutableSetLocale of(@Nullable String locale, Iterable<? extends Trigger<ItemState>> triggers) {
    return new ImmutableSetLocale(locale, triggers);
  }

  /**
   * Creates an immutable copy of a {@link SetLocale} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SetLocale instance
   */
  public static ImmutableSetLocale copyOf(SetLocale instance) {
    if (instance instanceof ImmutableSetLocale) {
      return (ImmutableSetLocale) instance;
    }
    return ImmutableSetLocale.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSetLocale ImmutableSetLocale}.
   * <pre>
   * ImmutableSetLocale.builder()
   *    .addTriggers|addAllTriggers(io.dialob.session.engine.session.command.Trigger&amp;lt;io.dialob.session.engine.session.model.ItemState&amp;gt;) // {@link SetLocale#getTriggers() triggers} elements
   *    .targetId(io.dialob.session.engine.session.model.ItemId) // optional {@link SetLocale#getTargetId() targetId}
   *    .locale(String | null) // nullable {@link SetLocale#getLocale() locale}
   *    .build();
   * </pre>
   * @return A new ImmutableSetLocale builder
   */
  public static ImmutableSetLocale.Builder builder() {
    return new ImmutableSetLocale.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSetLocale ImmutableSetLocale}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SetLocale", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<Trigger<ItemState>> triggers = ImmutableList.builder();
    private @Nullable ItemId targetId;
    private @Nullable String locale;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SetLocale} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SetLocale instance) {
      Objects.requireNonNull(instance, "instance");
      addAllTriggers(instance.getTriggers());
      targetId(instance.getTargetId());
      @Nullable String localeValue = instance.getLocale();
      if (localeValue != null) {
        locale(localeValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link SetLocale#getTriggers() triggers} list.
     * @param element A triggers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTriggers(Trigger<ItemState> element) {
      this.triggers.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SetLocale#getTriggers() triggers} list.
     * @param elements An array of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addTriggers(Trigger<ItemState>... elements) {
      this.triggers.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SetLocale#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder triggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers = ImmutableList.builder();
      return addAllTriggers(elements);
    }

    /**
     * Adds elements to {@link SetLocale#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTriggers(Iterable<? extends Trigger<ItemState>> elements) {
      this.triggers.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link SetLocale#getTargetId() targetId} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SetLocale#getTargetId() targetId}.</em>
     * @param targetId The value for targetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetId(ItemId targetId) {
      this.targetId = Objects.requireNonNull(targetId, "targetId");
      return this;
    }

    /**
     * Initializes the value for the {@link SetLocale#getLocale() locale} attribute.
     * @param locale The value for locale (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder locale(@Nullable String locale) {
      this.locale = locale;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSetLocale ImmutableSetLocale}.
     * @return An immutable instance of SetLocale
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSetLocale build() {
      return new ImmutableSetLocale(this);
    }
  }
}
