package io.dialob.session.engine.session.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.model.ErrorId;
import io.dialob.session.engine.session.model.ErrorState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ErrorLabelUpdateCommand}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableErrorLabelUpdateCommand.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableErrorLabelUpdateCommand.of()}.
 */
@Generated(from = "ErrorLabelUpdateCommand", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableErrorLabelUpdateCommand
    implements ErrorLabelUpdateCommand {
  private final ImmutableList<Trigger<ErrorState>> triggers;
  private final ErrorId targetId;
  private final Expression expression;

  private ImmutableErrorLabelUpdateCommand(
      ErrorId targetId,
      Expression expression,
      Iterable<? extends Trigger<ErrorState>> triggers) {
    this.targetId = Objects.requireNonNull(targetId, "targetId");
    this.expression = Objects.requireNonNull(expression, "expression");
    this.triggers = ImmutableList.copyOf(triggers);
  }

  private ImmutableErrorLabelUpdateCommand(
      ImmutableErrorLabelUpdateCommand original,
      ImmutableList<Trigger<ErrorState>> triggers,
      ErrorId targetId,
      Expression expression) {
    this.triggers = triggers;
    this.targetId = targetId;
    this.expression = expression;
  }

  /**
   * @return The value of the {@code triggers} attribute
   */
  @Override
  public ImmutableList<Trigger<ErrorState>> getTriggers() {
    return triggers;
  }

  /**
   * @return The value of the {@code targetId} attribute
   */
  @Override
  public ErrorId getTargetId() {
    return targetId;
  }

  /**
   * @return The value of the {@code expression} attribute
   */
  @Override
  public Expression getExpression() {
    return expression;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ErrorLabelUpdateCommand#getTriggers() triggers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableErrorLabelUpdateCommand withTriggers(Trigger<ErrorState>... elements) {
    ImmutableList<Trigger<ErrorState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableErrorLabelUpdateCommand(this, newValue, this.targetId, this.expression);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ErrorLabelUpdateCommand#getTriggers() triggers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of triggers elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableErrorLabelUpdateCommand withTriggers(Iterable<? extends Trigger<ErrorState>> elements) {
    if (this.triggers == elements) return this;
    ImmutableList<Trigger<ErrorState>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableErrorLabelUpdateCommand(this, newValue, this.targetId, this.expression);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ErrorLabelUpdateCommand#getTargetId() targetId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableErrorLabelUpdateCommand withTargetId(ErrorId value) {
    if (this.targetId == value) return this;
    ErrorId newValue = Objects.requireNonNull(value, "targetId");
    return new ImmutableErrorLabelUpdateCommand(this, this.triggers, newValue, this.expression);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ErrorLabelUpdateCommand#getExpression() expression} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expression
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableErrorLabelUpdateCommand withExpression(Expression value) {
    if (this.expression == value) return this;
    Expression newValue = Objects.requireNonNull(value, "expression");
    return new ImmutableErrorLabelUpdateCommand(this, this.triggers, this.targetId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableErrorLabelUpdateCommand} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableErrorLabelUpdateCommand
        && equalTo((ImmutableErrorLabelUpdateCommand) another);
  }

  private boolean equalTo(ImmutableErrorLabelUpdateCommand another) {
    return triggers.equals(another.triggers)
        && targetId.equals(another.targetId)
        && expression.equals(another.expression);
  }

  /**
   * Computes a hash code from attributes: {@code triggers}, {@code targetId}, {@code expression}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + triggers.hashCode();
    h += (h << 5) + targetId.hashCode();
    h += (h << 5) + expression.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ErrorLabelUpdateCommand} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ErrorLabelUpdateCommand")
        .omitNullValues()
        .add("triggers", triggers)
        .add("targetId", targetId)
        .add("expression", expression)
        .toString();
  }

  /**
   * Construct a new immutable {@code ErrorLabelUpdateCommand} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param expression The value for the {@code expression} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable ErrorLabelUpdateCommand instance
   */
  public static ImmutableErrorLabelUpdateCommand of(ErrorId targetId, Expression expression, List<Trigger<ErrorState>> triggers) {
    return of(targetId, expression, (Iterable<? extends Trigger<ErrorState>>) triggers);
  }

  /**
   * Construct a new immutable {@code ErrorLabelUpdateCommand} instance.
   * @param targetId The value for the {@code targetId} attribute
   * @param expression The value for the {@code expression} attribute
   * @param triggers The value for the {@code triggers} attribute
   * @return An immutable ErrorLabelUpdateCommand instance
   */
  public static ImmutableErrorLabelUpdateCommand of(ErrorId targetId, Expression expression, Iterable<? extends Trigger<ErrorState>> triggers) {
    return new ImmutableErrorLabelUpdateCommand(targetId, expression, triggers);
  }

  /**
   * Creates an immutable copy of a {@link ErrorLabelUpdateCommand} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ErrorLabelUpdateCommand instance
   */
  public static ImmutableErrorLabelUpdateCommand copyOf(ErrorLabelUpdateCommand instance) {
    if (instance instanceof ImmutableErrorLabelUpdateCommand) {
      return (ImmutableErrorLabelUpdateCommand) instance;
    }
    return ImmutableErrorLabelUpdateCommand.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableErrorLabelUpdateCommand ImmutableErrorLabelUpdateCommand}.
   * <pre>
   * ImmutableErrorLabelUpdateCommand.builder()
   *    .addTriggers|addAllTriggers(io.dialob.session.engine.session.command.Trigger&amp;lt;io.dialob.session.engine.session.model.ErrorState&amp;gt;) // {@link ErrorLabelUpdateCommand#getTriggers() triggers} elements
   *    .targetId(io.dialob.session.engine.session.model.ErrorId) // required {@link ErrorLabelUpdateCommand#getTargetId() targetId}
   *    .expression(io.dialob.session.engine.program.model.Expression) // required {@link ErrorLabelUpdateCommand#getExpression() expression}
   *    .build();
   * </pre>
   * @return A new ImmutableErrorLabelUpdateCommand builder
   */
  public static ImmutableErrorLabelUpdateCommand.Builder builder() {
    return new ImmutableErrorLabelUpdateCommand.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableErrorLabelUpdateCommand ImmutableErrorLabelUpdateCommand}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ErrorLabelUpdateCommand", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TARGET_ID = 0x1L;
    private static final long INIT_BIT_EXPRESSION = 0x2L;
    private long initBits = 0x3L;

    private ImmutableList.Builder<Trigger<ErrorState>> triggers = ImmutableList.builder();
    private @Nullable ErrorId targetId;
    private @Nullable Expression expression;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.ErrorLabelUpdateCommand} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ErrorLabelUpdateCommand instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.session.command.ErrorUpdateCommand} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ErrorUpdateCommand instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ErrorLabelUpdateCommand) {
        ErrorLabelUpdateCommand instance = (ErrorLabelUpdateCommand) object;
        targetId(instance.getTargetId());
        addAllTriggers(instance.getTriggers());
      }
      if (object instanceof ErrorUpdateCommand) {
        ErrorUpdateCommand instance = (ErrorUpdateCommand) object;
        expression(instance.getExpression());
      }
    }

    /**
     * Adds one element to {@link ErrorLabelUpdateCommand#getTriggers() triggers} list.
     * @param element A triggers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTriggers(Trigger<ErrorState> element) {
      this.triggers.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ErrorLabelUpdateCommand#getTriggers() triggers} list.
     * @param elements An array of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addTriggers(Trigger<ErrorState>... elements) {
      this.triggers.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ErrorLabelUpdateCommand#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder triggers(Iterable<? extends Trigger<ErrorState>> elements) {
      this.triggers = ImmutableList.builder();
      return addAllTriggers(elements);
    }

    /**
     * Adds elements to {@link ErrorLabelUpdateCommand#getTriggers() triggers} list.
     * @param elements An iterable of triggers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTriggers(Iterable<? extends Trigger<ErrorState>> elements) {
      this.triggers.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link ErrorLabelUpdateCommand#getTargetId() targetId} attribute.
     * @param targetId The value for targetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetId(ErrorId targetId) {
      this.targetId = Objects.requireNonNull(targetId, "targetId");
      initBits &= ~INIT_BIT_TARGET_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ErrorLabelUpdateCommand#getExpression() expression} attribute.
     * @param expression The value for expression 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder expression(Expression expression) {
      this.expression = Objects.requireNonNull(expression, "expression");
      initBits &= ~INIT_BIT_EXPRESSION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableErrorLabelUpdateCommand ImmutableErrorLabelUpdateCommand}.
     * @return An immutable instance of ErrorLabelUpdateCommand
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableErrorLabelUpdateCommand build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableErrorLabelUpdateCommand(null, triggers.build(), targetId, expression);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TARGET_ID) != 0) attributes.add("targetId");
      if ((initBits & INIT_BIT_EXPRESSION) != 0) attributes.add("expression");
      return "Cannot build ErrorLabelUpdateCommand, some of required attributes are not set " + attributes;
    }
  }
}
