/*
 * Copyright © 2015 - 2021 ReSys (info@dialob.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.dialob.session.engine.session.command;

import io.dialob.session.engine.program.EvalContext;
import io.dialob.session.engine.session.model.ItemId;
import io.dialob.session.engine.session.model.ItemState;
import org.immutables.value.Value;

import javax.annotation.Nonnull;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Value.Immutable
public interface AddRow extends AbstractUpdateCommand<ItemId, ItemState>, ItemUpdateCommand {

  @Override
  @Nonnull
  default ItemState update(@Nonnull EvalContext context, @Nonnull ItemState itemState) {
    if (itemState.isRowsCanBeAdded()) {
      // calculate id for a new row
      List<BigInteger> rowNumbers = (List<BigInteger>) itemState.getValue();
      if (rowNumbers == null) {
        rowNumbers = Collections.emptyList();
      }
      rowNumbers = new ArrayList<>(rowNumbers);
      BigInteger newRowId = rowNumbers.stream()
        .reduce(BigInteger::max)
        .map(i -> i.add(BigInteger.ONE))
        .orElse(BigInteger.ZERO);
      rowNumbers.add(newRowId);
      return itemState.update()
        .setAnswer(rowNumbers)
        .setValue(rowNumbers)
        .get();
    }
    return itemState;
  }
}
