package io.dialob.session.engine.session;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AsyncFunctionCall}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAsyncFunctionCall.builder()}.
 */
@Generated(from = "AsyncFunctionCall", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAsyncFunctionCall implements AsyncFunctionCall {
  private final @Nullable String id;
  private final @Nullable ItemId targetId;
  private final String functionName;
  private final Object[] args;

  private ImmutableAsyncFunctionCall(
      @Nullable String id,
      @Nullable ItemId targetId,
      String functionName,
      Object[] args) {
    this.id = id;
    this.targetId = targetId;
    this.functionName = functionName;
    this.args = args;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public Optional<String> getId() {
    return Optional.ofNullable(id);
  }

  /**
   * @return The value of the {@code targetId} attribute
   */
  @Override
  public Optional<ItemId> getTargetId() {
    return Optional.ofNullable(targetId);
  }

  /**
   * @return The value of the {@code functionName} attribute
   */
  @Override
  public String getFunctionName() {
    return functionName;
  }

  /**
   * @return A cloned {@code args} array
   */
  @Override
  public Object[] getArgs() {
    return args.clone();
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AsyncFunctionCall#getId() id} attribute.
   * @param value The value for id
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAsyncFunctionCall withId(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "id");
    if (Objects.equals(this.id, newValue)) return this;
    return new ImmutableAsyncFunctionCall(newValue, this.targetId, this.functionName, this.args);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AsyncFunctionCall#getId() id} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for id
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAsyncFunctionCall withId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableAsyncFunctionCall(value, this.targetId, this.functionName, this.args);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AsyncFunctionCall#getTargetId() targetId} attribute.
   * @param value The value for targetId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAsyncFunctionCall withTargetId(ItemId value) {
    @Nullable ItemId newValue = Objects.requireNonNull(value, "targetId");
    if (this.targetId == newValue) return this;
    return new ImmutableAsyncFunctionCall(this.id, newValue, this.functionName, this.args);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AsyncFunctionCall#getTargetId() targetId} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for targetId
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableAsyncFunctionCall withTargetId(Optional<? extends ItemId> optional) {
    @Nullable ItemId value = optional.orElse(null);
    if (this.targetId == value) return this;
    return new ImmutableAsyncFunctionCall(this.id, value, this.functionName, this.args);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AsyncFunctionCall#getFunctionName() functionName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for functionName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAsyncFunctionCall withFunctionName(String value) {
    String newValue = Objects.requireNonNull(value, "functionName");
    if (this.functionName.equals(newValue)) return this;
    return new ImmutableAsyncFunctionCall(this.id, this.targetId, newValue, this.args);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AsyncFunctionCall#getArgs() args}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for args
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAsyncFunctionCall withArgs(Object... elements) {
    Object[] newValue = elements.clone();
    return new ImmutableAsyncFunctionCall(this.id, this.targetId, this.functionName, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAsyncFunctionCall} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAsyncFunctionCall
        && equalTo((ImmutableAsyncFunctionCall) another);
  }

  private boolean equalTo(ImmutableAsyncFunctionCall another) {
    return Objects.equals(id, another.id)
        && Objects.equals(targetId, another.targetId)
        && functionName.equals(another.functionName)
        && Arrays.equals(args, another.args);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code targetId}, {@code functionName}, {@code args}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(targetId);
    h += (h << 5) + functionName.hashCode();
    h += (h << 5) + Arrays.hashCode(args);
    return h;
  }

  /**
   * Prints the immutable value {@code AsyncFunctionCall} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AsyncFunctionCall")
        .omitNullValues()
        .add("id", id)
        .add("targetId", targetId)
        .add("functionName", functionName)
        .add("args", Arrays.toString(args))
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link AsyncFunctionCall} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AsyncFunctionCall instance
   */
  public static ImmutableAsyncFunctionCall copyOf(AsyncFunctionCall instance) {
    if (instance instanceof ImmutableAsyncFunctionCall) {
      return (ImmutableAsyncFunctionCall) instance;
    }
    return ImmutableAsyncFunctionCall.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAsyncFunctionCall ImmutableAsyncFunctionCall}.
   * <pre>
   * ImmutableAsyncFunctionCall.builder()
   *    .id(String) // optional {@link AsyncFunctionCall#getId() id}
   *    .targetId(io.dialob.session.engine.session.model.ItemId) // optional {@link AsyncFunctionCall#getTargetId() targetId}
   *    .functionName(String) // required {@link AsyncFunctionCall#getFunctionName() functionName}
   *    .args(Object) // required {@link AsyncFunctionCall#getArgs() args}
   *    .build();
   * </pre>
   * @return A new ImmutableAsyncFunctionCall builder
   */
  public static ImmutableAsyncFunctionCall.Builder builder() {
    return new ImmutableAsyncFunctionCall.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAsyncFunctionCall ImmutableAsyncFunctionCall}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AsyncFunctionCall", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FUNCTION_NAME = 0x1L;
    private static final long INIT_BIT_ARGS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable ItemId targetId;
    private @Nullable String functionName;
    private @Nullable Object[] args;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AsyncFunctionCall} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AsyncFunctionCall instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> idOptional = instance.getId();
      if (idOptional.isPresent()) {
        id(idOptional);
      }
      Optional<ItemId> targetIdOptional = instance.getTargetId();
      if (targetIdOptional.isPresent()) {
        targetId(targetIdOptional);
      }
      functionName(instance.getFunctionName());
      args(instance.getArgs());
      return this;
    }

    /**
     * Initializes the optional value {@link AsyncFunctionCall#getId() id} to id.
     * @param id The value for id
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return this;
    }

    /**
     * Initializes the optional value {@link AsyncFunctionCall#getId() id} to id.
     * @param id The value for id
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(Optional<String> id) {
      this.id = id.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AsyncFunctionCall#getTargetId() targetId} to targetId.
     * @param targetId The value for targetId
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetId(ItemId targetId) {
      this.targetId = Objects.requireNonNull(targetId, "targetId");
      return this;
    }

    /**
     * Initializes the optional value {@link AsyncFunctionCall#getTargetId() targetId} to targetId.
     * @param targetId The value for targetId
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetId(Optional<? extends ItemId> targetId) {
      this.targetId = targetId.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link AsyncFunctionCall#getFunctionName() functionName} attribute.
     * @param functionName The value for functionName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder functionName(String functionName) {
      this.functionName = Objects.requireNonNull(functionName, "functionName");
      initBits &= ~INIT_BIT_FUNCTION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link AsyncFunctionCall#getArgs() args} attribute.
     * @param args The elements for args
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder args(Object... args) {
      this.args = args.clone();
      initBits &= ~INIT_BIT_ARGS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAsyncFunctionCall ImmutableAsyncFunctionCall}.
     * @return An immutable instance of AsyncFunctionCall
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAsyncFunctionCall build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAsyncFunctionCall(id, targetId, functionName, args);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FUNCTION_NAME) != 0) attributes.add("functionName");
      if ((initBits & INIT_BIT_ARGS) != 0) attributes.add("args");
      return "Cannot build AsyncFunctionCall, some of required attributes are not set " + attributes;
    }
  }
}
