package io.dialob.session.engine.program.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ValueSet}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValueSet.builder()}.
 */
@Generated(from = "ValueSet", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableValueSet implements ValueSet {
  private final String id;
  private final ImmutableList<Value<ValueSet.Entry>> entries;

  private ImmutableValueSet(
      String id,
      ImmutableList<Value<ValueSet.Entry>> entries) {
    this.id = id;
    this.entries = entries;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code entries} attribute
   */
  @Override
  public ImmutableList<Value<ValueSet.Entry>> getEntries() {
    return entries;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueSet#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValueSet withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableValueSet(newValue, this.entries);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ValueSet#getEntries() entries}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableValueSet withEntries(Value<ValueSet.Entry>... elements) {
    ImmutableList<Value<ValueSet.Entry>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableValueSet(this.id, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ValueSet#getEntries() entries}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of entries elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableValueSet withEntries(Iterable<? extends Value<ValueSet.Entry>> elements) {
    if (this.entries == elements) return this;
    ImmutableList<Value<ValueSet.Entry>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableValueSet(this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValueSet} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValueSet
        && equalTo((ImmutableValueSet) another);
  }

  private boolean equalTo(ImmutableValueSet another) {
    return id.equals(another.id)
        && entries.equals(another.entries);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code entries}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + entries.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ValueSet} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ValueSet")
        .omitNullValues()
        .add("id", id)
        .add("entries", entries)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ValueSet} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ValueSet instance
   */
  public static ImmutableValueSet copyOf(ValueSet instance) {
    if (instance instanceof ImmutableValueSet) {
      return (ImmutableValueSet) instance;
    }
    return ImmutableValueSet.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValueSet ImmutableValueSet}.
   * <pre>
   * ImmutableValueSet.builder()
   *    .id(String) // required {@link ValueSet#getId() id}
   *    .addEntries|addAllEntries(io.dialob.session.engine.program.model.Value&amp;lt;io.dialob.session.engine.program.model.ValueSet.Entry&amp;gt;) // {@link ValueSet#getEntries() entries} elements
   *    .build();
   * </pre>
   * @return A new ImmutableValueSet builder
   */
  public static ImmutableValueSet.Builder builder() {
    return new ImmutableValueSet.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableValueSet ImmutableValueSet}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ValueSet", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String id;
    private ImmutableList.Builder<Value<ValueSet.Entry>> entries = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ValueSet} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ValueSet instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      addAllEntries(instance.getEntries());
      return this;
    }

    /**
     * Initializes the value for the {@link ValueSet#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Adds one element to {@link ValueSet#getEntries() entries} list.
     * @param element A entries element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEntries(Value<ValueSet.Entry> element) {
      this.entries.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ValueSet#getEntries() entries} list.
     * @param elements An array of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addEntries(Value<ValueSet.Entry>... elements) {
      this.entries.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ValueSet#getEntries() entries} list.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder entries(Iterable<? extends Value<ValueSet.Entry>> elements) {
      this.entries = ImmutableList.builder();
      return addAllEntries(elements);
    }

    /**
     * Adds elements to {@link ValueSet#getEntries() entries} list.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllEntries(Iterable<? extends Value<ValueSet.Entry>> elements) {
      this.entries.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableValueSet ImmutableValueSet}.
     * @return An immutable instance of ValueSet
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValueSet build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableValueSet(id, entries.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build ValueSet, some of required attributes are not set " + attributes;
    }
  }

  /**
   * Immutable implementation of {@link ValueSet.Entry}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableValueSet.Entry.builder()}.
   */
  @Generated(from = "ValueSet.Entry", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class Entry implements ValueSet.Entry {
    private final String key;
    private final Expression label;

    private Entry(String key, Expression label) {
      this.key = key;
      this.label = label;
    }

    /**
     * @return The value of the {@code key} attribute
     */
    @Override
    public String getKey() {
      return key;
    }

    /**
     * @return The value of the {@code label} attribute
     */
    @Override
    public Expression getLabel() {
      return label;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ValueSet.Entry#getKey() key} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for key
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableValueSet.Entry withKey(String value) {
      String newValue = Objects.requireNonNull(value, "key");
      if (this.key.equals(newValue)) return this;
      return new ImmutableValueSet.Entry(newValue, this.label);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ValueSet.Entry#getLabel() label} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for label
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableValueSet.Entry withLabel(Expression value) {
      if (this.label == value) return this;
      Expression newValue = Objects.requireNonNull(value, "label");
      return new ImmutableValueSet.Entry(this.key, newValue);
    }

    /**
     * This instance is equal to all instances of {@code Entry} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableValueSet.Entry
          && equalTo((ImmutableValueSet.Entry) another);
    }

    private boolean equalTo(ImmutableValueSet.Entry another) {
      return key.equals(another.key)
          && label.equals(another.label);
    }

    /**
     * Computes a hash code from attributes: {@code key}, {@code label}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + key.hashCode();
      h += (h << 5) + label.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code Entry} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Entry")
          .omitNullValues()
          .add("key", key)
          .add("label", label)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link ValueSet.Entry} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Entry instance
     */
    public static ImmutableValueSet.Entry copyOf(ValueSet.Entry instance) {
      if (instance instanceof ImmutableValueSet.Entry) {
        return (ImmutableValueSet.Entry) instance;
      }
      return ImmutableValueSet.Entry.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableValueSet.Entry Entry}.
     * <pre>
     * ImmutableValueSet.Entry.builder()
     *    .key(String) // required {@link ValueSet.Entry#getKey() key}
     *    .label(io.dialob.session.engine.program.model.Expression) // required {@link ValueSet.Entry#getLabel() label}
     *    .build();
     * </pre>
     * @return A new Entry builder
     */
    public static ImmutableValueSet.Entry.Builder builder() {
      return new ImmutableValueSet.Entry.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableValueSet.Entry Entry}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "ValueSet.Entry", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_KEY = 0x1L;
      private static final long INIT_BIT_LABEL = 0x2L;
      private long initBits = 0x3L;

      private @Nullable String key;
      private @Nullable Expression label;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Entry} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(ValueSet.Entry instance) {
        Objects.requireNonNull(instance, "instance");
        key(instance.getKey());
        label(instance.getLabel());
        return this;
      }

      /**
       * Initializes the value for the {@link ValueSet.Entry#getKey() key} attribute.
       * @param key The value for key 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder key(String key) {
        this.key = Objects.requireNonNull(key, "key");
        initBits &= ~INIT_BIT_KEY;
        return this;
      }

      /**
       * Initializes the value for the {@link ValueSet.Entry#getLabel() label} attribute.
       * @param label The value for label 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder label(Expression label) {
        this.label = Objects.requireNonNull(label, "label");
        initBits &= ~INIT_BIT_LABEL;
        return this;
      }

      /**
       * Builds a new {@link ImmutableValueSet.Entry Entry}.
       * @return An immutable instance of Entry
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableValueSet.Entry build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableValueSet.Entry(key, label);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
        if ((initBits & INIT_BIT_LABEL) != 0) attributes.add("label");
        return "Cannot build Entry, some of required attributes are not set " + attributes;
      }
    }
  }
}
