package io.dialob.session.engine.program.model;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Group}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGroup.builder()}.
 */
@Generated(from = "Group", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGroup implements Group {
  private final boolean isPrototype;
  private final ItemId id;
  private final String type;
  private final @Nullable ValueType valueType;
  private final @Nullable String valueSetId;
  private final @Nullable Object defaultValue;
  private final @org.jetbrains.annotations.Nullable String view;
  private final @org.jetbrains.annotations.Nullable Map<String, Object> props;
  private final @Nullable Expression className;
  private final @Nullable Expression activeExpression;
  private final @Nullable Expression requiredExpression;
  private final @Nullable Expression disabledExpression;
  private final @Nullable Expression labelExpression;
  private final @Nullable Expression descriptionExpression;
  private final List<Error> errors;
  private final Expression itemsExpression;
  private final @Nullable Expression availableItemsExpression;
  private final @Nullable Expression isInvalidAnswersExpression;
  private final @Nullable Expression allowedActionsExpression;
  private final @Nullable Expression canAddRowWhenExpression;
  private final @Nullable Expression canRemoveRowWhenExpression;

  private ImmutableGroup(ImmutableGroup.Builder builder) {
    this.id = builder.id;
    this.type = builder.type;
    this.valueType = builder.valueType;
    this.valueSetId = builder.valueSetId;
    this.defaultValue = builder.defaultValue;
    this.view = builder.view;
    this.props = builder.props == null ? null : createUnmodifiableMap(false, false, builder.props);
    this.className = builder.className;
    this.activeExpression = builder.activeExpression;
    this.requiredExpression = builder.requiredExpression;
    this.disabledExpression = builder.disabledExpression;
    this.labelExpression = builder.labelExpression;
    this.descriptionExpression = builder.descriptionExpression;
    this.errors = createUnmodifiableList(true, builder.errors);
    this.itemsExpression = builder.itemsExpression;
    this.availableItemsExpression = builder.availableItemsExpression;
    this.isInvalidAnswersExpression = builder.isInvalidAnswersExpression;
    this.allowedActionsExpression = builder.allowedActionsExpression;
    this.canAddRowWhenExpression = builder.canAddRowWhenExpression;
    this.canRemoveRowWhenExpression = builder.canRemoveRowWhenExpression;
    this.isPrototype = builder.isPrototypeIsSet()
        ? builder.isPrototype
        : Group.super.isPrototype();
  }

  private ImmutableGroup(
      boolean isPrototype,
      ItemId id,
      String type,
      @Nullable ValueType valueType,
      @Nullable String valueSetId,
      @Nullable Object defaultValue,
      @org.jetbrains.annotations.Nullable String view,
      @org.jetbrains.annotations.Nullable Map<String, Object> props,
      @Nullable Expression className,
      @Nullable Expression activeExpression,
      @Nullable Expression requiredExpression,
      @Nullable Expression disabledExpression,
      @Nullable Expression labelExpression,
      @Nullable Expression descriptionExpression,
      List<Error> errors,
      Expression itemsExpression,
      @Nullable Expression availableItemsExpression,
      @Nullable Expression isInvalidAnswersExpression,
      @Nullable Expression allowedActionsExpression,
      @Nullable Expression canAddRowWhenExpression,
      @Nullable Expression canRemoveRowWhenExpression) {
    this.isPrototype = isPrototype;
    this.id = id;
    this.type = type;
    this.valueType = valueType;
    this.valueSetId = valueSetId;
    this.defaultValue = defaultValue;
    this.view = view;
    this.props = props;
    this.className = className;
    this.activeExpression = activeExpression;
    this.requiredExpression = requiredExpression;
    this.disabledExpression = disabledExpression;
    this.labelExpression = labelExpression;
    this.descriptionExpression = descriptionExpression;
    this.errors = errors;
    this.itemsExpression = itemsExpression;
    this.availableItemsExpression = availableItemsExpression;
    this.isInvalidAnswersExpression = isInvalidAnswersExpression;
    this.allowedActionsExpression = allowedActionsExpression;
    this.canAddRowWhenExpression = canAddRowWhenExpression;
    this.canRemoveRowWhenExpression = canRemoveRowWhenExpression;
  }

  /**
   * @return The value of the {@code isPrototype} attribute
   */
  @Override
  public boolean isPrototype() {
    return isPrototype;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public ItemId getId() {
    return id;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code valueType} attribute
   */
  @Override
  public @Nullable ValueType getValueType() {
    return valueType;
  }

  /**
   * @return The value of the {@code valueSetId} attribute
   */
  @Override
  public Optional<String> getValueSetId() {
    return Optional.ofNullable(valueSetId);
  }

  /**
   * @return The value of the {@code defaultValue} attribute
   */
  @Override
  public Optional<Object> getDefaultValue() {
    return Optional.ofNullable(defaultValue);
  }

  /**
   * @return The value of the {@code view} attribute
   */
  @Override
  public @org.jetbrains.annotations.Nullable String getView() {
    return view;
  }

  /**
   * @return The value of the {@code props} attribute
   */
  @Override
  public @org.jetbrains.annotations.Nullable Map<String, Object> getProps() {
    return props;
  }

  /**
   * @return The value of the {@code className} attribute
   */
  @Override
  public Optional<Expression> getClassName() {
    return Optional.ofNullable(className);
  }

  /**
   * @return The value of the {@code activeExpression} attribute
   */
  @Override
  public Optional<Expression> getActiveExpression() {
    return Optional.ofNullable(activeExpression);
  }

  /**
   * @return The value of the {@code requiredExpression} attribute
   */
  @Override
  public Optional<Expression> getRequiredExpression() {
    return Optional.ofNullable(requiredExpression);
  }

  /**
   * @return The value of the {@code disabledExpression} attribute
   */
  @Override
  public Optional<Expression> getDisabledExpression() {
    return Optional.ofNullable(disabledExpression);
  }

  /**
   * @return The value of the {@code labelExpression} attribute
   */
  @Override
  public Optional<Expression> getLabelExpression() {
    return Optional.ofNullable(labelExpression);
  }

  /**
   * @return The value of the {@code descriptionExpression} attribute
   */
  @Override
  public Optional<Expression> getDescriptionExpression() {
    return Optional.ofNullable(descriptionExpression);
  }

  /**
   * @return The value of the {@code errors} attribute
   */
  @Override
  public List<Error> getErrors() {
    return errors;
  }

  /**
   * @return The value of the {@code itemsExpression} attribute
   */
  @Override
  public Expression getItemsExpression() {
    return itemsExpression;
  }

  /**
   * @return The value of the {@code availableItemsExpression} attribute
   */
  @Override
  public Optional<Expression> getAvailableItemsExpression() {
    return Optional.ofNullable(availableItemsExpression);
  }

  /**
   * @return The value of the {@code isInvalidAnswersExpression} attribute
   */
  @Override
  public Optional<Expression> getIsInvalidAnswersExpression() {
    return Optional.ofNullable(isInvalidAnswersExpression);
  }

  /**
   * @return The value of the {@code allowedActionsExpression} attribute
   */
  @Override
  public Optional<Expression> getAllowedActionsExpression() {
    return Optional.ofNullable(allowedActionsExpression);
  }

  /**
   * @return The value of the {@code canAddRowWhenExpression} attribute
   */
  @Override
  public Optional<Expression> getCanAddRowWhenExpression() {
    return Optional.ofNullable(canAddRowWhenExpression);
  }

  /**
   * @return The value of the {@code canRemoveRowWhenExpression} attribute
   */
  @Override
  public Optional<Expression> getCanRemoveRowWhenExpression() {
    return Optional.ofNullable(canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Group#isPrototype() isPrototype} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isPrototype
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroup withIsPrototype(boolean value) {
    if (this.isPrototype == value) return this;
    return new ImmutableGroup(
        value,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Group#getId() id} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroup withId(ItemId value) {
    if (this.id == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "id");
    return new ImmutableGroup(
        this.isPrototype,
        newValue,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Group#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroup withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        newValue,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Group#getValueType() valueType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroup withValueType(@Nullable ValueType value) {
    if (this.valueType == value) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        value,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Group#getValueSetId() valueSetId} attribute.
   * @param value The value for valueSetId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroup withValueSetId(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "valueSetId");
    if (Objects.equals(this.valueSetId, newValue)) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        newValue,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Group#getValueSetId() valueSetId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for valueSetId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroup withValueSetId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.valueSetId, value)) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        value,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Group#getDefaultValue() defaultValue} attribute.
   * @param value The value for defaultValue
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroup withDefaultValue(Object value) {
    @Nullable Object newValue = Objects.requireNonNull(value, "defaultValue");
    if (this.defaultValue == newValue) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        newValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Group#getDefaultValue() defaultValue} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for defaultValue
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableGroup withDefaultValue(Optional<? extends Object> optional) {
    @Nullable Object value = optional.orElse(null);
    if (this.defaultValue == value) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        value,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Group#getView() view} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for view (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroup withView(@org.jetbrains.annotations.Nullable String value) {
    if (Objects.equals(this.view, value)) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        value,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by replacing the {@link Group#getProps() props} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the props map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroup withProps(@org.jetbrains.annotations.Nullable Map<String, ? extends Object> entries) {
    if (this.props == entries) return this;
    @org.jetbrains.annotations.Nullable Map<String, Object> newValue = entries == null ? null : createUnmodifiableMap(false, false, entries);
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        newValue,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Group#getClassName() className} attribute.
   * @param value The value for className
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroup withClassName(Expression value) {
    @Nullable Expression newValue = Objects.requireNonNull(value, "className");
    if (this.className == newValue) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        newValue,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Group#getClassName() className} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for className
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableGroup withClassName(Optional<? extends Expression> optional) {
    @Nullable Expression value = optional.orElse(null);
    if (this.className == value) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        value,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Group#getActiveExpression() activeExpression} attribute.
   * @param value The value for activeExpression
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroup withActiveExpression(Expression value) {
    @Nullable Expression newValue = Objects.requireNonNull(value, "activeExpression");
    if (this.activeExpression == newValue) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        newValue,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Group#getActiveExpression() activeExpression} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for activeExpression
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableGroup withActiveExpression(Optional<? extends Expression> optional) {
    @Nullable Expression value = optional.orElse(null);
    if (this.activeExpression == value) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        value,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Group#getRequiredExpression() requiredExpression} attribute.
   * @param value The value for requiredExpression
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroup withRequiredExpression(Expression value) {
    @Nullable Expression newValue = Objects.requireNonNull(value, "requiredExpression");
    if (this.requiredExpression == newValue) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        newValue,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Group#getRequiredExpression() requiredExpression} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for requiredExpression
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableGroup withRequiredExpression(Optional<? extends Expression> optional) {
    @Nullable Expression value = optional.orElse(null);
    if (this.requiredExpression == value) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        value,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Group#getDisabledExpression() disabledExpression} attribute.
   * @param value The value for disabledExpression
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroup withDisabledExpression(Expression value) {
    @Nullable Expression newValue = Objects.requireNonNull(value, "disabledExpression");
    if (this.disabledExpression == newValue) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        newValue,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Group#getDisabledExpression() disabledExpression} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for disabledExpression
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableGroup withDisabledExpression(Optional<? extends Expression> optional) {
    @Nullable Expression value = optional.orElse(null);
    if (this.disabledExpression == value) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        value,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Group#getLabelExpression() labelExpression} attribute.
   * @param value The value for labelExpression
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroup withLabelExpression(Expression value) {
    @Nullable Expression newValue = Objects.requireNonNull(value, "labelExpression");
    if (this.labelExpression == newValue) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        newValue,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Group#getLabelExpression() labelExpression} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for labelExpression
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableGroup withLabelExpression(Optional<? extends Expression> optional) {
    @Nullable Expression value = optional.orElse(null);
    if (this.labelExpression == value) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        value,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Group#getDescriptionExpression() descriptionExpression} attribute.
   * @param value The value for descriptionExpression
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroup withDescriptionExpression(Expression value) {
    @Nullable Expression newValue = Objects.requireNonNull(value, "descriptionExpression");
    if (this.descriptionExpression == newValue) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        newValue,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Group#getDescriptionExpression() descriptionExpression} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for descriptionExpression
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableGroup withDescriptionExpression(Optional<? extends Expression> optional) {
    @Nullable Expression value = optional.orElse(null);
    if (this.descriptionExpression == value) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        value,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Group#getErrors() errors}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroup withErrors(Error... elements) {
    List<Error> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        newValue,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Group#getErrors() errors}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of errors elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroup withErrors(Iterable<? extends Error> elements) {
    if (this.errors == elements) return this;
    List<Error> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        newValue,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Group#getItemsExpression() itemsExpression} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for itemsExpression
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroup withItemsExpression(Expression value) {
    if (this.itemsExpression == value) return this;
    Expression newValue = Objects.requireNonNull(value, "itemsExpression");
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        newValue,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Group#getAvailableItemsExpression() availableItemsExpression} attribute.
   * @param value The value for availableItemsExpression
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroup withAvailableItemsExpression(Expression value) {
    @Nullable Expression newValue = Objects.requireNonNull(value, "availableItemsExpression");
    if (this.availableItemsExpression == newValue) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        newValue,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Group#getAvailableItemsExpression() availableItemsExpression} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for availableItemsExpression
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableGroup withAvailableItemsExpression(Optional<? extends Expression> optional) {
    @Nullable Expression value = optional.orElse(null);
    if (this.availableItemsExpression == value) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        value,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Group#getIsInvalidAnswersExpression() isInvalidAnswersExpression} attribute.
   * @param value The value for isInvalidAnswersExpression
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroup withIsInvalidAnswersExpression(Expression value) {
    @Nullable Expression newValue = Objects.requireNonNull(value, "isInvalidAnswersExpression");
    if (this.isInvalidAnswersExpression == newValue) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        newValue,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Group#getIsInvalidAnswersExpression() isInvalidAnswersExpression} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for isInvalidAnswersExpression
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableGroup withIsInvalidAnswersExpression(Optional<? extends Expression> optional) {
    @Nullable Expression value = optional.orElse(null);
    if (this.isInvalidAnswersExpression == value) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        value,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Group#getAllowedActionsExpression() allowedActionsExpression} attribute.
   * @param value The value for allowedActionsExpression
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroup withAllowedActionsExpression(Expression value) {
    @Nullable Expression newValue = Objects.requireNonNull(value, "allowedActionsExpression");
    if (this.allowedActionsExpression == newValue) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        newValue,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Group#getAllowedActionsExpression() allowedActionsExpression} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for allowedActionsExpression
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableGroup withAllowedActionsExpression(Optional<? extends Expression> optional) {
    @Nullable Expression value = optional.orElse(null);
    if (this.allowedActionsExpression == value) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        value,
        this.canAddRowWhenExpression,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Group#getCanAddRowWhenExpression() canAddRowWhenExpression} attribute.
   * @param value The value for canAddRowWhenExpression
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroup withCanAddRowWhenExpression(Expression value) {
    @Nullable Expression newValue = Objects.requireNonNull(value, "canAddRowWhenExpression");
    if (this.canAddRowWhenExpression == newValue) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        newValue,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Group#getCanAddRowWhenExpression() canAddRowWhenExpression} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for canAddRowWhenExpression
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableGroup withCanAddRowWhenExpression(Optional<? extends Expression> optional) {
    @Nullable Expression value = optional.orElse(null);
    if (this.canAddRowWhenExpression == value) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        value,
        this.canRemoveRowWhenExpression);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Group#getCanRemoveRowWhenExpression() canRemoveRowWhenExpression} attribute.
   * @param value The value for canRemoveRowWhenExpression
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroup withCanRemoveRowWhenExpression(Expression value) {
    @Nullable Expression newValue = Objects.requireNonNull(value, "canRemoveRowWhenExpression");
    if (this.canRemoveRowWhenExpression == newValue) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Group#getCanRemoveRowWhenExpression() canRemoveRowWhenExpression} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for canRemoveRowWhenExpression
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableGroup withCanRemoveRowWhenExpression(Optional<? extends Expression> optional) {
    @Nullable Expression value = optional.orElse(null);
    if (this.canRemoveRowWhenExpression == value) return this;
    return new ImmutableGroup(
        this.isPrototype,
        this.id,
        this.type,
        this.valueType,
        this.valueSetId,
        this.defaultValue,
        this.view,
        this.props,
        this.className,
        this.activeExpression,
        this.requiredExpression,
        this.disabledExpression,
        this.labelExpression,
        this.descriptionExpression,
        this.errors,
        this.itemsExpression,
        this.availableItemsExpression,
        this.isInvalidAnswersExpression,
        this.allowedActionsExpression,
        this.canAddRowWhenExpression,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGroup} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGroup
        && equalTo((ImmutableGroup) another);
  }

  private boolean equalTo(ImmutableGroup another) {
    return isPrototype == another.isPrototype
        && id.equals(another.id)
        && type.equals(another.type)
        && Objects.equals(valueType, another.valueType)
        && Objects.equals(valueSetId, another.valueSetId)
        && Objects.equals(defaultValue, another.defaultValue)
        && Objects.equals(view, another.view)
        && Objects.equals(props, another.props)
        && Objects.equals(className, another.className)
        && Objects.equals(activeExpression, another.activeExpression)
        && Objects.equals(requiredExpression, another.requiredExpression)
        && Objects.equals(disabledExpression, another.disabledExpression)
        && Objects.equals(labelExpression, another.labelExpression)
        && Objects.equals(descriptionExpression, another.descriptionExpression)
        && errors.equals(another.errors)
        && itemsExpression.equals(another.itemsExpression)
        && Objects.equals(availableItemsExpression, another.availableItemsExpression)
        && Objects.equals(isInvalidAnswersExpression, another.isInvalidAnswersExpression)
        && Objects.equals(allowedActionsExpression, another.allowedActionsExpression)
        && Objects.equals(canAddRowWhenExpression, another.canAddRowWhenExpression)
        && Objects.equals(canRemoveRowWhenExpression, another.canRemoveRowWhenExpression);
  }

  /**
   * Computes a hash code from attributes: {@code isPrototype}, {@code id}, {@code type}, {@code valueType}, {@code valueSetId}, {@code defaultValue}, {@code view}, {@code props}, {@code className}, {@code activeExpression}, {@code requiredExpression}, {@code disabledExpression}, {@code labelExpression}, {@code descriptionExpression}, {@code errors}, {@code itemsExpression}, {@code availableItemsExpression}, {@code isInvalidAnswersExpression}, {@code allowedActionsExpression}, {@code canAddRowWhenExpression}, {@code canRemoveRowWhenExpression}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Boolean.hashCode(isPrototype);
    h += (h << 5) + id.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(valueType);
    h += (h << 5) + Objects.hashCode(valueSetId);
    h += (h << 5) + Objects.hashCode(defaultValue);
    h += (h << 5) + Objects.hashCode(view);
    h += (h << 5) + Objects.hashCode(props);
    h += (h << 5) + Objects.hashCode(className);
    h += (h << 5) + Objects.hashCode(activeExpression);
    h += (h << 5) + Objects.hashCode(requiredExpression);
    h += (h << 5) + Objects.hashCode(disabledExpression);
    h += (h << 5) + Objects.hashCode(labelExpression);
    h += (h << 5) + Objects.hashCode(descriptionExpression);
    h += (h << 5) + errors.hashCode();
    h += (h << 5) + itemsExpression.hashCode();
    h += (h << 5) + Objects.hashCode(availableItemsExpression);
    h += (h << 5) + Objects.hashCode(isInvalidAnswersExpression);
    h += (h << 5) + Objects.hashCode(allowedActionsExpression);
    h += (h << 5) + Objects.hashCode(canAddRowWhenExpression);
    h += (h << 5) + Objects.hashCode(canRemoveRowWhenExpression);
    return h;
  }

  /**
   * Prints the immutable value {@code Group} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Group{");
    builder.append("isPrototype=").append(isPrototype);
    builder.append(", ");
    builder.append("id=").append(id);
    builder.append(", ");
    builder.append("type=").append(type);
    if (valueType != null) {
      builder.append(", ");
      builder.append("valueType=").append(valueType);
    }
    if (valueSetId != null) {
      builder.append(", ");
      builder.append("valueSetId=").append(valueSetId);
    }
    if (defaultValue != null) {
      builder.append(", ");
      builder.append("defaultValue=").append(defaultValue);
    }
    if (view != null) {
      builder.append(", ");
      builder.append("view=").append(view);
    }
    if (props != null) {
      builder.append(", ");
      builder.append("props=").append(props);
    }
    if (className != null) {
      builder.append(", ");
      builder.append("className=").append(className);
    }
    if (activeExpression != null) {
      builder.append(", ");
      builder.append("activeExpression=").append(activeExpression);
    }
    if (requiredExpression != null) {
      builder.append(", ");
      builder.append("requiredExpression=").append(requiredExpression);
    }
    if (disabledExpression != null) {
      builder.append(", ");
      builder.append("disabledExpression=").append(disabledExpression);
    }
    if (labelExpression != null) {
      builder.append(", ");
      builder.append("labelExpression=").append(labelExpression);
    }
    if (descriptionExpression != null) {
      builder.append(", ");
      builder.append("descriptionExpression=").append(descriptionExpression);
    }
    builder.append(", ");
    builder.append("errors=").append(errors);
    builder.append(", ");
    builder.append("itemsExpression=").append(itemsExpression);
    if (availableItemsExpression != null) {
      builder.append(", ");
      builder.append("availableItemsExpression=").append(availableItemsExpression);
    }
    if (isInvalidAnswersExpression != null) {
      builder.append(", ");
      builder.append("isInvalidAnswersExpression=").append(isInvalidAnswersExpression);
    }
    if (allowedActionsExpression != null) {
      builder.append(", ");
      builder.append("allowedActionsExpression=").append(allowedActionsExpression);
    }
    if (canAddRowWhenExpression != null) {
      builder.append(", ");
      builder.append("canAddRowWhenExpression=").append(canAddRowWhenExpression);
    }
    if (canRemoveRowWhenExpression != null) {
      builder.append(", ");
      builder.append("canRemoveRowWhenExpression=").append(canRemoveRowWhenExpression);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link Group} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Group instance
   */
  public static ImmutableGroup copyOf(Group instance) {
    if (instance instanceof ImmutableGroup) {
      return (ImmutableGroup) instance;
    }
    return ImmutableGroup.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGroup ImmutableGroup}.
   * <pre>
   * ImmutableGroup.builder()
   *    .isPrototype(boolean) // optional {@link Group#isPrototype() isPrototype}
   *    .id(io.dialob.session.engine.session.model.ItemId) // required {@link Group#getId() id}
   *    .type(String) // required {@link Group#getType() type}
   *    .valueType(io.dialob.rule.parser.api.ValueType | null) // nullable {@link Group#getValueType() valueType}
   *    .valueSetId(String) // optional {@link Group#getValueSetId() valueSetId}
   *    .defaultValue(Object) // optional {@link Group#getDefaultValue() defaultValue}
   *    .view(String | null) // nullable {@link Group#getView() view}
   *    .props(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link Group#getProps() props}
   *    .className(io.dialob.session.engine.program.model.Expression) // optional {@link Group#getClassName() className}
   *    .activeExpression(io.dialob.session.engine.program.model.Expression) // optional {@link Group#getActiveExpression() activeExpression}
   *    .requiredExpression(io.dialob.session.engine.program.model.Expression) // optional {@link Group#getRequiredExpression() requiredExpression}
   *    .disabledExpression(io.dialob.session.engine.program.model.Expression) // optional {@link Group#getDisabledExpression() disabledExpression}
   *    .labelExpression(io.dialob.session.engine.program.model.Expression) // optional {@link Group#getLabelExpression() labelExpression}
   *    .descriptionExpression(io.dialob.session.engine.program.model.Expression) // optional {@link Group#getDescriptionExpression() descriptionExpression}
   *    .addErrors|addAllErrors(io.dialob.session.engine.program.model.Error) // {@link Group#getErrors() errors} elements
   *    .itemsExpression(io.dialob.session.engine.program.model.Expression) // required {@link Group#getItemsExpression() itemsExpression}
   *    .availableItemsExpression(io.dialob.session.engine.program.model.Expression) // optional {@link Group#getAvailableItemsExpression() availableItemsExpression}
   *    .isInvalidAnswersExpression(io.dialob.session.engine.program.model.Expression) // optional {@link Group#getIsInvalidAnswersExpression() isInvalidAnswersExpression}
   *    .allowedActionsExpression(io.dialob.session.engine.program.model.Expression) // optional {@link Group#getAllowedActionsExpression() allowedActionsExpression}
   *    .canAddRowWhenExpression(io.dialob.session.engine.program.model.Expression) // optional {@link Group#getCanAddRowWhenExpression() canAddRowWhenExpression}
   *    .canRemoveRowWhenExpression(io.dialob.session.engine.program.model.Expression) // optional {@link Group#getCanRemoveRowWhenExpression() canRemoveRowWhenExpression}
   *    .build();
   * </pre>
   * @return A new ImmutableGroup builder
   */
  public static ImmutableGroup.Builder builder() {
    return new ImmutableGroup.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGroup ImmutableGroup}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Group", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private static final long INIT_BIT_ITEMS_EXPRESSION = 0x4L;
    private static final long OPT_BIT_IS_PROTOTYPE = 0x1L;
    private long initBits = 0x7L;
    private long optBits;

    private boolean isPrototype;
    private @Nullable ItemId id;
    private @Nullable String type;
    private @Nullable ValueType valueType;
    private @Nullable String valueSetId;
    private @Nullable Object defaultValue;
    private @Nullable String view;
    private Map<String, Object> props = null;
    private @Nullable Expression className;
    private @Nullable Expression activeExpression;
    private @Nullable Expression requiredExpression;
    private @Nullable Expression disabledExpression;
    private @Nullable Expression labelExpression;
    private @Nullable Expression descriptionExpression;
    private List<Error> errors = new ArrayList<Error>();
    private @Nullable Expression itemsExpression;
    private @Nullable Expression availableItemsExpression;
    private @Nullable Expression isInvalidAnswersExpression;
    private @Nullable Expression allowedActionsExpression;
    private @Nullable Expression canAddRowWhenExpression;
    private @Nullable Expression canRemoveRowWhenExpression;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.model.DisplayItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DisplayItem instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.model.Item} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Item instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.model.Group} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Group instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.model.StructuralNode} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StructuralNode instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof DisplayItem) {
        DisplayItem instance = (DisplayItem) object;
        @org.jetbrains.annotations.Nullable String viewValue = instance.getView();
        if (viewValue != null) {
          view(viewValue);
        }
        Optional<Expression> activeExpressionOptional = instance.getActiveExpression();
        if (activeExpressionOptional.isPresent()) {
          activeExpression(activeExpressionOptional);
        }
        Optional<Expression> requiredExpressionOptional = instance.getRequiredExpression();
        if (requiredExpressionOptional.isPresent()) {
          requiredExpression(requiredExpressionOptional);
        }
        Optional<Expression> classNameOptional = instance.getClassName();
        if (classNameOptional.isPresent()) {
          className(classNameOptional);
        }
        Optional<Expression> disabledExpressionOptional = instance.getDisabledExpression();
        if (disabledExpressionOptional.isPresent()) {
          disabledExpression(disabledExpressionOptional);
        }
        Optional<Expression> labelExpressionOptional = instance.getLabelExpression();
        if (labelExpressionOptional.isPresent()) {
          labelExpression(labelExpressionOptional);
        }
        addAllErrors(instance.getErrors());
        @org.jetbrains.annotations.Nullable Map<String, Object> propsValue = instance.getProps();
        if (propsValue != null) {
          putAllProps(propsValue);
        }
        Optional<Expression> descriptionExpressionOptional = instance.getDescriptionExpression();
        if (descriptionExpressionOptional.isPresent()) {
          descriptionExpression(descriptionExpressionOptional);
        }
      }
      if (object instanceof Item) {
        Item instance = (Item) object;
        id(instance.getId());
        type(instance.getType());
        Optional<Object> defaultValueOptional = instance.getDefaultValue();
        if (defaultValueOptional.isPresent()) {
          defaultValue(defaultValueOptional);
        }
        Optional<String> valueSetIdOptional = instance.getValueSetId();
        if (valueSetIdOptional.isPresent()) {
          valueSetId(valueSetIdOptional);
        }
        @Nullable ValueType valueTypeValue = instance.getValueType();
        if (valueTypeValue != null) {
          valueType(valueTypeValue);
        }
      }
      if (object instanceof Group) {
        Group instance = (Group) object;
        Optional<Expression> availableItemsExpressionOptional = instance.getAvailableItemsExpression();
        if (availableItemsExpressionOptional.isPresent()) {
          availableItemsExpression(availableItemsExpressionOptional);
        }
        Optional<Expression> allowedActionsExpressionOptional = instance.getAllowedActionsExpression();
        if (allowedActionsExpressionOptional.isPresent()) {
          allowedActionsExpression(allowedActionsExpressionOptional);
        }
        itemsExpression(instance.getItemsExpression());
        Optional<Expression> isInvalidAnswersExpressionOptional = instance.getIsInvalidAnswersExpression();
        if (isInvalidAnswersExpressionOptional.isPresent()) {
          isInvalidAnswersExpression(isInvalidAnswersExpressionOptional);
        }
        Optional<Expression> canAddRowWhenExpressionOptional = instance.getCanAddRowWhenExpression();
        if (canAddRowWhenExpressionOptional.isPresent()) {
          canAddRowWhenExpression(canAddRowWhenExpressionOptional);
        }
        Optional<Expression> canRemoveRowWhenExpressionOptional = instance.getCanRemoveRowWhenExpression();
        if (canRemoveRowWhenExpressionOptional.isPresent()) {
          canRemoveRowWhenExpression(canRemoveRowWhenExpressionOptional);
        }
      }
      if (object instanceof StructuralNode) {
        StructuralNode instance = (StructuralNode) object;
        isPrototype(instance.isPrototype());
      }
    }

    /**
     * Initializes the value for the {@link Group#isPrototype() isPrototype} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Group#isPrototype() isPrototype}.</em>
     * @param isPrototype The value for isPrototype 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isPrototype(boolean isPrototype) {
      this.isPrototype = isPrototype;
      optBits |= OPT_BIT_IS_PROTOTYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Group#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(ItemId id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Group#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Group#getValueType() valueType} attribute.
     * @param valueType The value for valueType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder valueType(@Nullable ValueType valueType) {
      this.valueType = valueType;
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getValueSetId() valueSetId} to valueSetId.
     * @param valueSetId The value for valueSetId
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder valueSetId(String valueSetId) {
      this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getValueSetId() valueSetId} to valueSetId.
     * @param valueSetId The value for valueSetId
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder valueSetId(Optional<String> valueSetId) {
      this.valueSetId = valueSetId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getDefaultValue() defaultValue} to defaultValue.
     * @param defaultValue The value for defaultValue
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defaultValue(Object defaultValue) {
      this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getDefaultValue() defaultValue} to defaultValue.
     * @param defaultValue The value for defaultValue
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defaultValue(Optional<? extends Object> defaultValue) {
      this.defaultValue = defaultValue.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link Group#getView() view} attribute.
     * @param view The value for view (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder view(@org.jetbrains.annotations.Nullable String view) {
      this.view = view;
      return this;
    }

    /**
     * Put one entry to the {@link Group#getProps() props} map.
     * @param key The key in the props map
     * @param value The associated value in the props map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putProps(@Nullable String key, @Nullable Object value) {
      if (this.props == null) {
        this.props = new LinkedHashMap<String, Object>();
      }
      this.props.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Group#getProps() props} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putProps(Map.Entry<String, ? extends Object> entry) {
      if (this.props == null) {
        this.props = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.props.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Group#getProps() props} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the props map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder props(@org.jetbrains.annotations.Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.props = null;
        return this;
      }
      this.props = new LinkedHashMap<String, Object>();
      return putAllProps(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Group#getProps() props} map. Nulls are not permitted
     * @param entries The entries that will be added to the props map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllProps(Map<String, ? extends Object> entries) {
      if (this.props == null) {
        this.props = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.props.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getClassName() className} to className.
     * @param className The value for className
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder className(Expression className) {
      this.className = Objects.requireNonNull(className, "className");
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getClassName() className} to className.
     * @param className The value for className
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder className(Optional<? extends Expression> className) {
      this.className = className.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getActiveExpression() activeExpression} to activeExpression.
     * @param activeExpression The value for activeExpression
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder activeExpression(Expression activeExpression) {
      this.activeExpression = Objects.requireNonNull(activeExpression, "activeExpression");
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getActiveExpression() activeExpression} to activeExpression.
     * @param activeExpression The value for activeExpression
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder activeExpression(Optional<? extends Expression> activeExpression) {
      this.activeExpression = activeExpression.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getRequiredExpression() requiredExpression} to requiredExpression.
     * @param requiredExpression The value for requiredExpression
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder requiredExpression(Expression requiredExpression) {
      this.requiredExpression = Objects.requireNonNull(requiredExpression, "requiredExpression");
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getRequiredExpression() requiredExpression} to requiredExpression.
     * @param requiredExpression The value for requiredExpression
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder requiredExpression(Optional<? extends Expression> requiredExpression) {
      this.requiredExpression = requiredExpression.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getDisabledExpression() disabledExpression} to disabledExpression.
     * @param disabledExpression The value for disabledExpression
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder disabledExpression(Expression disabledExpression) {
      this.disabledExpression = Objects.requireNonNull(disabledExpression, "disabledExpression");
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getDisabledExpression() disabledExpression} to disabledExpression.
     * @param disabledExpression The value for disabledExpression
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder disabledExpression(Optional<? extends Expression> disabledExpression) {
      this.disabledExpression = disabledExpression.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getLabelExpression() labelExpression} to labelExpression.
     * @param labelExpression The value for labelExpression
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder labelExpression(Expression labelExpression) {
      this.labelExpression = Objects.requireNonNull(labelExpression, "labelExpression");
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getLabelExpression() labelExpression} to labelExpression.
     * @param labelExpression The value for labelExpression
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder labelExpression(Optional<? extends Expression> labelExpression) {
      this.labelExpression = labelExpression.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getDescriptionExpression() descriptionExpression} to descriptionExpression.
     * @param descriptionExpression The value for descriptionExpression
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder descriptionExpression(Expression descriptionExpression) {
      this.descriptionExpression = Objects.requireNonNull(descriptionExpression, "descriptionExpression");
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getDescriptionExpression() descriptionExpression} to descriptionExpression.
     * @param descriptionExpression The value for descriptionExpression
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder descriptionExpression(Optional<? extends Expression> descriptionExpression) {
      this.descriptionExpression = descriptionExpression.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link Group#getErrors() errors} list.
     * @param element A errors element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addErrors(Error element) {
      this.errors.add(Objects.requireNonNull(element, "errors element"));
      return this;
    }

    /**
     * Adds elements to {@link Group#getErrors() errors} list.
     * @param elements An array of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addErrors(Error... elements) {
      for (Error element : elements) {
        this.errors.add(Objects.requireNonNull(element, "errors element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Group#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder errors(Iterable<? extends Error> elements) {
      this.errors.clear();
      return addAllErrors(elements);
    }

    /**
     * Adds elements to {@link Group#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllErrors(Iterable<? extends Error> elements) {
      for (Error element : elements) {
        this.errors.add(Objects.requireNonNull(element, "errors element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Group#getItemsExpression() itemsExpression} attribute.
     * @param itemsExpression The value for itemsExpression 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder itemsExpression(Expression itemsExpression) {
      this.itemsExpression = Objects.requireNonNull(itemsExpression, "itemsExpression");
      initBits &= ~INIT_BIT_ITEMS_EXPRESSION;
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getAvailableItemsExpression() availableItemsExpression} to availableItemsExpression.
     * @param availableItemsExpression The value for availableItemsExpression
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder availableItemsExpression(Expression availableItemsExpression) {
      this.availableItemsExpression = Objects.requireNonNull(availableItemsExpression, "availableItemsExpression");
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getAvailableItemsExpression() availableItemsExpression} to availableItemsExpression.
     * @param availableItemsExpression The value for availableItemsExpression
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder availableItemsExpression(Optional<? extends Expression> availableItemsExpression) {
      this.availableItemsExpression = availableItemsExpression.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getIsInvalidAnswersExpression() isInvalidAnswersExpression} to isInvalidAnswersExpression.
     * @param isInvalidAnswersExpression The value for isInvalidAnswersExpression
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isInvalidAnswersExpression(Expression isInvalidAnswersExpression) {
      this.isInvalidAnswersExpression = Objects.requireNonNull(isInvalidAnswersExpression, "isInvalidAnswersExpression");
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getIsInvalidAnswersExpression() isInvalidAnswersExpression} to isInvalidAnswersExpression.
     * @param isInvalidAnswersExpression The value for isInvalidAnswersExpression
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isInvalidAnswersExpression(Optional<? extends Expression> isInvalidAnswersExpression) {
      this.isInvalidAnswersExpression = isInvalidAnswersExpression.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getAllowedActionsExpression() allowedActionsExpression} to allowedActionsExpression.
     * @param allowedActionsExpression The value for allowedActionsExpression
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder allowedActionsExpression(Expression allowedActionsExpression) {
      this.allowedActionsExpression = Objects.requireNonNull(allowedActionsExpression, "allowedActionsExpression");
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getAllowedActionsExpression() allowedActionsExpression} to allowedActionsExpression.
     * @param allowedActionsExpression The value for allowedActionsExpression
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder allowedActionsExpression(Optional<? extends Expression> allowedActionsExpression) {
      this.allowedActionsExpression = allowedActionsExpression.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getCanAddRowWhenExpression() canAddRowWhenExpression} to canAddRowWhenExpression.
     * @param canAddRowWhenExpression The value for canAddRowWhenExpression
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder canAddRowWhenExpression(Expression canAddRowWhenExpression) {
      this.canAddRowWhenExpression = Objects.requireNonNull(canAddRowWhenExpression, "canAddRowWhenExpression");
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getCanAddRowWhenExpression() canAddRowWhenExpression} to canAddRowWhenExpression.
     * @param canAddRowWhenExpression The value for canAddRowWhenExpression
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder canAddRowWhenExpression(Optional<? extends Expression> canAddRowWhenExpression) {
      this.canAddRowWhenExpression = canAddRowWhenExpression.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getCanRemoveRowWhenExpression() canRemoveRowWhenExpression} to canRemoveRowWhenExpression.
     * @param canRemoveRowWhenExpression The value for canRemoveRowWhenExpression
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder canRemoveRowWhenExpression(Expression canRemoveRowWhenExpression) {
      this.canRemoveRowWhenExpression = Objects.requireNonNull(canRemoveRowWhenExpression, "canRemoveRowWhenExpression");
      return this;
    }

    /**
     * Initializes the optional value {@link Group#getCanRemoveRowWhenExpression() canRemoveRowWhenExpression} to canRemoveRowWhenExpression.
     * @param canRemoveRowWhenExpression The value for canRemoveRowWhenExpression
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder canRemoveRowWhenExpression(Optional<? extends Expression> canRemoveRowWhenExpression) {
      this.canRemoveRowWhenExpression = canRemoveRowWhenExpression.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableGroup ImmutableGroup}.
     * @return An immutable instance of Group
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGroup build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGroup(this);
    }

    private boolean isPrototypeIsSet() {
      return (optBits & OPT_BIT_IS_PROTOTYPE) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_ITEMS_EXPRESSION) != 0) attributes.add("itemsExpression");
      return "Cannot build Group, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
