package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Pair}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePair.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutablePair.of()}.
 */
@Generated(from = "Pair", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePair<L, R> implements Pair<L, R> {
  private final L left;
  private final R right;

  private ImmutablePair(L left, R right) {
    this.left = Objects.requireNonNull(left, "left");
    this.right = Objects.requireNonNull(right, "right");
  }

  private ImmutablePair(ImmutablePair<L, R> original, L left, R right) {
    this.left = left;
    this.right = right;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public L getLeft() {
    return left;
  }

  /**
   * @return The value of the {@code right} attribute
   */
  @Override
  public R getRight() {
    return right;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Pair#getLeft() left} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePair<L, R> withLeft(L value) {
    if (this.left == value) return this;
    L newValue = Objects.requireNonNull(value, "left");
    return new ImmutablePair<>(this, newValue, this.right);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Pair#getRight() right} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for right
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePair<L, R> withRight(R value) {
    if (this.right == value) return this;
    R newValue = Objects.requireNonNull(value, "right");
    return new ImmutablePair<>(this, this.left, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePair} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePair<?, ?>
        && equalTo((ImmutablePair<?, ?>) another);
  }

  private boolean equalTo(ImmutablePair<?, ?> another) {
    return left.equals(another.left)
        && right.equals(another.right);
  }

  /**
   * Computes a hash code from attributes: {@code left}, {@code right}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + left.hashCode();
    h += (h << 5) + right.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Pair} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Pair")
        .omitNullValues()
        .add("left", left)
        .add("right", right)
        .toString();
  }

  /**
   * Construct a new immutable {@code Pair} instance.
 * @param <L> generic parameter L
 * @param <R> generic parameter R
   * @param left The value for the {@code left} attribute
   * @param right The value for the {@code right} attribute
   * @return An immutable Pair instance
   */
  public static <L, R> ImmutablePair<L, R> of(L left, R right) {
    return new ImmutablePair<>(left, right);
  }

  /**
   * Creates an immutable copy of a {@link Pair} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <L> generic parameter L
   * @param <R> generic parameter R
   * @param instance The instance to copy
   * @return A copied immutable Pair instance
   */
  public static <L, R> ImmutablePair<L, R> copyOf(Pair<L, R> instance) {
    if (instance instanceof ImmutablePair<?, ?>) {
      return (ImmutablePair<L, R>) instance;
    }
    return ImmutablePair.<L, R>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePair ImmutablePair}.
   * <pre>
   * ImmutablePair.&amp;lt;L, R&amp;gt;builder()
   *    .left(L) // required {@link Pair#getLeft() left}
   *    .right(R) // required {@link Pair#getRight() right}
   *    .build();
   * </pre>
   * @param <L> generic parameter L
   * @param <R> generic parameter R
   * @return A new ImmutablePair builder
   */
  public static <L, R> ImmutablePair.Builder<L, R> builder() {
    return new ImmutablePair.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutablePair ImmutablePair}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Pair", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<L, R> {
    private static final long INIT_BIT_LEFT = 0x1L;
    private static final long INIT_BIT_RIGHT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable L left;
    private @Nullable R right;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Pair} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<L, R> from(Pair<L, R> instance) {
      Objects.requireNonNull(instance, "instance");
      left(instance.getLeft());
      right(instance.getRight());
      return this;
    }

    /**
     * Initializes the value for the {@link Pair#getLeft() left} attribute.
     * @param left The value for left 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<L, R> left(L left) {
      this.left = Objects.requireNonNull(left, "left");
      initBits &= ~INIT_BIT_LEFT;
      return this;
    }

    /**
     * Initializes the value for the {@link Pair#getRight() right} attribute.
     * @param right The value for right 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<L, R> right(R right) {
      this.right = Objects.requireNonNull(right, "right");
      initBits &= ~INIT_BIT_RIGHT;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePair ImmutablePair}.
     * @return An immutable instance of Pair
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePair<L, R> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePair<>(null, left, right);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LEFT) != 0) attributes.add("left");
      if ((initBits & INIT_BIT_RIGHT) != 0) attributes.add("right");
      return "Cannot build Pair, some of required attributes are not set " + attributes;
    }
  }
}
